/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.resolver.dns;

import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import org.apache.hive.druid.io.netty.channel.DefaultEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.EventLoop;
import org.apache.hive.druid.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.hive.druid.io.netty.resolver.AddressResolver;
import org.apache.hive.druid.io.netty.resolver.dns.DnsAddressResolverGroup;
import org.apache.hive.druid.io.netty.resolver.dns.DnsNameResolverBuilder;
import org.apache.hive.druid.io.netty.util.concurrent.EventExecutor;
import org.apache.hive.druid.io.netty.util.concurrent.Future;
import org.apache.hive.druid.io.netty.util.concurrent.FutureListener;
import org.apache.hive.druid.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hive.druid.io.netty.util.concurrent.Promise;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DnsAddressResolverGroupTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseConfiguredEventLoop() throws InterruptedException {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        final EventLoop loop = group.next();
        DefaultEventLoopGroup defaultEventLoopGroup = new DefaultEventLoopGroup(1);
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder().eventLoop(loop).channelType(NioDatagramChannel.class);
        DnsAddressResolverGroup resolverGroup = new DnsAddressResolverGroup(builder);
        try {
            final Promise promise = loop.newPromise();
            AddressResolver resolver = resolverGroup.getResolver((EventExecutor)defaultEventLoopGroup.next());
            resolver.resolve(new SocketAddress(){
                private static final long serialVersionUID = 3169703458729818468L;
            }).addListener((GenericFutureListener)new FutureListener<Object>(){

                public void operationComplete(Future<Object> future) {
                    try {
                        MatcherAssert.assertThat((Object)future.cause(), (Matcher)Matchers.instanceOf(UnsupportedAddressTypeException.class));
                        Assertions.assertTrue((boolean)loop.inEventLoop());
                        promise.setSuccess(null);
                    }
                    catch (Throwable cause) {
                        promise.setFailure(cause);
                    }
                }
            }).await();
            promise.sync();
        }
        finally {
            resolverGroup.close();
            group.shutdownGracefully();
            defaultEventLoopGroup.shutdownGracefully();
        }
    }
}

