/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.smtp;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.DecoderException;
import org.apache.hive.druid.io.netty.handler.codec.smtp.SmtpResponse;
import org.apache.hive.druid.io.netty.handler.codec.smtp.SmtpResponseDecoder;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class SmtpResponseDecoderTest {
    @Test
    public void testDecodeOneLineResponse() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200 Ok\r\n")}));
        Assertions.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assertions.assertEquals((int)200, (int)response.code());
        List sequences = response.details();
        Assertions.assertEquals((int)1, (int)sequences.size());
        Assertions.assertEquals((Object)"Ok", (Object)((CharSequence)sequences.get(0)).toString());
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testDecodeOneLineResponseNoDetails() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("250 \r\n")}));
        Assertions.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assertions.assertEquals((int)250, (int)response.code());
        List sequences = response.details();
        Assertions.assertEquals((int)0, (int)sequences.size());
    }

    @Test
    public void testDecodeOneLineResponseChunked() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200 Ok")}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("\r\n")}));
        Assertions.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assertions.assertEquals((int)200, (int)response.code());
        List sequences = response.details();
        Assertions.assertEquals((int)1, (int)sequences.size());
        Assertions.assertEquals((Object)"Ok", (Object)((CharSequence)sequences.get(0)).toString());
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testDecodeTwoLineResponse() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200-Hello\r\n200 Ok\r\n")}));
        Assertions.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assertions.assertEquals((int)200, (int)response.code());
        List sequences = response.details();
        Assertions.assertEquals((int)2, (int)sequences.size());
        Assertions.assertEquals((Object)"Hello", (Object)((CharSequence)sequences.get(0)).toString());
        Assertions.assertEquals((Object)"Ok", (Object)((CharSequence)sequences.get(1)).toString());
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testDecodeTwoLineResponseChunked() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200-")}));
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("Hello\r\n2")}));
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("00 Ok")}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("\r\n")}));
        Assertions.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assertions.assertEquals((int)200, (int)response.code());
        List sequences = response.details();
        Assertions.assertEquals((int)2, (int)sequences.size());
        Assertions.assertEquals((Object)"Hello", (Object)((CharSequence)sequences.get(0)).toString());
        Assertions.assertEquals((Object)"Ok", (Object)((CharSequence)sequences.get(1)).toString());
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testDecodeInvalidSeparator() {
        final EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assertions.assertThrows(DecoderException.class, (Executable)new Executable(){

            public void execute() {
                channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200:Ok\r\n")});
            }
        });
    }

    @Test
    public void testDecodeInvalidCode() {
        final EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assertions.assertThrows(DecoderException.class, (Executable)new Executable(){

            public void execute() {
                channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("xyz Ok\r\n")});
            }
        });
    }

    @Test
    public void testDecodeInvalidLine() {
        final EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assertions.assertThrows(DecoderException.class, (Executable)new Executable(){

            public void execute() {
                channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("Ok\r\n")});
            }
        });
    }

    private static EmbeddedChannel newChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new SmtpResponseDecoder(Integer.MAX_VALUE)});
    }

    private static ByteBuf newBuffer(CharSequence seq) {
        return Unpooled.copiedBuffer((CharSequence)seq, (Charset)CharsetUtil.US_ASCII);
    }
}

