/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.memcache.binary;

import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheObjectAggregator;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheResponseDecoder;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheResponseEncoder;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheResponse;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FullMemcacheMessageResponseTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BinaryMemcacheResponseEncoder(), new BinaryMemcacheResponseDecoder(), new BinaryMemcacheObjectAggregator(1024)});
    }

    @AfterEach
    public void teardown() throws Exception {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testEncodeDecode() throws Exception {
        ByteBuf key = Unpooled.wrappedBuffer((byte[])"key".getBytes(CharsetUtil.UTF_8));
        ByteBuf content = Unpooled.wrappedBuffer((byte[])"content".getBytes(CharsetUtil.UTF_8));
        ByteBuf extras = Unpooled.wrappedBuffer((byte[])"extras".getBytes(CharsetUtil.UTF_8));
        DefaultFullBinaryMemcacheResponse resp = new DefaultFullBinaryMemcacheResponse(key, extras, content);
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{resp}));
        Assertions.assertEquals((int)2, (int)this.channel.outboundMessages().size());
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{this.channel.readOutbound(), this.channel.readOutbound()}));
        FullBinaryMemcacheResponse read = (FullBinaryMemcacheResponse)this.channel.readInbound();
        Assertions.assertEquals((Object)"key", (Object)read.key().toString(CharsetUtil.UTF_8));
        Assertions.assertEquals((Object)"content", (Object)read.content().toString(CharsetUtil.UTF_8));
        Assertions.assertEquals((Object)"extras", (Object)read.extras().toString(CharsetUtil.UTF_8));
        read.release();
    }
}

