/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.dns;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsRecordType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DnsRecordTypeTest {
    private static List<DnsRecordType> allTypes() throws Exception {
        ArrayList<DnsRecordType> result = new ArrayList<DnsRecordType>();
        for (Field field : DnsRecordType.class.getFields()) {
            if ((field.getModifiers() & 8) == 0 || field.getType() != DnsRecordType.class) continue;
            result.add((DnsRecordType)field.get(null));
        }
        Assertions.assertFalse((boolean)result.isEmpty());
        return result;
    }

    @Test
    public void testSanity() throws Exception {
        Assertions.assertEquals((int)DnsRecordTypeTest.allTypes().size(), (int)new HashSet<DnsRecordType>(DnsRecordTypeTest.allTypes()).size(), (String)"More than one type has the same int value");
    }

    @Test
    public void testHashCode() throws Exception {
        for (DnsRecordType t : DnsRecordTypeTest.allTypes()) {
            Assertions.assertEquals((int)t.intValue(), (int)t.hashCode());
        }
    }

    @Test
    public void testEquals() throws Exception {
        for (DnsRecordType t1 : DnsRecordTypeTest.allTypes()) {
            for (DnsRecordType t2 : DnsRecordTypeTest.allTypes()) {
                if (t1 == t2) continue;
                Assertions.assertNotEquals((Object)t1, (Object)t2);
            }
        }
    }

    @Test
    public void testFind() throws Exception {
        for (DnsRecordType t : DnsRecordTypeTest.allTypes()) {
            DnsRecordType found = DnsRecordType.valueOf((int)t.intValue());
            Assertions.assertSame((Object)t, (Object)found);
            found = DnsRecordType.valueOf((String)t.name());
            Assertions.assertSame((Object)t, (Object)found, (String)t.name());
        }
    }
}

