/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.kqueue;

import java.io.FileNotFoundException;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueSocketTestPermutation;
import org.apache.hive.druid.io.netty.channel.unix.DomainDatagramPacket;
import org.apache.hive.druid.io.netty.testsuite.transport.AbstractTestsuiteTest;
import org.apache.hive.druid.io.netty.testsuite.transport.TestsuitePermutation;
import org.apache.hive.druid.io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class KQueueDomainDatagramPathTest
extends AbstractClientSocketTest {
    KQueueDomainDatagramPathTest() {
    }

    @Test
    void testConnectPathDoesNotExist(TestInfo testInfo) throws Throwable {
        this.run(testInfo, (AbstractTestsuiteTest.Runner)new AbstractTestsuiteTest.Runner<Bootstrap>(){

            public void run(Bootstrap bootstrap) {
                try {
                    ((Bootstrap)bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter())).connect((SocketAddress)KQueueSocketTestPermutation.newSocketAddress()).sync().channel();
                    Assertions.fail((String)"Expected FileNotFoundException");
                }
                catch (Exception e) {
                    Assertions.assertTrue((boolean)(e instanceof FileNotFoundException));
                }
            }
        });
    }

    @Test
    void testWriteReceiverPathDoesNotExist(TestInfo testInfo) throws Throwable {
        this.run(testInfo, (AbstractTestsuiteTest.Runner)new AbstractTestsuiteTest.Runner<Bootstrap>(){

            public void run(Bootstrap bootstrap) {
                try {
                    Channel ch = ((Bootstrap)bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)KQueueSocketTestPermutation.newSocketAddress()).sync().channel();
                    ch.writeAndFlush((Object)new DomainDatagramPacket(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII), KQueueSocketTestPermutation.newSocketAddress())).sync();
                    Assertions.fail((String)"Expected FileNotFoundException");
                }
                catch (Exception e) {
                    Assertions.assertTrue((boolean)(e instanceof FileNotFoundException));
                }
            }
        });
    }

    protected List<TestsuitePermutation.BootstrapFactory<Bootstrap>> newFactories() {
        return KQueueSocketTestPermutation.INSTANCE.domainDatagramSocket();
    }
}

