/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.log;

import java.io.IOException;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.server.QueryStats;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.log.FilteredRequestLoggerProvider;
import org.apache.hive.druid.io.druid.server.log.RequestLogger;
import org.easymock.EasyMock;
import org.junit.Test;

public class FilteredRequestLoggerTest {
    @Test
    public void testFilterBelowThreshold() throws IOException {
        RequestLogger delegate = (RequestLogger)EasyMock.createStrictMock(RequestLogger.class);
        delegate.log((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new IOException());
        FilteredRequestLoggerProvider.FilteredRequestLogger logger = new FilteredRequestLoggerProvider.FilteredRequestLogger(delegate, 1000L);
        RequestLogLine requestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)requestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)100))).once();
        EasyMock.replay((Object[])new Object[]{requestLogLine, delegate});
        logger.log(requestLogLine);
    }

    @Test
    public void testNotFilterAboveThreshold() throws IOException {
        RequestLogger delegate = (RequestLogger)EasyMock.createStrictMock(RequestLogger.class);
        delegate.log((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall().times(2);
        FilteredRequestLoggerProvider.FilteredRequestLogger logger = new FilteredRequestLoggerProvider.FilteredRequestLogger(delegate, 1000L);
        RequestLogLine requestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)requestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)10000))).once();
        EasyMock.expect((Object)requestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)1000))).once();
        EasyMock.replay((Object[])new Object[]{requestLogLine, delegate});
        logger.log(requestLogLine);
        logger.log(requestLogLine);
        EasyMock.verify((Object[])new Object[]{requestLogLine, delegate});
    }
}

