/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.listener.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.server.listener.resource.ExceptionalAbstractListenerHandler;
import org.apache.hive.druid.io.druid.server.listener.resource.ListenerHandler;
import org.apache.hive.druid.io.druid.server.listener.resource.ListenerResource;
import org.apache.hive.druid.io.druid.server.listener.resource.SomeBeanClass;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListenerResourceTest {
    static final String ANN_ID = "announce_id";
    HttpServletRequest req;
    final ObjectMapper mapper = new DefaultObjectMapper();
    private static final ByteSource EMPTY_JSON_MAP = new ByteSource(){

        public InputStream openStream() throws IOException {
            return new ByteArrayInputStream(StringUtils.toUtf8((String)"{}"));
        }
    };

    @Before
    public void setUp() throws Exception {
        this.mapper.registerSubtypes(new Class[]{SomeBeanClass.class});
        this.req = (HttpServletRequest)EasyMock.createNiceMock(HttpServletRequest.class);
        EasyMock.expect((Object)this.req.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.req});
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testServiceAnnouncementPOSTExceptionInHandler() throws Exception {
        ListenerHandler handler = (ListenerHandler)EasyMock.createStrictMock(ListenerHandler.class);
        EasyMock.expect((Object)handler.handlePOST((InputStream)EasyMock.anyObject(), (ObjectMapper)EasyMock.anyObject(), EasyMock.anyString())).andThrow((Throwable)new RuntimeException("test"));
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, handler){};
        EasyMock.replay((Object[])new Object[]{handler});
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)resource.serviceAnnouncementPOST("id", EMPTY_JSON_MAP.openStream(), this.req).getStatus());
        EasyMock.verify((Object[])new Object[]{this.req, handler});
    }

    @Test
    public void testServiceAnnouncementPOSTAllExceptionInHandler() throws Exception {
        ListenerHandler handler = (ListenerHandler)EasyMock.createStrictMock(ListenerHandler.class);
        EasyMock.expect((Object)handler.handlePOSTAll((InputStream)EasyMock.anyObject(), (ObjectMapper)EasyMock.anyObject())).andThrow((Throwable)new RuntimeException("test"));
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, handler){};
        EasyMock.replay((Object[])new Object[]{handler});
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)resource.serviceAnnouncementPOSTAll(EMPTY_JSON_MAP.openStream(), this.req).getStatus());
        EasyMock.verify((Object[])new Object[]{this.req, handler});
    }

    @Test
    public void testServiceAnnouncementPOST() throws Exception {
        final AtomicInteger c = new AtomicInteger(0);
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, (ListenerHandler)new ExceptionalAbstractListenerHandler(){

            @Override
            public Object post(Map<String, SomeBeanClass> l) {
                c.incrementAndGet();
                return l;
            }
        }){};
        Assert.assertEquals((long)202L, (long)resource.serviceAnnouncementPOSTAll(EMPTY_JSON_MAP.openStream(), this.req).getStatus());
        Assert.assertEquals((long)1L, (long)c.get());
        EasyMock.verify((Object[])new Object[]{this.req});
    }

    @Test
    public void testServiceAnnouncementGET() throws Exception {
        final AtomicInteger c = new AtomicInteger(0);
        ExceptionalAbstractListenerHandler handler = new ExceptionalAbstractListenerHandler(){

            @Override
            public Object get(String id) {
                c.incrementAndGet();
                return ListenerResourceTest.ANN_ID.equals(id) ? ListenerResourceTest.ANN_ID : null;
            }
        };
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, (ListenerHandler)handler){};
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)resource.serviceAnnouncementGET(ANN_ID).getStatus());
        Assert.assertEquals((long)1L, (long)c.get());
        EasyMock.verify((Object[])new Object[]{this.req});
    }

    @Test
    public void testServiceAnnouncementGETNull() throws Exception {
        ExceptionalAbstractListenerHandler handler = new ExceptionalAbstractListenerHandler();
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, (ListenerHandler)handler){};
        Assert.assertEquals((long)400L, (long)resource.serviceAnnouncementGET(null).getStatus());
        Assert.assertEquals((long)400L, (long)resource.serviceAnnouncementGET("").getStatus());
        EasyMock.verify((Object[])new Object[]{this.req});
    }

    @Test
    public void testServiceAnnouncementGETExceptionInHandler() throws Exception {
        ListenerHandler handler = (ListenerHandler)EasyMock.createStrictMock(ListenerHandler.class);
        EasyMock.expect((Object)handler.handleGET(EasyMock.anyString())).andThrow((Throwable)new RuntimeException("test"));
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, handler){};
        EasyMock.replay((Object[])new Object[]{handler});
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)resource.serviceAnnouncementGET("id").getStatus());
        EasyMock.verify((Object[])new Object[]{handler});
    }

    @Test
    public void testServiceAnnouncementGETAllExceptionInHandler() throws Exception {
        ListenerHandler handler = (ListenerHandler)EasyMock.createStrictMock(ListenerHandler.class);
        EasyMock.expect((Object)handler.handleGETAll()).andThrow((Throwable)new RuntimeException("test"));
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, handler){};
        EasyMock.replay((Object[])new Object[]{handler});
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)resource.getAll().getStatus());
        EasyMock.verify((Object[])new Object[]{handler});
    }

    @Test
    public void testServiceAnnouncementDELETENullID() throws Exception {
        ExceptionalAbstractListenerHandler handler = new ExceptionalAbstractListenerHandler();
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, (ListenerHandler)handler){};
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)resource.serviceAnnouncementDELETE(null).getStatus());
    }

    @Test
    public void testServiceAnnouncementDELETEExceptionInHandler() throws Exception {
        ListenerHandler handler = (ListenerHandler)EasyMock.createStrictMock(ListenerHandler.class);
        EasyMock.expect((Object)handler.handleDELETE(EasyMock.anyString())).andThrow((Throwable)new RuntimeException("test"));
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, handler){};
        EasyMock.replay((Object[])new Object[]{handler});
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)resource.serviceAnnouncementDELETE("id").getStatus());
        EasyMock.verify((Object[])new Object[]{handler});
    }

    @Test
    public void testServiceAnnouncementDELETE() throws Exception {
        final AtomicInteger c = new AtomicInteger(0);
        ExceptionalAbstractListenerHandler handler = new ExceptionalAbstractListenerHandler(){

            @Override
            public Object delete(String id) {
                c.incrementAndGet();
                return ListenerResourceTest.ANN_ID.equals(id) ? ListenerResourceTest.ANN_ID : null;
            }
        };
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, (ListenerHandler)handler){};
        Assert.assertEquals((long)202L, (long)resource.serviceAnnouncementDELETE(ANN_ID).getStatus());
        Assert.assertEquals((long)1L, (long)c.get());
        EasyMock.verify((Object[])new Object[]{this.req});
    }

    @Test
    public void testAbstractPostHandler() throws Exception {
        ExceptionalAbstractListenerHandler handler = new ExceptionalAbstractListenerHandler(){

            @Override
            @Nullable
            public String post(@NotNull Map<String, SomeBeanClass> inputObject) throws Exception {
                return ListenerResourceTest.this.mapper.writeValueAsString(inputObject);
            }
        };
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, (ListenerHandler)handler){};
        ImmutableList strings = ImmutableList.of((Object)"test1", (Object)"test2");
        HashMap<String, SomeBeanClass> expectedMap = new HashMap<String, SomeBeanClass>();
        for (String str : strings) {
            expectedMap.put(str, new SomeBeanClass(str));
        }
        String expectedString = this.mapper.writeValueAsString(expectedMap);
        Response response = resource.serviceAnnouncementPOSTAll((InputStream)new ByteArrayInputStream(StringUtils.toUtf8((String)expectedString)), this.req);
        Assert.assertEquals((long)Response.Status.ACCEPTED.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)expectedString, (Object)response.getEntity());
    }

    @Test
    public void testAbstractPostHandlerEmptyList() throws Exception {
        ExceptionalAbstractListenerHandler handler = new ExceptionalAbstractListenerHandler(){

            @Override
            public String post(Map<String, SomeBeanClass> inputObject) throws Exception {
                return ListenerResourceTest.this.mapper.writeValueAsString(inputObject);
            }
        };
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, (ListenerHandler)handler){};
        Response response = resource.serviceAnnouncementPOSTAll(EMPTY_JSON_MAP.openStream(), this.req);
        Assert.assertEquals((long)Response.Status.ACCEPTED.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"{}", (Object)response.getEntity());
    }

    @Test
    public void testAbstractPostHandlerException() throws Exception {
        ExceptionalAbstractListenerHandler handler = new ExceptionalAbstractListenerHandler(){

            @Override
            public String post(Map<String, SomeBeanClass> inputObject) throws Exception {
                throw new UnsupportedOperationException("nope!");
            }
        };
        ListenerResource resource = new ListenerResource(this.mapper, this.mapper, (ListenerHandler)handler){};
        Response response = resource.serviceAnnouncementPOSTAll((InputStream)new ByteArrayInputStream(StringUtils.toUtf8((String)this.mapper.writeValueAsString((Object)ImmutableMap.of((Object)"test1", (Object)new SomeBeanClass("test1"), (Object)"test2", (Object)new SomeBeanClass("test2"))))), this.req);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }
}

