/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.io.druid.java.util.emitter.core.LoggingEmitter;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.hive.druid.io.druid.server.coordinator.ReplicationThrottler;
import org.apache.hive.druid.io.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.rules.LoadRule;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoadRuleTest {
    private static final Logger log = new Logger(LoadRuleTest.class);
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private static final ServiceEmitter emitter = new ServiceEmitter("service", "host", (Emitter)new LoggingEmitter(log, LoggingEmitter.Level.ERROR, jsonMapper));
    private ReplicationThrottler throttler;
    private ListeningExecutorService exec;
    private BalancerStrategy balancerStrategy;
    private BalancerStrategy mockBalancerStrategy;

    @Before
    public void setUp() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)emitter);
        emitter.start();
        this.throttler = (ReplicationThrottler)EasyMock.createMock(ReplicationThrottler.class);
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        this.balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(this.exec);
        this.mockBalancerStrategy = (BalancerStrategy)EasyMock.createMock(BalancerStrategy.class);
    }

    @After
    public void tearDown() throws Exception {
        this.exec.shutdown();
        emitter.close();
    }

    @Test
    public void testLoad() throws Exception {
        EasyMock.expect((Object)this.throttler.canCreateReplicant(EasyMock.anyString())).andReturn((Object)true).anyTimes();
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"hot", (Object)1, (Object)"_default_tier", (Object)2));
        DataSegment segment = this.createDataSegment("foo");
        this.throttler.registerReplicantCreation("_default_tier", segment.getIdentifier(), "hostNorm");
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(3);
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer(), mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"_default_tier", (Object)Stream.of(new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        CoordinatorStats stats = rule.run(null, DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster)).withReplicationManager(this.throttler).withBalancerStrategy(this.mockBalancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withAvailableSegments(Arrays.asList(segment)).build(), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "_default_tier"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
    }

    @Test
    public void testLoadPriority() throws Exception {
        EasyMock.expect((Object)this.throttler.canCreateReplicant(EasyMock.anyString())).andReturn((Object)false).anyTimes();
        LoadQueuePeon mockPeon1 = LoadRuleTest.createEmptyPeon();
        LoadQueuePeon mockPeon2 = LoadRuleTest.createEmptyPeon();
        mockPeon2.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.isNull());
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(2);
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon1, mockPeon2, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)10, (Object)"tier2", (Object)10));
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"tier1", (Object)Stream.of(new ServerHolder(new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "tier1", 0).toImmutableDruidServer(), mockPeon1)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"tier2", (Object)Stream.of(new ServerHolder(new DruidServer("server2", "host2", null, 1000L, ServerType.HISTORICAL, "tier2", 1).toImmutableDruidServer(), mockPeon2), new ServerHolder(new DruidServer("server3", "host3", null, 1000L, ServerType.HISTORICAL, "tier2", 1).toImmutableDruidServer(), mockPeon2)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        DataSegment segment = this.createDataSegment("foo");
        CoordinatorStats stats = rule.run(null, DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster)).withReplicationManager(this.throttler).withBalancerStrategy(this.mockBalancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withAvailableSegments(Collections.singletonList(segment)).build(), segment);
        Assert.assertEquals((long)0L, (long)stats.getTieredStat("assignedCount", "tier1"));
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "tier2"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon1, mockPeon2, this.mockBalancerStrategy});
    }

    @Test
    public void testDrop() throws Exception {
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"hot", (Object)0, (Object)"_default_tier", (Object)0));
        DataSegment segment = this.createDataSegment("foo");
        DruidServer server1 = new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        server1.addDataSegment(segment);
        DruidServer server2 = new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0);
        server2.addDataSegment(segment);
        DruidServer server3 = new DruidServer("serverNormNotServing", "hostNorm", null, 10L, ServerType.HISTORICAL, "_default_tier", 0);
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(server1.toImmutableDruidServer(), mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"_default_tier", (Object)Stream.of(new ServerHolder(server2.toImmutableDruidServer(), mockPeon), new ServerHolder(server3.toImmutableDruidServer(), mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        CoordinatorStats stats = rule.run(null, DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster)).withReplicationManager(this.throttler).withBalancerStrategy(this.mockBalancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withAvailableSegments(Arrays.asList(segment)).build(), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "hot"));
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "_default_tier"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon});
    }

    @Test
    public void testLoadWithNonExistentTier() throws Exception {
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(1);
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"nonExistentTier", (Object)1, (Object)"hot", (Object)1));
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        DataSegment segment = this.createDataSegment("foo");
        CoordinatorStats stats = rule.run(null, DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster())).withReplicationManager(this.throttler).withBalancerStrategy(this.mockBalancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withAvailableSegments(Arrays.asList(segment)).build(), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "hot"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
    }

    @Test
    public void testDropWithNonExistentTier() throws Exception {
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"nonExistentTier", (Object)1, (Object)"hot", (Object)1));
        DataSegment segment = this.createDataSegment("foo");
        DruidServer server1 = new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        DruidServer server2 = new DruidServer("serverHo2t", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        server1.addDataSegment(segment);
        server2.addDataSegment(segment);
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(server1.toImmutableDruidServer(), mockPeon), new ServerHolder(server2.toImmutableDruidServer(), mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        CoordinatorStats stats = rule.run(null, DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster)).withReplicationManager(this.throttler).withBalancerStrategy(this.mockBalancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withAvailableSegments(Arrays.asList(segment)).build(), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "hot"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
    }

    @Test
    public void testMaxLoadingQueueSize() throws Exception {
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(2);
        EasyMock.replay((Object[])new Object[]{this.throttler, this.mockBalancerStrategy});
        LoadQueuePeonTester peon = new LoadQueuePeonTester();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"hot", (Object)1));
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), (LoadQueuePeon)peon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        DataSegment dataSegment1 = this.createDataSegment("ds1");
        DataSegment dataSegment2 = this.createDataSegment("ds2");
        DataSegment dataSegment3 = this.createDataSegment("ds3");
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster)).withReplicationManager(this.throttler).withBalancerStrategy(this.mockBalancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withAvailableSegments(Arrays.asList(dataSegment1, dataSegment2, dataSegment3)).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMaxSegmentsInNodeLoadingQueue(2).build()).build();
        CoordinatorStats stats1 = rule.run(null, params, dataSegment1);
        CoordinatorStats stats2 = rule.run(null, params, dataSegment2);
        CoordinatorStats stats3 = rule.run(null, params, dataSegment3);
        Assert.assertEquals((long)1L, (long)stats1.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)1L, (long)stats2.getTieredStat("assignedCount", "hot"));
        Assert.assertFalse((boolean)stats3.getTiers("assignedCount").contains("hot"));
        EasyMock.verify((Object[])new Object[]{this.throttler, this.mockBalancerStrategy});
    }

    private DataSegment createDataSegment(String dataSource) {
        return new DataSegment(dataSource, Intervals.of((String)"0/3000"), DateTimes.nowUtc().toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L);
    }

    private static LoadRule createLoadRule(final Map<String, Integer> tieredReplicants) {
        return new LoadRule(){

            public Map<String, Integer> getTieredReplicants() {
                return tieredReplicants;
            }

            public int getNumReplicants(String tier) {
                return (Integer)tieredReplicants.get(tier);
            }

            public String getType() {
                return "test";
            }

            public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
                return true;
            }

            public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
                return true;
            }
        };
    }

    private static LoadQueuePeon createEmptyPeon() {
        LoadQueuePeon mockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
        EasyMock.expect((Object)mockPeon.getSegmentsToLoad()).andReturn((Object)Sets.newHashSet()).anyTimes();
        EasyMock.expect((Object)mockPeon.getSegmentsMarkedToDrop()).andReturn((Object)Sets.newHashSet()).anyTimes();
        EasyMock.expect((Object)mockPeon.getLoadQueueSize()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)mockPeon.getNumberOfSegmentsInQueue()).andReturn((Object)0).anyTimes();
        return mockPeon;
    }
}

