/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import com.carrotsearch.junitbenchmarks.AbstractBenchmark;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategyTest;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Ignore
@RunWith(value=Parameterized.class)
public class CostBalancerStrategyBenchmark
extends AbstractBenchmark {
    private final CostBalancerStrategy strategy;
    private static List<ServerHolder> serverHolderList;
    volatile ServerHolder selected;
    private final Interval interval1 = Intervals.of((String)"2015-01-01T01:00:00Z/2015-01-01T02:00:00Z");
    private final Interval interval2 = Intervals.of((String)"2015-02-01T01:00:00Z/2015-02-01T02:00:00Z");
    volatile Long sum;

    @Parameterized.Parameters
    public static List<CostBalancerStrategy[]> factoryClasses() {
        return Arrays.asList((CostBalancerStrategy[])Arrays.asList(new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1)))).toArray(), (CostBalancerStrategy[])Arrays.asList(new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(4)))).toArray());
    }

    public CostBalancerStrategyBenchmark(CostBalancerStrategy costBalancerStrategy) {
        this.strategy = costBalancerStrategy;
    }

    @BeforeClass
    public static void setup() {
        serverHolderList = CostBalancerStrategyTest.setupDummyCluster(5, 20000);
    }

    @AfterClass
    public static void tearDown() {
        serverHolderList = null;
    }

    @Test
    @BenchmarkOptions(warmupRounds=10, benchmarkRounds=1000)
    public void testBenchmark() throws InterruptedException {
        DataSegment segment = CostBalancerStrategyTest.getSegment(1000, "testds", this.interval1);
        this.selected = this.strategy.findNewSegmentHomeReplicator(segment, serverHolderList);
    }

    @BenchmarkOptions(warmupRounds=1000, benchmarkRounds=1000000)
    @Test
    public void testJodaGap() {
        long diff = 0L;
        for (int i = 0; i < 1000; ++i) {
            diff += this.interval1.gap((ReadableInterval)this.interval2).toDurationMillis();
        }
        this.sum = diff;
    }
}

