/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeseries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.UnionDataSource;
import org.apache.hive.druid.io.druid.query.UnionQueryRunner;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeSeriesUnionQueryRunnerTest {
    private final QueryRunner runner;
    private final boolean descending;

    public TimeSeriesUnionQueryRunnerTest(QueryRunner runner, boolean descending) {
        this.runner = runner;
        this.descending = descending;
    }

    @Parameterized.Parameters(name="{0}:descending={1}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.cartesian(QueryRunnerTestHelper.makeUnionQueryRunners((QueryRunnerFactory)new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER)), Arrays.asList(false, true));
    }

    private <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results) {
        if (this.descending) {
            expectedResults = TestHelper.revert(expectedResults);
        }
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testUnionTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)QueryRunnerTestHelper.unionDataSource).granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)52L, (Object)"idx", (Object)26476L, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)52L, (Object)"idx", (Object)23308L, (Object)"uniques", (Object)9.019833517963864))));
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testUnionResultMerging() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new UnionDataSource((List)Lists.newArrayList((Object[])new TableDataSource[]{new TableDataSource("ds1"), new TableDataSource("ds2")}))).granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).build();
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        final ArrayList ds1 = Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"idx", (Object)2L))), new Result(DateTimes.of((String)"2011-04-03"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"idx", (Object)4L)))});
        final ArrayList ds2 = Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)5L, (Object)"idx", (Object)6L))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)7L, (Object)"idx", (Object)8L))), new Result(DateTimes.of((String)"2011-04-04"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"idx", (Object)10L)))});
        QueryRunner mergingrunner = toolChest.mergeResults((QueryRunner)new UnionQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> responseContext) {
                if (queryPlus.getQuery().getDataSource().equals(new TableDataSource("ds1"))) {
                    return Sequences.simple((Iterable)(TimeSeriesUnionQueryRunnerTest.this.descending ? Lists.reverse((List)ds1) : ds1));
                }
                return Sequences.simple((Iterable)(TimeSeriesUnionQueryRunnerTest.this.descending ? Lists.reverse((List)ds2) : ds2));
            }
        }));
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)5L, (Object)"idx", (Object)6L))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)8L, (Object)"idx", (Object)10L))), new Result(DateTimes.of((String)"2011-04-03"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"idx", (Object)4L))), new Result(DateTimes.of((String)"2011-04-04"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"idx", (Object)10L))));
        List results = Sequences.toList((Sequence)mergingrunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        this.assertExpectedResults(expectedResults, results);
    }
}

