/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.query.CachingEmitter;
import org.apache.hive.druid.io.druid.query.DefaultQueryMetricsTest;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.select.DefaultSelectQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.select.PagingSpec;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQueryMetrics;
import org.joda.time.Interval;
import org.joda.time.base.AbstractInterval;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSelectQueryMetricsTest {
    @Test
    public void testDefaultSelectQueryMetricsQuery() {
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        SelectQuery query = Druids.newSelectQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.fullOnInterval).descending(true).pagingSpec(PagingSpec.newSpec((int)1)).build();
        SelectQueryMetrics queryMetrics = DefaultSelectQueryMetricsFactory.instance().makeMetrics(query);
        queryMetrics.query((Query)query);
        queryMetrics.reportQueryTime(0L).emit(serviceEmitter);
        Map actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((long)12L, (long)actualEvent.size());
        Assert.assertTrue((boolean)actualEvent.containsKey("feed"));
        Assert.assertTrue((boolean)actualEvent.containsKey("timestamp"));
        Assert.assertEquals((Object)"", actualEvent.get("host"));
        Assert.assertEquals((Object)"", actualEvent.get("service"));
        Assert.assertEquals((Object)"testing", actualEvent.get("dataSource"));
        Assert.assertEquals((Object)query.getType(), actualEvent.get("type"));
        List expectedIntervals = QueryRunnerTestHelper.fullOnInterval.getIntervals();
        List expectedStringIntervals = expectedIntervals.stream().map(AbstractInterval::toString).collect(Collectors.toList());
        Assert.assertEquals(expectedStringIntervals, actualEvent.get("interval"));
        Assert.assertEquals((Object)"false", actualEvent.get("hasFilters"));
        Assert.assertEquals((Object)((Interval)expectedIntervals.get(0)).toDuration().toString(), actualEvent.get("duration"));
        Assert.assertEquals((Object)"", actualEvent.get("id"));
        Assert.assertEquals((Object)"query/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)0L, actualEvent.get("value"));
    }

    @Test
    public void testDefaultSelectQueryMetricsMetricNamesAndUnits() {
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        SelectQuery query = Druids.newSelectQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.fullOnInterval).descending(true).pagingSpec(PagingSpec.newSpec((int)1)).build();
        SelectQueryMetrics queryMetrics = DefaultSelectQueryMetricsFactory.instance().makeMetrics(query);
        DefaultQueryMetricsTest.testQueryMetricsDefaultMetricNamesAndUnits(cachingEmitter, serviceEmitter, queryMetrics);
    }
}

