/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.ExtractionDimFilter;
import org.apache.hive.druid.io.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.search.FragmentSearchQuerySpec;
import org.apache.hive.druid.io.druid.query.search.SearchHit;
import org.apache.hive.druid.io.druid.query.search.SearchQuery;
import org.apache.hive.druid.io.druid.query.search.SearchQueryConfig;
import org.apache.hive.druid.io.druid.query.search.SearchQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.search.SearchQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.search.SearchQuerySpec;
import org.apache.hive.druid.io.druid.query.search.SearchResultValue;
import org.apache.hive.druid.io.druid.query.search.SearchSortSpec;
import org.apache.hive.druid.io.druid.query.search.SearchStrategySelector;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.TestIndex;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchQueryRunnerTest {
    private static final Logger LOG = new Logger(SearchQueryRunnerTest.class);
    private static final SearchQueryConfig config = new SearchQueryConfig();
    private static final SearchQueryQueryToolChest toolChest = new SearchQueryQueryToolChest(config, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
    private static final SearchStrategySelector selector = new SearchStrategySelector(Suppliers.ofInstance((Object)config));
    private final QueryRunner runner;
    private final QueryRunner decoratedRunner;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.transformToConstructionFeeder(QueryRunnerTestHelper.makeQueryRunners(new SearchQueryRunnerFactory(selector, toolChest, QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
    }

    public SearchQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
        this.decoratedRunner = toolChest.postMergeQueryDecoration(toolChest.mergeResults(toolChest.preMergeQueryDecoration(runner)));
    }

    @Test
    public void testSearchHitSerDe() throws Exception {
        for (SearchHit hit : Arrays.asList(new SearchHit("dim1", "val1"), new SearchHit("dim2", "val2", Integer.valueOf(3)))) {
            SearchHit read = (SearchHit)TestHelper.makeJsonMapper().readValue(TestHelper.makeJsonMapper().writeValueAsString((Object)hit), SearchHit.class);
            Assert.assertEquals((Object)hit, (Object)read);
            if (hit.getCount() == null) {
                Assert.assertNull((Object)read.getCount());
                continue;
            }
            Assert.assertEquals((Object)hit.getCount(), (Object)read.getCount());
        }
    }

    @Test
    public void testSearch() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(279)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        expectedHits.add(new SearchHit("placementish", "a", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("partial_null_column", "value", Integer.valueOf(186)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchWithCardinality() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build();
        QueryRunner mergedRunner = toolChest.mergeResults((QueryRunner)new QueryRunner<Result<SearchResultValue>>(){

            public Sequence<Result<SearchResultValue>> run(QueryPlus<Result<SearchResultValue>> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-01-12/2011-02-28")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-03-01/2011-04-15")})));
                return Sequences.concat((Sequence[])new Sequence[]{SearchQueryRunnerTest.this.runner.run(queryPlus1, responseContext), SearchQueryRunnerTest.this.runner.run(queryPlus2, responseContext)});
            }
        });
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(273)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(182)));
        expectedHits.add(new SearchHit("placementish", "a", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("partial_null_column", "value", Integer.valueOf(182)));
        this.checkSearchQuery((Query)searchQuery, mergedRunner, expectedHits);
    }

    @Test
    public void testSearchSameValueInMultiDims() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions(Arrays.asList("placement", "placementish")).query("e").build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("placement", "preferred", Integer.valueOf(1209)));
        expectedHits.add(new SearchHit("placementish", "e", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("placementish", "preferred", Integer.valueOf(1209)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchSameValueInMultiDims2() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions(Arrays.asList("placement", "placementish")).sortSpec(new SearchSortSpec(StringComparators.STRLEN)).query("e").build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("placementish", "e", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("placement", "preferred", Integer.valueOf(1209)));
        expectedHits.add(new SearchHit("placementish", "preferred", Integer.valueOf(1209)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testFragmentSearch() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query((SearchQuerySpec)new FragmentSearchQuerySpec(Arrays.asList("auto", "ve"))).build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchWithDimensionQuality() {
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(279)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(93)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions("quality").intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithDimensionProvider() {
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions("market").intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithDimensionsQualityAndProvider() {
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(279)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions(Arrays.asList("quality", "market")).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithDimensionsPlacementAndProvider() {
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions(Arrays.asList("placementish", "market")).intervals(QueryRunnerTestHelper.fullOnInterval).query("mark").build(), expectedHits);
    }

    @Test
    public void testSearchWithExtractionFilter1() {
        String automotiveSnowman = "automotive\u2603";
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("quality", "automotive\u2603", Integer.valueOf(93)));
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"automotive", (Object)"automotive\u2603"), false), true, null, true, Boolean.valueOf(true));
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters((DimFilter)new ExtractionDimFilter("quality", "automotive\u2603", (ExtractionFn)lookupExtractionFn, null)).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions((DimensionSpec)new ExtractionDimensionSpec("quality", null, (ExtractionFn)lookupExtractionFn)).query("\u2603").build();
        this.checkSearchQuery((Query)query, expectedHits);
    }

    @Test
    public void testSearchWithSingleFilter1() {
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(93)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters((DimFilter)new AndDimFilter(Arrays.asList(new SelectorDimFilter("market", "total_market", null), new SelectorDimFilter("quality", "mezzanine", null)))).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions("quality").query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithSingleFilter2() {
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "total_market").intervals(QueryRunnerTestHelper.fullOnInterval).dimensions("market").query("a").build(), expectedHits);
    }

    @Test
    public void testSearchMultiAndFilter() {
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "automotive", null)});
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters((DimFilter)filter).dimensions("quality").intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithMultiOrFilter() {
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        OrDimFilter filter = new OrDimFilter(new DimFilter[]{new SelectorDimFilter("quality", "total_market", null), new SelectorDimFilter("quality", "automotive", null)});
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions("quality").filters((DimFilter)filter).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithEmptyResults() {
        LinkedList expectedHits = Lists.newLinkedList();
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("abcd123").build(), expectedHits);
    }

    @Test
    public void testSearchWithFilterEmptyResults() {
        LinkedList expectedHits = Lists.newLinkedList();
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "total_market", null), new SelectorDimFilter("quality", "automotive", null)});
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters((DimFilter)filter).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchNonExistingDimension() {
        LinkedList expectedHits = Lists.newLinkedList();
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions("does_not_exist").query("a").build(), expectedHits);
    }

    @Test
    public void testSearchAll() {
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("market", "spot", Integer.valueOf(837)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        expectedHits.add(new SearchHit("market", "upfront", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions("market").query("").build(), expectedHits);
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions("market").build(), expectedHits);
    }

    @Test
    public void testSearchWithNumericSort() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").sortSpec(new SearchSortSpec(StringComparators.NUMERIC)).build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("placementish", "a", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(279)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("partial_null_column", "value", Integer.valueOf(186)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnTime() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("Friday").dimensions((DimensionSpec)new ExtractionDimensionSpec("__time", "__time2", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false))).build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("__time2", "Friday", Integer.valueOf(169)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnLongColumn() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new DefaultDimensionSpec("__time", "__time", ValueType.LONG)).dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("1297123200000").build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("__time", "1297123200000", Integer.valueOf(13)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnLongColumnWithExFn() {
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new ExtractionDimensionSpec("__time", "__time", (ExtractionFn)jsExtractionFn)).dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("1297123200000").build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("__time", "super-1297123200000", Integer.valueOf(13)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnFloatColumn() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new DefaultDimensionSpec("index", "index", ValueType.DOUBLE)).dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("100.7").build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("index", "100.706057", Integer.valueOf(1)));
        expectedHits.add(new SearchHit("index", "100.775597", Integer.valueOf(1)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnFloatColumnWithExFn() {
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new ExtractionDimensionSpec("index", "index", (ExtractionFn)jsExtractionFn)).dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("100.7").build();
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("index", "super-100.706057", Integer.valueOf(1)));
        expectedHits.add(new SearchHit("index", "super-100.775597", Integer.valueOf(1)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchWithNullValueInDimension() throws Exception {
        IncrementalIndex index = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2011-01-12T00:00:00.000Z").getMillis()).build()).setMaxRowCount(10).buildOnheap();
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host")));
        index.add((InputRow)new MapBasedInputRow(1481871670000L, Arrays.asList("name", "table"), (Map)ImmutableMap.of((Object)"name", (Object)"name2", (Object)"table", (Object)"table")));
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new DefaultDimensionSpec("table", "table")).dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).context((Map)ImmutableMap.of((Object)"searchStrategy", (Object)"cursorOnly")).build();
        SearchQueryRunnerFactory factory = new SearchQueryRunnerFactory(selector, toolChest, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        QueryRunner runner = factory.createRunner((Segment)new QueryableIndexSegment("asdf", TestIndex.persistRealtimeAndLoadMMapped(index)));
        LinkedList expectedHits = Lists.newLinkedList();
        expectedHits.add(new SearchHit("table", "table", Integer.valueOf(1)));
        expectedHits.add(new SearchHit("table", "", Integer.valueOf(1)));
        this.checkSearchQuery((Query)searchQuery, runner, expectedHits);
    }

    @Test
    public void testSearchWithNotExistedDimension() throws Exception {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new DefaultDimensionSpec("asdf", "asdf")).dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).build();
        LinkedList noHit = Lists.newLinkedList();
        this.checkSearchQuery((Query)searchQuery, noHit);
    }

    private void checkSearchQuery(Query searchQuery, List<SearchHit> expectedResults) {
        this.checkSearchQuery(searchQuery, this.runner, expectedResults);
        this.checkSearchQuery(searchQuery, this.decoratedRunner, expectedResults);
    }

    private void checkSearchQuery(Query searchQuery, QueryRunner runner, List<SearchHit> expectedResults) {
        List results = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)searchQuery), (Map)ImmutableMap.of()), (List)Lists.newArrayList());
        LinkedList copy = Lists.newLinkedList(expectedResults);
        for (Result result : results) {
            Assert.assertEquals((Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)result.getTimestamp());
            Assert.assertTrue((boolean)(result.getValue() instanceof Iterable));
            Iterable resultValues = (Iterable)result.getValue();
            for (SearchHit resultValue : resultValues) {
                int index = copy.indexOf(resultValue);
                if (index < 0) {
                    this.fail(expectedResults, results, "No result found containing " + resultValue.getDimension() + " and " + resultValue.getValue());
                }
                SearchHit expected = (SearchHit)copy.remove(index);
                if (resultValue.toString().equals(expected.toString())) continue;
                this.fail(expectedResults, results, "Invalid count for " + resultValue + ".. which was expected to be " + expected.getCount());
            }
        }
        if (!copy.isEmpty()) {
            this.fail(expectedResults, results, "Some expected results are not shown: " + copy);
        }
    }

    private void fail(List<SearchHit> expectedResults, Iterable<Result<SearchResultValue>> results, String errorMsg) {
        LOG.info("Expected..", new Object[0]);
        for (SearchHit searchHit : expectedResults) {
            LOG.info(searchHit.toString(), new Object[0]);
        }
        LOG.info("Result..", new Object[0]);
        for (Result result : results) {
            for (SearchHit v : (SearchResultValue)result.getValue()) {
                LOG.info(v.toString(), new Object[0]);
            }
        }
        Assert.fail((String)errorMsg);
    }
}

