/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LookupExtractionFnTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private final boolean retainMissing;
    private final String replaceMissing;
    private final boolean injective;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return Iterables.transform((Iterable)Sets.cartesianProduct((List)ImmutableList.of((Object)ImmutableSet.of((Object)true, (Object)false), (Object)ImmutableSet.of((Object)"", (Object)"MISSING VALUE"), (Object)ImmutableSet.of((Object)true, (Object)false))), (Function)new Function<List<?>, Object[]>(){

            @Nullable
            public Object[] apply(List<?> input) {
                return input.toArray();
            }
        });
    }

    public LookupExtractionFnTest(boolean retainMissing, String replaceMissing, boolean injective) {
        this.replaceMissing = Strings.emptyToNull((String)replaceMissing);
        this.retainMissing = retainMissing;
        this.injective = injective;
    }

    @Test
    public void testEqualsAndHash() {
        if (this.retainMissing && !Strings.isNullOrEmpty((String)this.replaceMissing)) {
            return;
        }
        LookupExtractionFn lookupExtractionFn1 = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        LookupExtractionFn lookupExtractionFn2 = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        LookupExtractionFn lookupExtractionFn3 = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar2"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        Assert.assertEquals((Object)lookupExtractionFn1, (Object)lookupExtractionFn2);
        Assert.assertEquals((long)lookupExtractionFn1.hashCode(), (long)lookupExtractionFn2.hashCode());
        Assert.assertNotEquals((Object)lookupExtractionFn1, (Object)lookupExtractionFn3);
        Assert.assertNotEquals((long)lookupExtractionFn1.hashCode(), (long)lookupExtractionFn3.hashCode());
    }

    @Test
    public void testSimpleSerDe() throws IOException {
        if (this.retainMissing && !Strings.isNullOrEmpty((String)this.replaceMissing)) {
            return;
        }
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        String str1 = OBJECT_MAPPER.writeValueAsString((Object)lookupExtractionFn);
        LookupExtractionFn lookupExtractionFn2 = (LookupExtractionFn)OBJECT_MAPPER.readValue(str1, LookupExtractionFn.class);
        Assert.assertEquals((Object)this.retainMissing, (Object)lookupExtractionFn2.isRetainMissingValue());
        Assert.assertEquals((Object)this.replaceMissing, (Object)lookupExtractionFn2.getReplaceMissingValueWith());
        Assert.assertEquals((Object)this.injective, (Object)lookupExtractionFn2.isInjective());
        Assert.assertArrayEquals((byte[])lookupExtractionFn.getCacheKey(), (byte[])lookupExtractionFn2.getCacheKey());
        Assert.assertEquals((Object)str1, (Object)OBJECT_MAPPER.writeValueAsString((Object)lookupExtractionFn2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArgs() {
        if (!this.retainMissing || Strings.isNullOrEmpty((String)this.replaceMissing)) {
            throw new IAE("Case not valid", new Object[0]);
        }
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, Strings.emptyToNull((String)this.replaceMissing), this.injective, Boolean.valueOf(false));
    }

    @Test
    public void testCacheKey() {
        if (this.retainMissing && !Strings.isNullOrEmpty((String)this.replaceMissing)) {
            return;
        }
        HashMap weirdMap = Maps.newHashMap();
        weirdMap.put("foobar", null);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), this.retainMissing, this.replaceMissing, this.injective, Boolean.valueOf(false));
        if (Strings.isNullOrEmpty((String)this.replaceMissing) || this.retainMissing) {
            Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn(lookupExtractionFn.getLookup(), !lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), lookupExtractionFn.isInjective(), Boolean.valueOf(false)).getCacheKey()));
            Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn(lookupExtractionFn.getLookup(), !lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), !lookupExtractionFn.isInjective(), Boolean.valueOf(false)).getCacheKey()));
        }
        Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)weirdMap, false), lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), lookupExtractionFn.isInjective(), Boolean.valueOf(false)).getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn(lookupExtractionFn.getLookup(), lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), !lookupExtractionFn.isInjective(), Boolean.valueOf(false)).getCacheKey()));
    }
}

