/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.LimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class GroupByQueryTest {
    private static final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FieldAccessPostAggregator("x", "idx"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(100))).build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testRowOrderingMixTypes() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("dummy").setGranularity(Granularities.ALL).setInterval("2000/2001").addDimension((DimensionSpec)new DefaultDimensionSpec("foo", "foo", ValueType.LONG)).addDimension((DimensionSpec)new DefaultDimensionSpec("bar", "bar", ValueType.FLOAT)).addDimension((DimensionSpec)new DefaultDimensionSpec("baz", "baz", ValueType.STRING)).build();
        Ordering rowOrdering = query.getRowOrdering(false);
        int compare = rowOrdering.compare((Object)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"foo", (Object)1, (Object)"bar", (Object)Float.valueOf(1.0f), (Object)"baz", (Object)"a")), (Object)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"foo", (Object)1L, (Object)"bar", (Object)1.0, (Object)"baz", (Object)"b")));
        Assert.assertEquals((long)-1L, (long)compare);
    }
}

