/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.hive.druid.io.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataSupervisorManager;
import org.apache.hive.druid.io.druid.metadata.TestDerbyConnector;
import org.apache.hive.druid.io.druid.metadata.TestSupervisorSpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataSupervisorManagerTest {
    private static final ObjectMapper mapper = new DefaultObjectMapper();
    private TestDerbyConnector connector;
    private MetadataStorageTablesConfig tablesConfig;
    private SQLMetadataSupervisorManager supervisorManager;
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();

    @BeforeClass
    public static void setupStatic() {
        mapper.registerSubtypes(new Class[]{TestSupervisorSpec.class});
    }

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.connector.createSupervisorsTable();
        this.supervisorManager = new SQLMetadataSupervisorManager(mapper, (SQLMetadataConnector)this.connector, Suppliers.ofInstance((Object)this.tablesConfig));
    }

    @Test
    public void testInsertAndGet() {
        String supervisor1 = "test-supervisor-1";
        String supervisor2 = "test-supervisor-2";
        ImmutableMap data1rev1 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-1", (Object)"key1-2", (Object)"value1-2-1");
        ImmutableMap data1rev2 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-2", (Object)"key1-2", (Object)"value1-2-2");
        ImmutableMap data1rev3 = ImmutableMap.of((Object)"key1-1", (Object)"value1-1-3", (Object)"key1-2", (Object)"value1-2-3");
        ImmutableMap data2rev1 = ImmutableMap.of((Object)"key2-1", (Object)"value2-1-1", (Object)"key2-2", (Object)"value2-2-1");
        ImmutableMap data2rev2 = ImmutableMap.of((Object)"key2-3", (Object)"value2-3-2", (Object)"key2-4", (Object)"value2-4-2");
        Assert.assertTrue((boolean)this.supervisorManager.getAll().isEmpty());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev1));
        this.supervisorManager.insert("test-supervisor-2", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-2", data2rev1));
        Map supervisorSpecs = this.supervisorManager.getAll();
        Map latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)2L, (long)supervisorSpecs.size());
        Assert.assertEquals((long)1L, (long)((List)supervisorSpecs.get("test-supervisor-1")).size());
        Assert.assertEquals((long)1L, (long)((List)supervisorSpecs.get("test-supervisor-2")).size());
        Assert.assertEquals((Object)"test-supervisor-1", (Object)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(0)).getSpec().getId());
        Assert.assertEquals((Object)"test-supervisor-2", (Object)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-2")).get(0)).getSpec().getId());
        Assert.assertEquals((Object)data1rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(0)).getSpec()).getData());
        Assert.assertEquals((Object)data2rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-2")).get(0)).getSpec()).getData());
        Assert.assertEquals((long)2L, (long)latestSpecs.size());
        Assert.assertEquals((Object)data1rev1, (Object)((TestSupervisorSpec)latestSpecs.get("test-supervisor-1")).getData());
        Assert.assertEquals((Object)data2rev1, (Object)((TestSupervisorSpec)latestSpecs.get("test-supervisor-2")).getData());
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev2));
        this.supervisorManager.insert("test-supervisor-1", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-1", data1rev3));
        this.supervisorManager.insert("test-supervisor-2", (SupervisorSpec)new TestSupervisorSpec("test-supervisor-2", data2rev2));
        supervisorSpecs = this.supervisorManager.getAll();
        latestSpecs = this.supervisorManager.getLatest();
        Assert.assertEquals((long)2L, (long)supervisorSpecs.size());
        Assert.assertEquals((long)3L, (long)((List)supervisorSpecs.get("test-supervisor-1")).size());
        Assert.assertEquals((long)2L, (long)((List)supervisorSpecs.get("test-supervisor-2")).size());
        Assert.assertEquals((Object)data1rev3, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(0)).getSpec()).getData());
        Assert.assertEquals((Object)data1rev2, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(1)).getSpec()).getData());
        Assert.assertEquals((Object)data1rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-1")).get(2)).getSpec()).getData());
        Assert.assertEquals((Object)data2rev2, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-2")).get(0)).getSpec()).getData());
        Assert.assertEquals((Object)data2rev1, (Object)((TestSupervisorSpec)((VersionedSupervisorSpec)((List)supervisorSpecs.get("test-supervisor-2")).get(1)).getSpec()).getData());
        Assert.assertEquals((Object)data1rev3, (Object)((TestSupervisorSpec)latestSpecs.get("test-supervisor-1")).getData());
        Assert.assertEquals((Object)data2rev2, (Object)((TestSupervisorSpec)latestSpecs.get("test-supervisor-2")).getData());
    }

    @After
    public void cleanup() {
        this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{SQLMetadataSupervisorManagerTest.this.tablesConfig.getSupervisorTable()})).execute();
                return null;
            }
        });
    }
}

