/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.io.druid.metadata.DerbyMetadataStorageActionHandler;
import org.apache.hive.druid.io.druid.metadata.EntryExistsException;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataStorageActionHandler;
import org.apache.hive.druid.io.druid.metadata.TestDerbyConnector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SQLMetadataStorageActionHandlerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private SQLMetadataStorageActionHandler<Map<String, Integer>, Map<String, Integer>, Map<String, String>, Map<String, Integer>> handler;

    @Before
    public void setUp() throws Exception {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        String entryType = "entry";
        String entryTable = "entries";
        String logTable = "logs";
        String lockTable = "locks";
        connector.createEntryTable("entries");
        connector.createLockTable("locks", "entry");
        connector.createLogTable("logs", "entry");
        this.handler = new DerbyMetadataStorageActionHandler((SQLMetadataConnector)connector, jsonMapper, (MetadataStorageActionHandlerTypes)new MetadataStorageActionHandlerTypes<Map<String, Integer>, Map<String, Integer>, Map<String, String>, Map<String, Integer>>(){

            public TypeReference<Map<String, Integer>> getEntryType() {
                return new TypeReference<Map<String, Integer>>(){};
            }

            public TypeReference<Map<String, Integer>> getStatusType() {
                return new TypeReference<Map<String, Integer>>(){};
            }

            public TypeReference<Map<String, String>> getLogType() {
                return JacksonUtils.TYPE_REFERENCE_MAP_STRING_STRING;
            }

            public TypeReference<Map<String, Integer>> getLockType() {
                return new TypeReference<Map<String, Integer>>(){};
            }
        }, "entry", "entries", "logs", "locks");
    }

    @Test
    public void testEntryAndStatus() throws Exception {
        ImmutableMap entry = ImmutableMap.of((Object)"numericId", (Object)1234);
        ImmutableMap status1 = ImmutableMap.of((Object)"count", (Object)42);
        ImmutableMap status2 = ImmutableMap.of((Object)"count", (Object)42, (Object)"temp", (Object)1);
        String entryId = "1234";
        this.handler.insert("1234", DateTimes.of((String)"2014-01-02T00:00:00.123"), "testDataSource", (Object)entry, true, null);
        Assert.assertEquals((Object)Optional.of((Object)entry), (Object)this.handler.getEntry("1234"));
        Assert.assertEquals((Object)Optional.absent(), (Object)this.handler.getEntry("non_exist_entry"));
        Assert.assertEquals((Object)Optional.absent(), (Object)this.handler.getStatus("1234"));
        Assert.assertEquals((Object)Optional.absent(), (Object)this.handler.getStatus("non_exist_entry"));
        Assert.assertTrue((boolean)this.handler.setStatus("1234", true, (Object)status1));
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)entry, (Object)status1)), (Object)this.handler.getActiveEntriesWithStatus());
        Assert.assertTrue((boolean)this.handler.setStatus("1234", true, (Object)status2));
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)entry, (Object)status2)), (Object)this.handler.getActiveEntriesWithStatus());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.handler.getInactiveStatusesSince(DateTimes.of((String)"2014-01-01")));
        Assert.assertTrue((boolean)this.handler.setStatus("1234", false, (Object)status1));
        Assert.assertEquals((Object)Optional.of((Object)status1), (Object)this.handler.getStatus("1234"));
        Assert.assertFalse((boolean)this.handler.setStatus("1234", false, (Object)status2));
        Assert.assertEquals((Object)Optional.of((Object)status1), (Object)this.handler.getStatus("1234"));
        Assert.assertEquals((Object)Optional.of((Object)entry), (Object)this.handler.getEntry("1234"));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.handler.getInactiveStatusesSince(DateTimes.of((String)"2014-01-03")));
        Assert.assertEquals((Object)ImmutableList.of((Object)status1), (Object)this.handler.getInactiveStatusesSince(DateTimes.of((String)"2014-01-01")));
    }

    @Test
    public void testGetRecentStatuses() throws EntryExistsException {
        for (int i = 1; i < 11; ++i) {
            String entryId = "abcd_" + i;
            ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)i);
            Object status = ImmutableMap.of((Object)"count", (Object)(i * 10));
            this.handler.insert(entryId, DateTimes.of((String)StringUtils.format((String)"2014-01-%02d", (Object[])new Object[]{i})), "test", (Object)entry, false, status);
        }
        List statuses = this.handler.getInactiveStatusesSince(DateTimes.of((String)"2014-01-01"), Integer.valueOf(7));
        Assert.assertEquals((long)7L, (long)statuses.size());
        int i = 10;
        for (Object status : statuses) {
            Assert.assertEquals((Object)ImmutableMap.of((Object)"count", (Object)(i-- * 10)), (Object)status);
        }
    }

    @Test
    public void testGetRecentStatuses2() throws EntryExistsException {
        for (int i = 1; i < 6; ++i) {
            String entryId = "abcd_" + i;
            ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)i);
            Object status = ImmutableMap.of((Object)"count", (Object)(i * 10));
            this.handler.insert(entryId, DateTimes.of((String)StringUtils.format((String)"2014-01-%02d", (Object[])new Object[]{i})), "test", (Object)entry, false, status);
        }
        List statuses = this.handler.getInactiveStatusesSince(DateTimes.of((String)"2014-01-01"), Integer.valueOf(10));
        Assert.assertEquals((long)5L, (long)statuses.size());
        int i = 5;
        for (Object status : statuses) {
            Assert.assertEquals((Object)ImmutableMap.of((Object)"count", (Object)(i-- * 10)), (Object)status);
        }
    }

    @Test(timeout=10000L)
    public void testRepeatInsert() throws Exception {
        String entryId = "abcd";
        ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("abcd", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status);
        this.thrown.expect(EntryExistsException.class);
        this.handler.insert("abcd", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status);
    }

    @Test
    public void testLogs() throws Exception {
        String entryId = "abcd";
        ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("abcd", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status);
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.handler.getLogs("non_exist_entry"));
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("abcd"));
        ImmutableMap log1 = ImmutableMap.of((Object)"logentry", (Object)"created");
        ImmutableMap log2 = ImmutableMap.of((Object)"logentry", (Object)"updated");
        Assert.assertTrue((boolean)this.handler.addLog("abcd", (Object)log1));
        Assert.assertTrue((boolean)this.handler.addLog("abcd", (Object)log2));
        Assert.assertEquals((Object)ImmutableList.of((Object)log1, (Object)log2), (Object)this.handler.getLogs("abcd"));
    }

    @Test
    public void testLocks() throws Exception {
        String entryId = "ABC123";
        ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("ABC123", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("non_exist_entry"));
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("ABC123"));
        ImmutableMap lock1 = ImmutableMap.of((Object)"lock", (Object)1);
        ImmutableMap lock2 = ImmutableMap.of((Object)"lock", (Object)2);
        Assert.assertTrue((boolean)this.handler.addLock("ABC123", (Object)lock1));
        Assert.assertTrue((boolean)this.handler.addLock("ABC123", (Object)lock2));
        Map locks = this.handler.getLocks("ABC123");
        Assert.assertEquals((long)2L, (long)locks.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)lock1, (Object)lock2), new HashSet(locks.values()));
        long lockId = (Long)locks.keySet().iterator().next();
        this.handler.removeLock(lockId);
        locks.remove(lockId);
        Map updated = this.handler.getLocks("ABC123");
        Assert.assertEquals(new HashSet(locks.values()), new HashSet(updated.values()));
        Assert.assertEquals(updated.keySet(), locks.keySet());
    }

    @Test
    public void testReplaceLock() throws EntryExistsException {
        String entryId = "ABC123";
        ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("ABC123", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("non_exist_entry"));
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("ABC123"));
        ImmutableMap lock1 = ImmutableMap.of((Object)"lock", (Object)1);
        ImmutableMap lock2 = ImmutableMap.of((Object)"lock", (Object)2);
        Assert.assertTrue((boolean)this.handler.addLock("ABC123", (Object)lock1));
        Long lockId1 = this.handler.getLockId("ABC123", (Object)lock1);
        Assert.assertNotNull((Object)lockId1);
        Assert.assertTrue((boolean)this.handler.replaceLock("ABC123", lockId1.longValue(), (Object)lock2));
    }

    @Test
    public void testGetLockId() throws EntryExistsException {
        String entryId = "ABC123";
        ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("ABC123", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("non_exist_entry"));
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("ABC123"));
        ImmutableMap lock1 = ImmutableMap.of((Object)"lock", (Object)1);
        ImmutableMap lock2 = ImmutableMap.of((Object)"lock", (Object)2);
        Assert.assertTrue((boolean)this.handler.addLock("ABC123", (Object)lock1));
        Assert.assertNotNull((Object)this.handler.getLockId("ABC123", (Object)lock1));
        Assert.assertNull((Object)this.handler.getLockId("ABC123", (Object)lock2));
    }
}

