/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.ExprType;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.junit.Assert;
import org.junit.Test;

public class EvalTest {
    private long evalLong(String x, Expr.ObjectBinding bindings) {
        ExprEval ret = this.eval(x, bindings);
        Assert.assertEquals((Object)ExprType.LONG, (Object)ret.type());
        return ret.asLong();
    }

    private double evalDouble(String x, Expr.ObjectBinding bindings) {
        ExprEval ret = this.eval(x, bindings);
        Assert.assertEquals((Object)ExprType.DOUBLE, (Object)ret.type());
        return ret.asDouble();
    }

    private ExprEval eval(String x, Expr.ObjectBinding bindings) {
        return Parser.parse((String)x, (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
    }

    @Test
    public void testDoubleEval() {
        Expr.ObjectBinding bindings = Parser.withMap((Map)ImmutableMap.of((Object)"x", (Object)2.0));
        Assert.assertEquals((double)2.0, (double)this.evalDouble("x", bindings), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)this.evalDouble("\"x\"", bindings), (double)1.0E-4);
        Assert.assertEquals((double)304.0, (double)this.evalDouble("300 + \"x\" * 2", bindings), (double)1.0E-4);
        Assert.assertFalse((this.evalDouble("1.0 && 0.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.evalDouble("1.0 && 2.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.evalDouble("1.0 || 0.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertFalse((this.evalDouble("0.0 || 0.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.evalDouble("2.0 > 1.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.evalDouble("2.0 >= 2.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.evalDouble("1.0 < 2.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.evalDouble("2.0 <= 2.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.evalDouble("2.0 == 2.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.evalDouble("2.0 != 1.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)3.5, (double)this.evalDouble("2.0 + 1.5", bindings), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)this.evalDouble("2.0 - 1.5", bindings), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)this.evalDouble("2.0 * 1.5", bindings), (double)1.0E-4);
        Assert.assertEquals((double)4.0, (double)this.evalDouble("2.0 / 0.5", bindings), (double)1.0E-4);
        Assert.assertEquals((double)0.2, (double)this.evalDouble("2.0 % 0.3", bindings), (double)1.0E-4);
        Assert.assertEquals((double)8.0, (double)this.evalDouble("2.0 ^ 3.0", bindings), (double)1.0E-4);
        Assert.assertEquals((double)-1.5, (double)this.evalDouble("-1.5", bindings), (double)1.0E-4);
        Assert.assertTrue((this.evalDouble("!-1.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.evalDouble("!0.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertFalse((this.evalDouble("!2.0", bindings) > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)2.0, (double)this.evalDouble("sqrt(4.0)", bindings), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)this.evalDouble("if(1.0, 2.0, 3.0)", bindings), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)this.evalDouble("if(0.0, 2.0, 3.0)", bindings), (double)1.0E-4);
    }

    @Test
    public void testLongEval() {
        Expr.ObjectBinding bindings = Parser.withMap((Map)ImmutableMap.of((Object)"x", (Object)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.evalLong("x", bindings));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.evalLong("\"x\"", bindings));
        Assert.assertEquals((long)92233720368547759L, (long)this.evalLong("\"x\" / 100 + 1", bindings));
        Assert.assertFalse((this.evalLong("9223372036854775807 && 0", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 && 9223372036854775806", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 || 0", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertFalse((this.evalLong("-9223372036854775807 || -9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("-9223372036854775807 || 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertFalse((this.evalLong("0 || 0", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 > 9223372036854775806", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 >= 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775806 < 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 <= 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 == 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 != 9223372036854775806", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.evalLong("9223372036854775806 + 1", bindings));
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)this.evalLong("9223372036854775807 - 1", bindings));
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)this.evalLong("4611686018427387903 * 2", bindings));
        Assert.assertEquals((long)0x3FFFFFFFFFFFFFFFL, (long)this.evalLong("9223372036854775806 / 2", bindings));
        Assert.assertEquals((long)7L, (long)this.evalLong("9223372036854775807 % 9223372036854775800", bindings));
        Assert.assertEquals((long)9223372030926249001L, (long)this.evalLong("3037000499 ^ 2", bindings));
        Assert.assertEquals((long)-9223372036854775807L, (long)this.evalLong("-9223372036854775807", bindings));
        Assert.assertTrue((this.evalLong("!-9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("!0", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertFalse((this.evalLong("!9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)3037000499L, (long)this.evalLong("cast(sqrt(9223372036854775807), 'long')", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("if(x == 9223372036854775807, 1, 0)", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("if(x - 1 == 9223372036854775807, 1, 0)", bindings));
        Assert.assertEquals((long)1271030400000L, (long)this.evalLong("timestamp('2010-04-12')", bindings));
        Assert.assertEquals((long)1270998000000L, (long)this.evalLong("timestamp('2010-04-12T+09:00')", bindings));
        Assert.assertEquals((long)1271055781000L, (long)this.evalLong("timestamp('2010-04-12T07:03:01')", bindings));
        Assert.assertEquals((long)1271023381000L, (long)this.evalLong("timestamp('2010-04-12T07:03:01+09:00')", bindings));
        Assert.assertEquals((long)1271023381419L, (long)this.evalLong("timestamp('2010-04-12T07:03:01.419+09:00')", bindings));
        Assert.assertEquals((long)1271030400L, (long)this.evalLong("unix_timestamp('2010-04-12')", bindings));
        Assert.assertEquals((long)1270998000L, (long)this.evalLong("unix_timestamp('2010-04-12T+09:00')", bindings));
        Assert.assertEquals((long)1271055781L, (long)this.evalLong("unix_timestamp('2010-04-12T07:03:01')", bindings));
        Assert.assertEquals((long)1271023381L, (long)this.evalLong("unix_timestamp('2010-04-12T07:03:01+09:00')", bindings));
        Assert.assertEquals((long)1271023381L, (long)this.evalLong("unix_timestamp('2010-04-12T07:03:01.419+09:00')", bindings));
        Assert.assertEquals((Object)"NULL", (Object)this.eval("nvl(if(x == 9223372036854775807, '', 'x'), 'NULL')", bindings).asString());
        Assert.assertEquals((Object)"x", (Object)this.eval("nvl(if(x == 9223372036854775806, '', 'x'), 'NULL')", bindings).asString());
    }

    @Test
    public void testBooleanReturn() {
        Expr.ObjectBinding bindings = Parser.withMap((Map)ImmutableMap.of((Object)"x", (Object)100L, (Object)"y", (Object)100L, (Object)"z", (Object)100.0, (Object)"w", (Object)100.0));
        ExprEval eval = Parser.parse((String)"x==y", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExprType.LONG, (Object)eval.type());
        eval = Parser.parse((String)"x!=y", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExprType.LONG, (Object)eval.type());
        eval = Parser.parse((String)"x==z", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExprType.DOUBLE, (Object)eval.type());
        eval = Parser.parse((String)"x!=z", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExprType.DOUBLE, (Object)eval.type());
        eval = Parser.parse((String)"z==w", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExprType.DOUBLE, (Object)eval.type());
        eval = Parser.parse((String)"z!=w", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExprType.DOUBLE, (Object)eval.type());
    }
}

