/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathParser;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JSONPathParserTest {
    private static final String json = "{\"one\": \"foo\", \"two\" : [\"bar\", \"baz\"], \"three\" : \"qux\", \"four\" : null}";
    private static final String numbersJson = "{\"five\" : 5.0, \"six\" : 6, \"many\" : 1234567878900, \"toomany\" : 1234567890000000000000}";
    private static final String whackyCharacterJson = "{\"one\": \"foo\\uD900\"}";
    private static final String nestedJson = "{\"simpleVal\":\"text\", \"ignore_me\":[1, {\"x\":2}], \"blah\":[4,5,6], \"newmet\":5, \"foo\":{\"bar1\":\"aaa\", \"bar2\":\"bbb\"}, \"baz\":[1,2,3], \"timestamp\":\"2999\", \"foo.bar1\":\"Hello world!\", \"testListConvert\":[1234567890000000000000, \"foo\\uD900\"], \"testListConvert2\":[1234567890000000000000, \"foo\\uD900\", [1234567890000000000000]], \"testMapConvert\":{\"big\": 1234567890000000000000, \"big2\":{\"big2\":1234567890000000000000}}, \"testEmptyList\": [], \"hey\":[{\"barx\":\"asdf\"}], \"met\":{\"a\":[7,8,9]}}";
    private static final String notJson = "***@#%R#*(TG@(*H(#@(#@((H#(@TH@(#TH(@SDHGKJDSKJFBSBJK";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testSimple() {
        ArrayList fields = new ArrayList();
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null);
        Map jsonMap = jsonParser.parseToMap(json);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"one", (Object)"foo", (Object)"two", (Object)ImmutableList.of((Object)"bar", (Object)"baz"), (Object)"three", (Object)"qux"), (Object)jsonMap);
    }

    @Test
    public void testWithNumbers() {
        ArrayList fields = new ArrayList();
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null);
        Map jsonMap = jsonParser.parseToMap(numbersJson);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"five", (Object)5.0, (Object)"six", (Object)6L, (Object)"many", (Object)1234567878900L, (Object)"toomany", (Object)1.23456789E21), (Object)jsonMap);
    }

    @Test
    public void testWithWhackyCharacters() {
        ArrayList fields = new ArrayList();
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null);
        Map jsonMap = jsonParser.parseToMap(whackyCharacterJson);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"one", (Object)"foo?"), (Object)jsonMap);
    }

    @Test
    public void testNestingWithFieldDiscovery() {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "baz", "baz"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "nested-foo.bar1", "$.foo.bar1"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "nested-foo.bar2", "$.foo.bar2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "heybarx0", "$.hey[0].barx"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "testListConvert2", "testListConvert2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "testMapConvert", "testMapConvert"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "INVALID_ROOT", "INVALID_ROOT_EXPR"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "INVALID_PATH", "INVALID_PATH_EXPR"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-nested-foo.bar1", ".foo.bar1"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-nested-foo.bar2", ".foo.bar2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-heybarx0", ".hey[0].barx"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-met-array", ".met.a"));
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null);
        Map jsonMap = jsonParser.parseToMap(nestedJson);
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), jsonMap.get("baz"));
        Assert.assertEquals((Object)ImmutableList.of((Object)4L, (Object)5L, (Object)6L), jsonMap.get("blah"));
        Assert.assertEquals((Object)"text", jsonMap.get("simpleVal"));
        Assert.assertEquals((Object)5L, jsonMap.get("newmet"));
        Assert.assertEquals((Object)"2999", jsonMap.get("timestamp"));
        Assert.assertEquals((Object)"Hello world!", jsonMap.get("foo.bar1"));
        List testListConvert = (List)jsonMap.get("testListConvert");
        Assert.assertEquals((Object)1.23456789E21, testListConvert.get(0));
        Assert.assertEquals((Object)"foo?", testListConvert.get(1));
        List testListConvert2 = (List)jsonMap.get("testListConvert2");
        Assert.assertEquals((Object)1.23456789E21, testListConvert2.get(0));
        Assert.assertEquals((Object)"foo?", testListConvert2.get(1));
        Assert.assertEquals((Object)1.23456789E21, ((List)testListConvert2.get(2)).get(0));
        Map testMapConvert = (Map)jsonMap.get("testMapConvert");
        Assert.assertEquals((Object)1.23456789E21, testMapConvert.get("big"));
        Assert.assertEquals((Object)1.23456789E21, ((Map)testMapConvert.get("big2")).get("big2"));
        Assert.assertEquals((Object)ImmutableList.of(), jsonMap.get("testEmptyList"));
        Assert.assertEquals((Object)"aaa", jsonMap.get("nested-foo.bar1"));
        Assert.assertEquals((Object)"bbb", jsonMap.get("nested-foo.bar2"));
        Assert.assertEquals((Object)"asdf", jsonMap.get("heybarx0"));
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L), jsonMap.get("met-array"));
        Assert.assertEquals((Object)"aaa", jsonMap.get("jq-nested-foo.bar1"));
        Assert.assertEquals((Object)"bbb", jsonMap.get("jq-nested-foo.bar2"));
        Assert.assertEquals((Object)"asdf", jsonMap.get("jq-heybarx0"));
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L), jsonMap.get("jq-met-array"));
        Assert.assertFalse((boolean)jsonMap.containsKey("hey"));
        Assert.assertFalse((boolean)jsonMap.containsKey("met"));
        Assert.assertFalse((boolean)jsonMap.containsKey("ignore_me"));
        Assert.assertFalse((boolean)jsonMap.containsKey("foo"));
        Assert.assertNull(jsonMap.get("INVALID_ROOT"));
        Assert.assertNull(jsonMap.get("INVALID_PATH"));
    }

    @Test
    public void testNestingNoDiscovery() {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "simpleVal", "simpleVal"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.ROOT, "timestamp", "timestamp"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "nested-foo.bar2", "$.foo.bar2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "heybarx0", "$.hey[0].barx"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-nested-foo.bar2", ".foo.bar2"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-heybarx0", ".hey[0].barx"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq-met-array", ".met.a"));
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(false), fields), null);
        Map jsonMap = jsonParser.parseToMap(nestedJson);
        Assert.assertEquals((Object)"text", jsonMap.get("simpleVal"));
        Assert.assertEquals((Object)"2999", jsonMap.get("timestamp"));
        Assert.assertEquals((Object)"bbb", jsonMap.get("nested-foo.bar2"));
        Assert.assertEquals((Object)"asdf", jsonMap.get("heybarx0"));
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L), jsonMap.get("met-array"));
        Assert.assertEquals((Object)"bbb", jsonMap.get("jq-nested-foo.bar2"));
        Assert.assertEquals((Object)"asdf", jsonMap.get("jq-heybarx0"));
        Assert.assertEquals((Object)ImmutableList.of((Object)7L, (Object)8L, (Object)9L), jsonMap.get("jq-met-array"));
        Assert.assertFalse((boolean)jsonMap.containsKey("newmet"));
        Assert.assertFalse((boolean)jsonMap.containsKey("foo.bar1"));
        Assert.assertFalse((boolean)jsonMap.containsKey("baz"));
        Assert.assertFalse((boolean)jsonMap.containsKey("blah"));
        Assert.assertFalse((boolean)jsonMap.containsKey("nested-foo.bar1"));
        Assert.assertFalse((boolean)jsonMap.containsKey("hey"));
        Assert.assertFalse((boolean)jsonMap.containsKey("met"));
        Assert.assertFalse((boolean)jsonMap.containsKey("ignore_me"));
        Assert.assertFalse((boolean)jsonMap.containsKey("foo"));
    }

    @Test
    public void testRejectDuplicates() {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot have duplicate field definition: met-array");
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(false), fields), null);
        Map jsonMap = jsonParser.parseToMap(nestedJson);
    }

    @Test
    public void testRejectDuplicates2() {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.PATH, "met-array", "$.met.a"));
        fields.add(new JSONPathFieldSpec(JSONPathFieldType.JQ, "met-array", ".met.a"));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot have duplicate field definition: met-array");
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(false), fields), null);
        Map jsonMap = jsonParser.parseToMap(nestedJson);
    }

    @Test
    public void testParseFail() {
        ArrayList fields = new ArrayList();
        this.thrown.expect(ParseException.class);
        this.thrown.expectMessage("Unable to parse row [***@#%R#*(TG@(*H(#@(#@((H#(@TH@(#TH(@SDHGKJDSKJFBSBJK]");
        JSONPathParser jsonParser = new JSONPathParser(new JSONPathSpec(Boolean.valueOf(true), fields), null);
        Map jsonMap = jsonParser.parseToMap(notJson);
    }
}

