/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.hll;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import sun.misc.Unsafe;

class ByteBuffers {
    private static final Unsafe UNSAFE;
    private static final long ADDRESS_OFFSET;

    ByteBuffers() {
    }

    public static long getAddress(ByteBuffer buf) {
        return UNSAFE.getLong(buf, ADDRESS_OFFSET);
    }

    public static ByteBuffer allocateAlignedByteBuffer(int capacity, int align) {
        Preconditions.checkArgument((Long.bitCount(align) == 1 ? 1 : 0) != 0, (Object)"Alignment must be a power of 2");
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity + align);
        long address = ByteBuffers.getAddress(buf);
        if ((address & (long)(align - 1)) == 0L) {
            buf.limit(capacity);
        } else {
            int offset = (int)((long)align - (address & (long)(align - 1)));
            buf.position(offset);
            buf.limit(offset + capacity);
        }
        return buf.slice();
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            ADDRESS_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot access Unsafe methods", e);
        }
    }
}

