/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairTest {
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    @Test
    public void testBytesSerde() throws IOException {
        SerializablePair pair = new SerializablePair((Object)5L, (Object)9L);
        byte[] bytes = jsonMapper.writeValueAsBytes((Object)pair);
        SerializablePair deserializedPair = (SerializablePair)jsonMapper.readValue(bytes, SerializablePair.class);
        Assert.assertEquals((Object)pair.lhs, (Object)((Number)deserializedPair.lhs).longValue());
        Assert.assertEquals((Object)pair.rhs, (Object)((Number)deserializedPair.rhs).longValue());
    }

    @Test
    public void testStringSerde() throws IOException {
        SerializablePair pair = new SerializablePair((Object)5L, (Object)9L);
        String str = jsonMapper.writeValueAsString((Object)pair);
        SerializablePair deserializedPair = (SerializablePair)jsonMapper.readValue(str, SerializablePair.class);
        Assert.assertEquals((Object)pair.lhs, (Object)((Number)deserializedPair.lhs).longValue());
        Assert.assertEquals((Object)pair.rhs, (Object)((Number)deserializedPair.rhs).longValue());
    }
}

