/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.client.CachingClusteredClient;
import org.apache.hive.druid.io.druid.client.CachingClusteredClientTest;
import org.apache.hive.druid.io.druid.client.DirectDruidClient;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.ServerView;
import org.apache.hive.druid.io.druid.client.TimelineServerView;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.client.cache.MapCache;
import org.apache.hive.druid.io.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.io.druid.client.selector.ServerSelector;
import org.apache.hive.druid.io.druid.client.selector.TierSelectorStrategy;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.SingleElementPartitionChunk;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachingClusteredClientFunctionalityTest {
    public CachingClusteredClient client;
    protected VersionedIntervalTimeline<String, ServerSelector> timeline;
    protected TimelineServerView serverView;
    protected Cache cache;

    @Before
    public void setUp() throws Exception {
        this.timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        this.serverView = (TimelineServerView)EasyMock.createNiceMock(TimelineServerView.class);
        this.cache = MapCache.create((long)100000L);
        this.client = this.makeClient(MoreExecutors.sameThreadExecutor());
    }

    @Test
    public void testUncoveredInterval() throws Exception {
        this.addToTimeline(Intervals.of((String)"2015-01-02/2015-01-03"), "1");
        this.addToTimeline(Intervals.of((String)"2015-01-04/2015-01-05"), "1");
        this.addToTimeline(Intervals.of((String)"2015-02-04/2015-02-05"), "1");
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals("2015-01-02/2015-01-03").granularity("day").aggregators(Arrays.asList(new CountAggregatorFactory("rows"))).context((Map)ImmutableMap.of((Object)"uncoveredIntervalsLimit", (Object)3));
        HashMap<String, Object> responseContext = new HashMap<String, Object>();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        Assert.assertNull(responseContext.get("uncoveredIntervals"));
        builder.intervals("2015-01-01/2015-01-03");
        responseContext = new HashMap();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-01/2015-01-02");
        builder.intervals("2015-01-01/2015-01-04");
        responseContext = new HashMap();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-01/2015-01-02", "2015-01-03/2015-01-04");
        builder.intervals("2015-01-02/2015-01-04");
        responseContext = new HashMap();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-03/2015-01-04");
        builder.intervals("2015-01-01/2015-01-30");
        responseContext = new HashMap();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-01/2015-01-02", "2015-01-03/2015-01-04", "2015-01-05/2015-01-30");
        builder.intervals("2015-01-02/2015-01-30");
        responseContext = new HashMap();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-03/2015-01-04", "2015-01-05/2015-01-30");
        builder.intervals("2015-01-04/2015-01-30");
        responseContext = new HashMap();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-05/2015-01-30");
        builder.intervals("2015-01-10/2015-01-30");
        responseContext = new HashMap();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-10/2015-01-30");
        builder.intervals("2015-01-01/2015-02-25");
        responseContext = new HashMap();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, true, "2015-01-01/2015-01-02", "2015-01-03/2015-01-04", "2015-01-05/2015-02-04");
    }

    private void assertUncovered(Map<String, Object> context, boolean uncoveredIntervalsOverflowed, String ... intervals) {
        ArrayList expectedList = Lists.newArrayListWithExpectedSize((int)intervals.length);
        for (String interval : intervals) {
            expectedList.add(Intervals.of((String)interval));
        }
        Assert.assertEquals((Object)expectedList, (Object)context.get("uncoveredIntervals"));
        Assert.assertEquals((Object)uncoveredIntervalsOverflowed, (Object)context.get("uncoveredIntervalsOverflowed"));
    }

    private void addToTimeline(Interval interval, String version) {
        this.timeline.add(interval, (Object)version, (PartitionChunk)new SingleElementPartitionChunk((Object)new ServerSelector(DataSegment.builder().dataSource("test").interval(interval).version(version).shardSpec((ShardSpec)NoneShardSpec.instance()).build(), new TierSelectorStrategy(){

            public Comparator<Integer> getComparator() {
                return Ordering.natural();
            }

            public QueryableDruidServer pick(Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment) {
                return new QueryableDruidServer(new DruidServer("localhost", "localhost", null, 100L, ServerType.HISTORICAL, "a", 10), (DirectDruidClient)EasyMock.createNiceMock(DirectDruidClient.class));
            }

            public List<QueryableDruidServer> pick(Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment, int numServersToPick) {
                return Collections.singletonList(new QueryableDruidServer(new DruidServer("localhost", "localhost", null, 100L, ServerType.HISTORICAL, "a", 10), (DirectDruidClient)EasyMock.createNiceMock(DirectDruidClient.class)));
            }
        })));
    }

    protected CachingClusteredClient makeClient(ListeningExecutorService backgroundExecutorService) {
        return this.makeClient(backgroundExecutorService, this.cache, 10);
    }

    protected CachingClusteredClient makeClient(ListeningExecutorService backgroundExecutorService, Cache cache, final int mergeLimit) {
        return new CachingClusteredClient(CachingClusteredClientTest.WAREHOUSE, new TimelineServerView(){

            public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
            }

            public VersionedIntervalTimeline<String, ServerSelector> getTimeline(DataSource dataSource) {
                return CachingClusteredClientFunctionalityTest.this.timeline;
            }

            public void registerTimelineCallback(Executor exec, TimelineServerView.TimelineCallback callback) {
                throw new UnsupportedOperationException();
            }

            public <T> QueryRunner<T> getQueryRunner(DruidServer server) {
                return CachingClusteredClientFunctionalityTest.this.serverView.getQueryRunner(server);
            }

            public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
            }
        }, cache, (ObjectMapper)CachingClusteredClientTest.jsonMapper, (ExecutorService)backgroundExecutorService, new CacheConfig(){

            public boolean isPopulateCache() {
                return true;
            }

            public boolean isUseCache() {
                return true;
            }

            public boolean isQueryCacheable(Query query) {
                return true;
            }

            public int getCacheBulkMergeLimit() {
                return mergeLimit;
            }
        });
    }

    private static <T> Sequence<T> runQuery(CachingClusteredClient client, Query<T> query, Map<String, Object> responseContext) {
        return client.getQueryRunnerForIntervals(query, (Iterable)query.getIntervals()).run(QueryPlus.wrap(query), responseContext);
    }
}

