/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

public abstract class GoHandler {
    private volatile boolean succeeded = false;

    protected abstract <X extends Exception> ListenableFuture<Response> go(Request var1) throws X;

    public boolean succeeded() {
        return this.succeeded;
    }

    public ListenableFuture<Response> run(Request request) {
        try {
            ListenableFuture<Response> retVal = this.go(request);
            this.succeeded = true;
            return retVal;
        }
        catch (Throwable e) {
            this.succeeded = false;
            throw Throwables.propagate((Throwable)e);
        }
    }

    public GoHandler times(final int n) {
        final GoHandler myself = this;
        return new GoHandler(){
            AtomicInteger counter = new AtomicInteger(0);

            @Override
            public ListenableFuture<Response> go(Request request) {
                if (this.counter.getAndIncrement() < n) {
                    return myself.go(request);
                }
                GoHandler.this.succeeded = false;
                throw new ISE("Called more than %d times", new Object[]{n});
            }
        };
    }
}

