/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import java.io.IOException;
import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.emitter.core.Emitter;
import org.apache.hive.druid.com.metamx.emitter.core.Emitters;
import org.apache.hive.druid.com.metamx.emitter.core.Event;
import org.apache.hive.druid.com.metamx.emitter.core.factory.EmitterFactory;
import org.asynchttpclient.AsyncHttpClient;
import org.junit.Assert;
import org.junit.Test;

public class CustomEmitterFactoryTest {
    @Test
    public void testCustomEmitter() {
        Properties props = new Properties();
        props.put("org.apache.hive.druid.com.metamx.emitter.stringProperty", "http://example.com/");
        props.put("org.apache.hive.druid.com.metamx.emitter.intProperty", "1");
        props.put("org.apache.hive.druid.com.metamx.emitter.type", "test");
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerSubtypes(new Class[]{TestEmitterConfig.class});
        Lifecycle lifecycle = new Lifecycle();
        Emitter emitter = Emitters.create((Properties)props, null, (ObjectMapper)objectMapper, (Lifecycle)lifecycle);
        Assert.assertTrue((String)"created emitter should be of class StubEmitter", (boolean)(emitter instanceof StubEmitter));
        StubEmitter stubEmitter = (StubEmitter)emitter;
        Assert.assertEquals((Object)"http://example.com/", (Object)stubEmitter.getStringProperty());
        Assert.assertEquals((long)1L, (long)stubEmitter.getIntProperty());
    }

    public static class StubEmitter
    implements Emitter {
        private String stringProperty;
        private int intProperty;

        public StubEmitter(String stringProperty, int intProperty) {
            this.stringProperty = stringProperty;
            this.intProperty = intProperty;
        }

        public String getStringProperty() {
            return this.stringProperty;
        }

        public int getIntProperty() {
            return this.intProperty;
        }

        public void start() {
        }

        public void emit(Event event) {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    @JsonTypeName(value="test")
    public static class TestEmitterConfig
    implements EmitterFactory {
        @JsonProperty
        private String stringProperty;
        @JsonProperty
        private int intProperty;

        public Emitter makeEmitter(ObjectMapper objectMapper, AsyncHttpClient httpClient, Lifecycle lifecycle) {
            return new StubEmitter(this.stringProperty, this.intProperty);
        }
    }
}

