/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.lifecycle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.junit.Assert;
import org.junit.Test;

public class LifecycleTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentStartStopOnce() throws Exception {
        int numThreads = 10;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));
        final Lifecycle lifecycle = new Lifecycle();
        final AtomicLong startedCount = new AtomicLong(0L);
        final AtomicLong failedCount = new AtomicLong(0L);
        Lifecycle.Handler exceptionalHandler = new Lifecycle.Handler(){
            final AtomicBoolean started = new AtomicBoolean(false);

            public void start() throws Exception {
                if (!this.started.compareAndSet(false, true)) {
                    failedCount.incrementAndGet();
                    throw new ISE("Already started", new Object[0]);
                }
                startedCount.incrementAndGet();
            }

            public void stop() {
                if (!this.started.compareAndSet(true, false)) {
                    failedCount.incrementAndGet();
                    throw new ISE("Not yet started started", new Object[0]);
                }
            }
        };
        lifecycle.addHandler(exceptionalHandler);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(10);
        final CyclicBarrier barrier = new CyclicBarrier(10);
        final AtomicBoolean started = new AtomicBoolean(false);
        for (int i = 0; i < 10; ++i) {
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 1024; ++i) {
                            if (started.compareAndSet(false, true)) {
                                lifecycle.start();
                            }
                            barrier.await();
                            lifecycle.stop();
                            barrier.await();
                            started.set(false);
                            barrier.await();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }));
        }
        try {
            Futures.allAsList(futures).get();
        }
        finally {
            lifecycle.stop();
        }
        Assert.assertEquals((long)0L, (long)failedCount.get());
        Assert.assertTrue((startedCount.get() > 0L ? 1 : 0) != 0);
        executorService.shutdownNow();
    }

    @Test
    public void testStartStopOnce() throws Exception {
        Lifecycle lifecycle = new Lifecycle();
        final AtomicLong startedCount = new AtomicLong(0L);
        final AtomicLong failedCount = new AtomicLong(0L);
        Lifecycle.Handler exceptionalHandler = new Lifecycle.Handler(){
            final AtomicBoolean started = new AtomicBoolean(false);

            public void start() throws Exception {
                if (!this.started.compareAndSet(false, true)) {
                    failedCount.incrementAndGet();
                    throw new ISE("Already started", new Object[0]);
                }
                startedCount.incrementAndGet();
            }

            public void stop() {
                if (!this.started.compareAndSet(true, false)) {
                    failedCount.incrementAndGet();
                    throw new ISE("Not yet started started", new Object[0]);
                }
            }
        };
        lifecycle.addHandler(exceptionalHandler);
        lifecycle.start();
        lifecycle.stop();
        lifecycle.stop();
        lifecycle.stop();
        lifecycle.start();
        lifecycle.stop();
        Assert.assertEquals((long)2L, (long)startedCount.get());
        Assert.assertEquals((long)0L, (long)failedCount.get());
        Exception ex = null;
        try {
            exceptionalHandler.stop();
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertNotNull((String)"Should have exception", (Object)ex);
    }

    @Test
    public void testSanity() throws Exception {
        Lifecycle lifecycle = new Lifecycle();
        ArrayList startOrder = Lists.newArrayList();
        ArrayList stopOrder = Lists.newArrayList();
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(0, startOrder, stopOrder));
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(1, startOrder, stopOrder), Lifecycle.Stage.NORMAL);
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(2, startOrder, stopOrder), Lifecycle.Stage.NORMAL);
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(3, startOrder, stopOrder), Lifecycle.Stage.LAST);
        lifecycle.addStartCloseInstance((Object)new ObjectToBeLifecycled(4, startOrder, stopOrder));
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(5, startOrder, stopOrder));
        lifecycle.addStartCloseInstance((Object)new ObjectToBeLifecycled(6, startOrder, stopOrder), Lifecycle.Stage.LAST);
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(7, startOrder, stopOrder));
        List<Integer> expectedOrder = Arrays.asList(0, 1, 2, 4, 5, 7, 3, 6);
        lifecycle.start();
        Assert.assertEquals((long)8L, (long)startOrder.size());
        Assert.assertEquals((long)0L, (long)stopOrder.size());
        Assert.assertEquals(expectedOrder, (Object)startOrder);
        lifecycle.stop();
        Assert.assertEquals((long)8L, (long)startOrder.size());
        Assert.assertEquals((long)8L, (long)stopOrder.size());
        Assert.assertEquals((Object)Lists.reverse(expectedOrder), (Object)stopOrder);
    }

    @Test
    public void testAddToLifecycleInStartMethod() throws Exception {
        final Lifecycle lifecycle = new Lifecycle();
        final ArrayList startOrder = Lists.newArrayList();
        final ArrayList stopOrder = Lists.newArrayList();
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(0, startOrder, stopOrder));
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(1, startOrder, stopOrder), Lifecycle.Stage.NORMAL);
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(2, startOrder, stopOrder), Lifecycle.Stage.NORMAL);
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(3, startOrder, stopOrder), Lifecycle.Stage.LAST);
                lifecycle.addMaybeStartStartCloseInstance((Object)new ObjectToBeLifecycled(4, startOrder, stopOrder));
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(5, startOrder, stopOrder));
                lifecycle.addMaybeStartStartCloseInstance((Object)new ObjectToBeLifecycled(6, startOrder, stopOrder), Lifecycle.Stage.LAST);
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(7, startOrder, stopOrder));
            }

            public void stop() {
            }
        });
        List<Integer> expectedOrder = Arrays.asList(0, 1, 2, 4, 5, 7, 3, 6);
        lifecycle.start();
        Assert.assertEquals(expectedOrder, (Object)startOrder);
        Assert.assertEquals((long)0L, (long)stopOrder.size());
        lifecycle.stop();
        Assert.assertEquals(expectedOrder, (Object)startOrder);
        Assert.assertEquals((Object)Lists.reverse(expectedOrder), (Object)stopOrder);
    }

    public static class ObjectToBeLifecycled {
        private final int id;
        private final List<Integer> orderOfStarts;
        private final List<Integer> orderOfStops;

        public ObjectToBeLifecycled(int id, List<Integer> orderOfStarts, List<Integer> orderOfStops) {
            this.id = id;
            this.orderOfStarts = orderOfStarts;
            this.orderOfStops = orderOfStops;
        }

        @LifecycleStart
        public void start() {
            this.orderOfStarts.add(this.id);
        }

        @LifecycleStop
        public void close() {
            this.orderOfStops.add(this.id);
        }
    }
}

