/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializerFactory;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.SquareNeighbourhood;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.junit.Assert;
import org.junit.Test;

public class NetworkTest {
    final FeatureInitializer init = FeatureInitializerFactory.uniform((double)0.0, (double)2.0);

    @Test
    public void testGetFeaturesSize() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init, this.init, this.init};
        Network net = new NeuronSquareMesh2D(2, false, 2, false, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        Assert.assertEquals((long)3L, (long)net.getFeaturesSize());
    }

    @Test
    public void testDeleteLink() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(2, false, 2, false, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        net.deleteLink(net.getNeuron(0L), net.getNeuron(1L));
        Collection neighbours = net.getNeighbours(net.getNeuron(0L));
        Assert.assertFalse((boolean)neighbours.contains(net.getNeuron(1L)));
        neighbours = net.getNeighbours(net.getNeuron(1L));
        Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(0L)));
    }

    @Test
    public void testDeleteNeuron() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(2, false, 2, false, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        Assert.assertEquals((long)2L, (long)net.getNeighbours(net.getNeuron(0L)).size());
        Assert.assertEquals((long)2L, (long)net.getNeighbours(net.getNeuron(3L)).size());
        net.deleteNeuron(net.getNeuron(1L));
        try {
            net.getNeuron(1L);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)net.getNeighbours(net.getNeuron(0L)).size());
        Assert.assertEquals((long)1L, (long)net.getNeighbours(net.getNeuron(3L)).size());
    }

    @Test
    public void testIterationOrder() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(4, false, 3, true, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        boolean isUnspecifiedOrder = false;
        long previousId = Long.MIN_VALUE;
        for (Neuron n : net.getNeurons((Comparator)new Network.NeuronIdentifierComparator())) {
            long currentId = n.getIdentifier();
            if (currentId < previousId) {
                isUnspecifiedOrder = true;
                break;
            }
            previousId = currentId;
        }
        Assert.assertFalse((boolean)isUnspecifiedOrder);
    }

    @Test
    public void testCopy() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(2, false, 2, false, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        Network copy = net.copy();
        Neuron netNeuron0 = net.getNeuron(0L);
        Neuron copyNeuron0 = copy.getNeuron(0L);
        Neuron netNeuron1 = net.getNeuron(1L);
        Neuron copyNeuron1 = copy.getNeuron(1L);
        Collection netNeighbours = net.getNeighbours(netNeuron0);
        Collection copyNeighbours = copy.getNeighbours(copyNeuron0);
        Assert.assertTrue((boolean)netNeighbours.contains(netNeuron1));
        Assert.assertTrue((boolean)copyNeighbours.contains(copyNeuron1));
        net.deleteNeuron(netNeuron1);
        netNeighbours = net.getNeighbours(netNeuron0);
        copyNeighbours = copy.getNeighbours(copyNeuron0);
        Assert.assertFalse((boolean)netNeighbours.contains(netNeuron1));
        Assert.assertTrue((boolean)copyNeighbours.contains(copyNeuron1));
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network out = new NeuronSquareMesh2D(4, false, 3, true, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(out);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        Network in = (Network)ois.readObject();
        for (Neuron nOut : out) {
            Neuron nIn = in.getNeuron(nOut.getIdentifier());
            double[] outF = nOut.getFeatures();
            double[] inF = nIn.getFeatures();
            Assert.assertEquals((long)outF.length, (long)inF.length);
            for (int i = 0; i < outF.length; ++i) {
                Assert.assertEquals((double)outF[i], (double)inF[i], (double)0.0);
            }
            Collection outNeighbours = out.getNeighbours(nOut);
            Collection inNeighbours = in.getNeighbours(nIn);
            Assert.assertEquals((long)outNeighbours.size(), (long)inNeighbours.size());
            for (Neuron oN : outNeighbours) {
                Assert.assertTrue((boolean)inNeighbours.contains(in.getNeuron(oN.getIdentifier())));
            }
        }
    }
}

