/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutableLongTest {
    @Test
    public void testConstructors() {
        Assertions.assertEquals((long)0L, (long)new MutableLong().longValue());
        Assertions.assertEquals((long)1L, (long)new MutableLong(1L).longValue());
        Assertions.assertEquals((long)2L, (long)new MutableLong((Number)2L).longValue());
        Assertions.assertEquals((long)3L, (long)new MutableLong((Number)new MutableLong(3L)).longValue());
        Assertions.assertEquals((long)2L, (long)new MutableLong("2").longValue());
    }

    @Test
    public void testConstructorNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new MutableLong((Number)null));
    }

    @Test
    public void testGetSet() {
        MutableLong mutNum = new MutableLong(0L);
        Assertions.assertEquals((long)0L, (long)new MutableLong().longValue());
        Assertions.assertEquals((Long)0L, (Long)new MutableLong().getValue());
        mutNum.setValue(1L);
        Assertions.assertEquals((long)1L, (long)mutNum.longValue());
        Assertions.assertEquals((Long)1L, (Long)mutNum.getValue());
        mutNum.setValue((Number)2L);
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
        Assertions.assertEquals((Long)2L, (Long)mutNum.getValue());
        mutNum.setValue((Number)new MutableLong(3L));
        Assertions.assertEquals((long)3L, (long)mutNum.longValue());
        Assertions.assertEquals((Long)3L, (Long)mutNum.getValue());
    }

    @Test
    public void testSetNull() {
        MutableLong mutNum = new MutableLong(0L);
        Assertions.assertThrows(NullPointerException.class, () -> mutNum.setValue(null));
    }

    @Test
    public void testEquals() {
        MutableLong mutNumA = new MutableLong(0L);
        MutableLong mutNumB = new MutableLong(0L);
        MutableLong mutNumC = new MutableLong(1L);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumB);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumB);
        Assertions.assertNotEquals((Object)mutNumA, (Object)mutNumC);
        Assertions.assertNotEquals((Object)mutNumB, (Object)mutNumC);
        Assertions.assertEquals((Object)mutNumC, (Object)mutNumC);
        Assertions.assertNotEquals(null, (Object)mutNumA);
        Assertions.assertNotEquals((Object)mutNumA, (Object)0L);
        Assertions.assertNotEquals((Object)"0", (Object)mutNumA);
    }

    @Test
    public void testHashCode() {
        MutableLong mutNumA = new MutableLong(0L);
        MutableLong mutNumB = new MutableLong(0L);
        MutableLong mutNumC = new MutableLong(1L);
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumA.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumB.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumC.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)Long.valueOf(0L).hashCode());
    }

    @Test
    public void testCompareTo() {
        MutableLong mutNum = new MutableLong(0L);
        Assertions.assertEquals((int)0, (int)mutNum.compareTo(new MutableLong(0L)));
        Assertions.assertEquals((int)1, (int)mutNum.compareTo(new MutableLong(-1L)));
        Assertions.assertEquals((int)-1, (int)mutNum.compareTo(new MutableLong(1L)));
    }

    @Test
    public void testCompareToNull() {
        MutableLong mutNum = new MutableLong(0L);
        Assertions.assertThrows(NullPointerException.class, () -> mutNum.compareTo(null));
    }

    @Test
    public void testPrimitiveValues() {
        MutableLong mutNum = new MutableLong(1L);
        Assertions.assertEquals((float)1.0f, (float)mutNum.floatValue());
        Assertions.assertEquals((double)1.0, (double)mutNum.doubleValue());
        Assertions.assertEquals((byte)1, (byte)mutNum.byteValue());
        Assertions.assertEquals((short)1, (short)mutNum.shortValue());
        Assertions.assertEquals((int)1, (int)mutNum.intValue());
        Assertions.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    public void testToLong() {
        Assertions.assertEquals((Long)0L, (Long)new MutableLong(0L).toLong());
        Assertions.assertEquals((Long)123L, (Long)new MutableLong(123L).toLong());
    }

    @Test
    public void testIncrement() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.increment();
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testIncrementAndGet() {
        MutableLong mutNum = new MutableLong(1L);
        long result = mutNum.incrementAndGet();
        Assertions.assertEquals((long)2L, (long)result);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testGetAndIncrement() {
        MutableLong mutNum = new MutableLong(1L);
        long result = mutNum.getAndIncrement();
        Assertions.assertEquals((long)1L, (long)result);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrement() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.decrement();
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrementAndGet() {
        MutableLong mutNum = new MutableLong(1L);
        long result = mutNum.decrementAndGet();
        Assertions.assertEquals((long)0L, (long)result);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testGetAndDecrement() {
        MutableLong mutNum = new MutableLong(1L);
        long result = mutNum.getAndDecrement();
        Assertions.assertEquals((long)1L, (long)result);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValuePrimitive() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.add(1L);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValueObject() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.add((Number)1L);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testGetAndAddValuePrimitive() {
        MutableLong mutableLong = new MutableLong(0L);
        long result = mutableLong.getAndAdd(1L);
        Assertions.assertEquals((long)0L, (long)result);
        Assertions.assertEquals((long)1L, (long)mutableLong.longValue());
    }

    @Test
    public void testGetAndAddValueObject() {
        MutableLong mutableLong = new MutableLong(0L);
        long result = mutableLong.getAndAdd((Number)1L);
        Assertions.assertEquals((long)0L, (long)result);
        Assertions.assertEquals((long)1L, (long)mutableLong.longValue());
    }

    @Test
    public void testAddAndGetValuePrimitive() {
        MutableLong mutableLong = new MutableLong(0L);
        long result = mutableLong.addAndGet(1L);
        Assertions.assertEquals((long)1L, (long)result);
        Assertions.assertEquals((long)1L, (long)mutableLong.longValue());
    }

    @Test
    public void testAddAndGetValueObject() {
        MutableLong mutableLong = new MutableLong(0L);
        long result = mutableLong.addAndGet((Number)1L);
        Assertions.assertEquals((long)1L, (long)result);
        Assertions.assertEquals((long)1L, (long)mutableLong.longValue());
    }

    @Test
    public void testSubtractValuePrimitive() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.subtract(1L);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testSubtractValueObject() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.subtract((Number)1L);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"0", (Object)new MutableLong(0L).toString());
        Assertions.assertEquals((Object)"10", (Object)new MutableLong(10L).toString());
        Assertions.assertEquals((Object)"-123", (Object)new MutableLong(-123L).toString());
    }
}

