/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.dbcp2.managed.ManagedConnection;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;

public class TestBasicManagedDataSource
extends TestBasicDataSource {
    public TestBasicManagedDataSource(String testName) {
        super(testName);
    }

    @Override
    protected BasicDataSource createDataSource() throws Exception {
        BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();
        basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
        return basicManagedDataSource;
    }

    public void testReallyClose() throws Exception {
        BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();
        basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
        basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
        basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
        basicManagedDataSource.setUsername("username");
        basicManagedDataSource.setPassword("password");
        basicManagedDataSource.setMaxIdle(1);
        ManagedConnection conn = (ManagedConnection)basicManagedDataSource.getConnection();
        TestBasicManagedDataSource.assertNotNull((Object)basicManagedDataSource.getTransactionRegistry().getXAResource((Connection)conn));
        ManagedConnection conn2 = (ManagedConnection)basicManagedDataSource.getConnection();
        conn2.close();
        conn.close();
        try {
            basicManagedDataSource.getTransactionRegistry().getXAResource((Connection)conn);
            TestBasicManagedDataSource.fail((String)"Expecting SQLException - XAResources orphaned");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        conn2.close();
        basicManagedDataSource.close();
    }
}

