/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.cpdsadapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.junit.Assert;

public class TestDriverAdapterCPDS
extends TestCase {
    private DriverAdapterCPDS pcds;

    public TestDriverAdapterCPDS(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.pcds = new DriverAdapterCPDS();
        this.pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        this.pcds.setUrl("jdbc:apache:commons:testdriver");
        this.pcds.setUser("foo");
        this.pcds.setPassword("bar");
        this.pcds.setPoolPreparedStatements(false);
    }

    public void testIncorrectPassword() throws Exception {
        block4: {
            this.pcds.getPooledConnection("u2", "p2").close();
            try {
                this.pcds.getPooledConnection("u1", "zlsafjk");
                TestDriverAdapterCPDS.fail((String)"Able to retrieve connection with incorrect password");
            }
            catch (SQLException e1) {
                // empty catch block
            }
            this.pcds.getPooledConnection("u1", "p1").close();
            try {
                this.pcds.getPooledConnection("u1", "x");
                TestDriverAdapterCPDS.fail((String)"Able to retrieve connection with incorrect password");
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("x is not the correct password")) break block4;
                throw e;
            }
        }
        this.pcds.getPooledConnection("u1", "p1").close();
    }

    public void testSimple() throws Exception {
        Connection conn = this.pcds.getPooledConnection().getConnection();
        TestDriverAdapterCPDS.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        TestDriverAdapterCPDS.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        TestDriverAdapterCPDS.assertNotNull((Object)rset);
        TestDriverAdapterCPDS.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    public void testSimpleWithUsername() throws Exception {
        Connection conn = this.pcds.getPooledConnection("u1", "p1").getConnection();
        TestDriverAdapterCPDS.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        TestDriverAdapterCPDS.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        TestDriverAdapterCPDS.assertNotNull((Object)rset);
        TestDriverAdapterCPDS.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[10];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.pcds.getPooledConnection("u1", "p1").getConnection();
        }
        c[0].close();
        TestDriverAdapterCPDS.assertTrue((boolean)c[0].isClosed());
        c[0] = this.pcds.getPooledConnection("u1", "p1").getConnection();
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.pcds.getPooledConnection("u1", "p1").getConnection();
        }
        for (Connection element : c) {
            element.close();
        }
    }

    public void testSetProperties() throws Exception {
        this.pcds.setUser("bad");
        Properties properties = new Properties();
        properties.put("user", "foo");
        this.pcds.setConnectionProperties(properties);
        this.pcds.getPooledConnection().close();
        TestDriverAdapterCPDS.assertEquals((String)"foo", (String)this.pcds.getUser());
        properties.put("password", "bad");
        TestDriverAdapterCPDS.assertEquals((String)"bar", (String)this.pcds.getPassword());
        this.pcds.getPooledConnection("foo", "bar").close();
        TestDriverAdapterCPDS.assertEquals((String)"bar", (String)this.pcds.getConnectionProperties().getProperty("password"));
    }

    public void testDbcp367() throws Exception {
        int i;
        ThreadDbcp367[] threads = new ThreadDbcp367[200];
        this.pcds.setPoolPreparedStatements(true);
        this.pcds.setMaxPreparedStatements(-1);
        this.pcds.setAccessToUnderlyingConnectionAllowed(true);
        SharedPoolDataSource spds = new SharedPoolDataSource();
        spds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
        spds.setMaxTotal(threads.length + 10);
        spds.setDefaultMaxWaitMillis(-1L);
        spds.setDefaultMaxIdle(10);
        spds.setDefaultAutoCommit(Boolean.FALSE);
        spds.setValidationQuery("SELECT 1");
        spds.setDefaultTimeBetweenEvictionRunsMillis(10000L);
        spds.setDefaultNumTestsPerEvictionRun(-1);
        spds.setDefaultTestWhileIdle(true);
        spds.setDefaultTestOnBorrow(true);
        spds.setDefaultTestOnReturn(false);
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new ThreadDbcp367((DataSource)spds);
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
            Assert.assertFalse((String)("Thread " + i + " has failed"), (boolean)threads[i].isFailed());
        }
    }

    private static class ThreadDbcp367
    extends Thread {
        private final DataSource ds;
        private volatile boolean failed = false;

        public ThreadDbcp367(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public void run() {
            Connection c = null;
            try {
                for (int j = 0; j < 5000; ++j) {
                    c = this.ds.getConnection();
                    c.close();
                }
            }
            catch (SQLException sqle) {
                this.failed = true;
                sqle.printStackTrace();
            }
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

