/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Random;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class SnappyRoundtripTest
extends AbstractTestCase {
    private void roundTripTest(String testFile) throws IOException {
        this.roundTripTest(SnappyRoundtripTest.getFile(testFile), SnappyCompressorOutputStream.createParameterBuilder((int)32768).build());
    }

    private void roundTripTest(File input, Parameters params) throws IOException {
        Throwable throwable;
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + ".raw.sz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            throwable = null;
            try (OutputStream os = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);
                 SnappyCompressorOutputStream sos2 = new SnappyCompressorOutputStream(os, input.length(), params);){
                IOUtils.copy((InputStream)is, (OutputStream)sos2);
            }
            catch (Throwable sos2) {
                throwable = sos2;
                throw sos2;
            }
        }
        System.err.println(input.getName() + " written, uncompressed bytes: " + input.length() + ", compressed bytes: " + outputSz.length() + " after " + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        is = Files.newInputStream(input.toPath(), new OpenOption[0]);
        var7_6 = null;
        try {
            throwable = null;
            try (SnappyCompressorInputStream sis = new SnappyCompressorInputStream(Files.newInputStream(outputSz.toPath(), new OpenOption[0]), params.getWindowSize());){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)sis);
                Assert.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var7_6 = throwable3;
            throw throwable3;
        }
        finally {
            if (is != null) {
                if (var7_6 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {
                        var7_6.addSuppressed(throwable4);
                    }
                } else {
                    is.close();
                }
            }
        }
        System.err.println(outputSz.getName() + " read after " + (System.currentTimeMillis() - start) + "ms");
    }

    private void roundTripTest(byte[] input, Parameters params) throws IOException {
        long start = System.currentTimeMillis();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (SnappyCompressorOutputStream sos = new SnappyCompressorOutputStream((OutputStream)os, (long)input.length, params);){
            sos.write(input);
        }
        System.err.println("byte array written, uncompressed bytes: " + input.length + ", compressed bytes: " + os.size() + " after " + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        var7_6 = null;
        try (SnappyCompressorInputStream sis = new SnappyCompressorInputStream((InputStream)new ByteArrayInputStream(os.toByteArray()), params.getWindowSize());){
            byte[] actual = IOUtils.toByteArray((InputStream)sis);
            Assert.assertArrayEquals((byte[])input, (byte[])actual);
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        System.err.println("byte array read after " + (System.currentTimeMillis() - start) + "ms");
    }

    @Test
    public void blaTarRoundtrip() throws IOException {
        System.err.println("Configuration: default");
        this.roundTripTest("bla.tar");
    }

    @Test
    public void blaTarRoundtripTunedForSpeed() throws IOException {
        System.err.println("Configuration: tuned for speed");
        this.roundTripTest(SnappyRoundtripTest.getFile("bla.tar"), SnappyCompressorOutputStream.createParameterBuilder((int)32768).tunedForSpeed().build());
    }

    @Test
    public void blaTarRoundtripTunedForCompressionRatio() throws IOException {
        System.err.println("Configuration: tuned for compression ratio");
        this.roundTripTest(SnappyRoundtripTest.getFile("bla.tar"), SnappyCompressorOutputStream.createParameterBuilder((int)32768).tunedForCompressionRatio().build());
    }

    @Test
    public void gzippedLoremIpsumRoundtrip() throws IOException {
        this.roundTripTest("lorem-ipsum.txt.gz");
    }

    @Test
    public void biggerFileRoundtrip() throws IOException {
        this.roundTripTest("COMPRESS-256.7z");
    }

    @Test
    public void tryReallyBigOffset() throws IOException {
        File f = new File(this.dir, "reallyBigOffsetTest");
        ByteArrayOutputStream fs = new ByteArrayOutputStream(66560);
        fs.write(0);
        fs.write(0);
        fs.write(0);
        fs.write(0);
        int cnt = 0x200000;
        Random r = new Random();
        for (int i = 0; i < 0x200000; ++i) {
            fs.write(r.nextInt(255) + 1);
        }
        fs.write(0);
        fs.write(0);
        fs.write(0);
        fs.write(0);
        this.roundTripTest(fs.toByteArray(), SnappyRoundtripTest.newParameters(131072, 4, 64, 65536, 65536));
    }

    @Test
    public void tryReallyLongLiterals() throws IOException {
        File f = new File(this.dir, "reallyBigLiteralTest");
        try (OutputStream fs = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            int cnt = 524288;
            Random r = new Random();
            for (int i = 0; i < 524288; ++i) {
                fs.write(r.nextInt(256));
            }
        }
        this.roundTripTest(f, SnappyRoundtripTest.newParameters(262144, 4, 64, 32768, 131072));
    }

    private static Parameters newParameters(int windowSize, int minBackReferenceLength, int maxBackReferenceLength, int maxOffset, int maxLiteralLength) {
        return Parameters.builder((int)windowSize).withMinBackReferenceLength(minBackReferenceLength).withMaxBackReferenceLength(maxBackReferenceLength).withMaxOffset(maxOffset).withMaxLiteralLength(maxLiteralLength).build();
    }
}

