/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lzma;

import org.apache.commons.compress.compressors.lzma.LZMAUtils;
import org.junit.Assert;
import org.junit.Test;

public class LZMAUtilsTestCase {
    @Test
    public void testIsCompressedFilename() {
        Assert.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)""));
        Assert.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)".lzma"));
        Assert.assertTrue((boolean)LZMAUtils.isCompressedFilename((String)"x.lzma"));
        Assert.assertTrue((boolean)LZMAUtils.isCompressedFilename((String)"x-lzma"));
        Assert.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"xxgz"));
        Assert.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"lzmaz"));
        Assert.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"xaz"));
        Assert.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"x.lzma "));
        Assert.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"x.lzma\n"));
        Assert.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"x.lzma.y"));
    }

    @Test
    public void testGetUncompressedFilename() {
        Assert.assertEquals((Object)"", (Object)LZMAUtils.getUncompressedFilename((String)""));
        Assert.assertEquals((Object)".lzma", (Object)LZMAUtils.getUncompressedFilename((String)".lzma"));
        Assert.assertEquals((Object)"x", (Object)LZMAUtils.getUncompressedFilename((String)"x.lzma"));
        Assert.assertEquals((Object)"x", (Object)LZMAUtils.getUncompressedFilename((String)"x-lzma"));
        Assert.assertEquals((Object)"x.lzma ", (Object)LZMAUtils.getUncompressedFilename((String)"x.lzma "));
        Assert.assertEquals((Object)"x.lzma\n", (Object)LZMAUtils.getUncompressedFilename((String)"x.lzma\n"));
        Assert.assertEquals((Object)"x.lzma.y", (Object)LZMAUtils.getUncompressedFilename((String)"x.lzma.y"));
    }

    @Test
    public void testGetCompressedFilename() {
        Assert.assertEquals((Object)".lzma", (Object)LZMAUtils.getCompressedFilename((String)""));
        Assert.assertEquals((Object)"x.lzma", (Object)LZMAUtils.getCompressedFilename((String)"x"));
        Assert.assertEquals((Object)"x.wmf .lzma", (Object)LZMAUtils.getCompressedFilename((String)"x.wmf "));
        Assert.assertEquals((Object)"x.wmf\n.lzma", (Object)LZMAUtils.getCompressedFilename((String)"x.wmf\n"));
        Assert.assertEquals((Object)"x.wmf.y.lzma", (Object)LZMAUtils.getCompressedFilename((String)"x.wmf.y"));
    }

    @Test
    public void testMatches() {
        byte[] data = new byte[]{93, 0, 0};
        Assert.assertFalse((boolean)LZMAUtils.matches((byte[])data, (int)2));
        Assert.assertTrue((boolean)LZMAUtils.matches((byte[])data, (int)3));
        Assert.assertTrue((boolean)LZMAUtils.matches((byte[])data, (int)4));
        data[2] = 48;
        Assert.assertFalse((boolean)LZMAUtils.matches((byte[])data, (int)3));
    }

    @Test
    public void testCachingIsEnabledByDefaultAndLZMAIsPresent() {
        Assert.assertEquals((Object)LZMAUtils.CachedAvailability.CACHED_AVAILABLE, (Object)LZMAUtils.getCachedLZMAAvailability());
        Assert.assertTrue((boolean)LZMAUtils.isLZMACompressionAvailable());
    }

    @Test
    public void testCanTurnOffCaching() {
        try {
            LZMAUtils.setCacheLZMAAvailablity((boolean)false);
            Assert.assertEquals((Object)LZMAUtils.CachedAvailability.DONT_CACHE, (Object)LZMAUtils.getCachedLZMAAvailability());
            Assert.assertTrue((boolean)LZMAUtils.isLZMACompressionAvailable());
        }
        finally {
            LZMAUtils.setCacheLZMAAvailablity((boolean)true);
        }
    }

    @Test
    public void testTurningOnCachingReEvaluatesAvailability() {
        try {
            LZMAUtils.setCacheLZMAAvailablity((boolean)false);
            Assert.assertEquals((Object)LZMAUtils.CachedAvailability.DONT_CACHE, (Object)LZMAUtils.getCachedLZMAAvailability());
            LZMAUtils.setCacheLZMAAvailablity((boolean)true);
            Assert.assertEquals((Object)LZMAUtils.CachedAvailability.CACHED_AVAILABLE, (Object)LZMAUtils.getCachedLZMAAvailability());
        }
        finally {
            LZMAUtils.setCacheLZMAAvailablity((boolean)true);
        }
    }
}

