/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ResourceAlignmentExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipSplitReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ZipFileTest {
    private ZipFile zf = null;

    @After
    public void tearDown() {
        ZipFile.closeQuietly((ZipFile)this.zf);
    }

    @Test
    public void testCDOrder() throws Exception {
        this.readOrderTest();
        ArrayList<ZipArchiveEntry> l = Collections.list(this.zf.getEntries());
        ZipFileTest.assertEntryName(l, 0, "AbstractUnicodeExtraField");
        ZipFileTest.assertEntryName(l, 1, "AsiExtraField");
        ZipFileTest.assertEntryName(l, 2, "ExtraFieldUtils");
        ZipFileTest.assertEntryName(l, 3, "FallbackZipEncoding");
        ZipFileTest.assertEntryName(l, 4, "GeneralPurposeBit");
        ZipFileTest.assertEntryName(l, 5, "JarMarker");
        ZipFileTest.assertEntryName(l, 6, "NioZipEncoding");
        ZipFileTest.assertEntryName(l, 7, "Simple8BitZipEncoding");
        ZipFileTest.assertEntryName(l, 8, "UnicodeCommentExtraField");
        ZipFileTest.assertEntryName(l, 9, "UnicodePathExtraField");
        ZipFileTest.assertEntryName(l, 10, "UnixStat");
        ZipFileTest.assertEntryName(l, 11, "UnparseableExtraFieldData");
        ZipFileTest.assertEntryName(l, 12, "UnrecognizedExtraField");
        ZipFileTest.assertEntryName(l, 13, "ZipArchiveEntry");
        ZipFileTest.assertEntryName(l, 14, "ZipArchiveInputStream");
        ZipFileTest.assertEntryName(l, 15, "ZipArchiveOutputStream");
        ZipFileTest.assertEntryName(l, 16, "ZipEncoding");
        ZipFileTest.assertEntryName(l, 17, "ZipEncodingHelper");
        ZipFileTest.assertEntryName(l, 18, "ZipExtraField");
        ZipFileTest.assertEntryName(l, 19, "ZipUtil");
        ZipFileTest.assertEntryName(l, 20, "ZipLong");
        ZipFileTest.assertEntryName(l, 21, "ZipShort");
        ZipFileTest.assertEntryName(l, 22, "ZipFile");
    }

    @Test
    public void testCDOrderInMemory() throws Exception {
        byte[] data = null;
        try (InputStream fis = Files.newInputStream(AbstractTestCase.getFile("ordertest.zip").toPath(), new OpenOption[0]);){
            data = IOUtils.toByteArray((InputStream)fis);
        }
        this.zf = new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(data), "UTF8");
        ArrayList<ZipArchiveEntry> l = Collections.list(this.zf.getEntries());
        ZipFileTest.assertEntryName(l, 0, "AbstractUnicodeExtraField");
        ZipFileTest.assertEntryName(l, 1, "AsiExtraField");
        ZipFileTest.assertEntryName(l, 2, "ExtraFieldUtils");
        ZipFileTest.assertEntryName(l, 3, "FallbackZipEncoding");
        ZipFileTest.assertEntryName(l, 4, "GeneralPurposeBit");
        ZipFileTest.assertEntryName(l, 5, "JarMarker");
        ZipFileTest.assertEntryName(l, 6, "NioZipEncoding");
        ZipFileTest.assertEntryName(l, 7, "Simple8BitZipEncoding");
        ZipFileTest.assertEntryName(l, 8, "UnicodeCommentExtraField");
        ZipFileTest.assertEntryName(l, 9, "UnicodePathExtraField");
        ZipFileTest.assertEntryName(l, 10, "UnixStat");
        ZipFileTest.assertEntryName(l, 11, "UnparseableExtraFieldData");
        ZipFileTest.assertEntryName(l, 12, "UnrecognizedExtraField");
        ZipFileTest.assertEntryName(l, 13, "ZipArchiveEntry");
        ZipFileTest.assertEntryName(l, 14, "ZipArchiveInputStream");
        ZipFileTest.assertEntryName(l, 15, "ZipArchiveOutputStream");
        ZipFileTest.assertEntryName(l, 16, "ZipEncoding");
        ZipFileTest.assertEntryName(l, 17, "ZipEncodingHelper");
        ZipFileTest.assertEntryName(l, 18, "ZipExtraField");
        ZipFileTest.assertEntryName(l, 19, "ZipUtil");
        ZipFileTest.assertEntryName(l, 20, "ZipLong");
        ZipFileTest.assertEntryName(l, 21, "ZipShort");
        ZipFileTest.assertEntryName(l, 22, "ZipFile");
    }

    @Test
    public void testPhysicalOrder() throws Exception {
        this.readOrderTest();
        ArrayList<ZipArchiveEntry> l = Collections.list(this.zf.getEntriesInPhysicalOrder());
        ZipFileTest.assertEntryName(l, 0, "AbstractUnicodeExtraField");
        ZipFileTest.assertEntryName(l, 1, "AsiExtraField");
        ZipFileTest.assertEntryName(l, 2, "ExtraFieldUtils");
        ZipFileTest.assertEntryName(l, 3, "FallbackZipEncoding");
        ZipFileTest.assertEntryName(l, 4, "GeneralPurposeBit");
        ZipFileTest.assertEntryName(l, 5, "JarMarker");
        ZipFileTest.assertEntryName(l, 6, "NioZipEncoding");
        ZipFileTest.assertEntryName(l, 7, "Simple8BitZipEncoding");
        ZipFileTest.assertEntryName(l, 8, "UnicodeCommentExtraField");
        ZipFileTest.assertEntryName(l, 9, "UnicodePathExtraField");
        ZipFileTest.assertEntryName(l, 10, "UnixStat");
        ZipFileTest.assertEntryName(l, 11, "UnparseableExtraFieldData");
        ZipFileTest.assertEntryName(l, 12, "UnrecognizedExtraField");
        ZipFileTest.assertEntryName(l, 13, "ZipArchiveEntry");
        ZipFileTest.assertEntryName(l, 14, "ZipArchiveInputStream");
        ZipFileTest.assertEntryName(l, 15, "ZipArchiveOutputStream");
        ZipFileTest.assertEntryName(l, 16, "ZipEncoding");
        ZipFileTest.assertEntryName(l, 17, "ZipEncodingHelper");
        ZipFileTest.assertEntryName(l, 18, "ZipExtraField");
        ZipFileTest.assertEntryName(l, 19, "ZipFile");
        ZipFileTest.assertEntryName(l, 20, "ZipLong");
        ZipFileTest.assertEntryName(l, 21, "ZipShort");
        ZipFileTest.assertEntryName(l, 22, "ZipUtil");
    }

    @Test
    public void testPhysicalOrderOfSpecificFile() throws Exception {
        this.readOrderTest();
        String entryName = "src/main/java/org/apache/commons/compress/archivers/zip/ZipExtraField.java";
        Iterable entries = this.zf.getEntriesInPhysicalOrder("src/main/java/org/apache/commons/compress/archivers/zip/ZipExtraField.java");
        Iterator iter = entries.iterator();
        ZipArchiveEntry entry = (ZipArchiveEntry)iter.next();
        Assert.assertEquals((Object)"src/main/java/org/apache/commons/compress/archivers/zip/ZipExtraField.java", (Object)entry.getName());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testDoubleClose() throws Exception {
        this.readOrderTest();
        this.zf.close();
        try {
            this.zf.close();
        }
        catch (Exception ex) {
            Assert.fail((String)"Caught exception of second close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadingOfStoredEntry() throws Exception {
        File f = File.createTempFile("commons-compress-zipfiletest", ".zip");
        f.deleteOnExit();
        OutputStream o = null;
        InputStream i = null;
        try {
            o = Files.newOutputStream(f.toPath(), new OpenOption[0]);
            ZipArchiveOutputStream zo = new ZipArchiveOutputStream(o);
            ZipArchiveEntry ze = new ZipArchiveEntry("foo");
            ze.setMethod(0);
            ze.setSize(4L);
            ze.setCrc(3057449933L);
            zo.putArchiveEntry((ArchiveEntry)ze);
            zo.write(new byte[]{1, 2, 3, 4});
            zo.closeArchiveEntry();
            zo.close();
            o.close();
            o = null;
            this.zf = new ZipFile(f);
            ze = this.zf.getEntry("foo");
            Assert.assertNotNull((Object)ze);
            i = this.zf.getInputStream(ze);
            byte[] b = new byte[4];
            Assert.assertEquals((long)4L, (long)i.read(b));
            Assert.assertEquals((long)-1L, (long)i.read());
        }
        finally {
            if (o != null) {
                o.close();
            }
            if (i != null) {
                i.close();
            }
            f.delete();
        }
    }

    @Test
    public void testWinzipBackSlashWorkaround() throws Exception {
        File archive = AbstractTestCase.getFile("test-winzip.zip");
        this.zf = new ZipFile(archive);
        Assert.assertNull((Object)this.zf.getEntry("\u00e4\\\u00fc.txt"));
        Assert.assertNotNull((Object)this.zf.getEntry("\u00e4/\u00fc.txt"));
    }

    @Test
    public void testSkipsPK00Prefix() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-208.zip");
        this.zf = new ZipFile(archive);
        Assert.assertNotNull((Object)this.zf.getEntry("test1.xml"));
        Assert.assertNotNull((Object)this.zf.getEntry("test2.xml"));
    }

    @Test
    public void testUnixSymlinkSampleFile() throws Exception {
        String entryPrefix = "COMPRESS-214_unix_symlinks/";
        TreeMap<String, String> expectedVals = new TreeMap<String, String>();
        expectedVals.put("COMPRESS-214_unix_symlinks/link1", "../COMPRESS-214_unix_symlinks/./a/b/c/../../../\uf999");
        expectedVals.put("COMPRESS-214_unix_symlinks/link2", "../COMPRESS-214_unix_symlinks/./a/b/c/../../../g");
        expectedVals.put("COMPRESS-214_unix_symlinks/link3", "../COMPRESS-214_unix_symlinks/././a/b/c/../../../\u76f4\u6a39");
        expectedVals.put("COMPRESS-214_unix_symlinks/link4", "\u82b1\u5b50/\u745b\u5b50");
        expectedVals.put("COMPRESS-214_unix_symlinks/\uf999", "./\u82b1\u5b50/\u745b\u5b50/\u5897\u8c37/\uf999");
        expectedVals.put("COMPRESS-214_unix_symlinks/g", "./a/b/c/d/e/f/g");
        expectedVals.put("COMPRESS-214_unix_symlinks/\u76f4\u6a39", "./g");
        expectedVals.put("COMPRESS-214_unix_symlinks/link5", "../COMPRESS-214_unix_symlinks/././a/b");
        expectedVals.put("COMPRESS-214_unix_symlinks/link6", "../COMPRESS-214_unix_symlinks/././a/b/");
        File archive = AbstractTestCase.getFile("COMPRESS-214_unix_symlinks.zip");
        this.zf = new ZipFile(archive);
        Enumeration en = this.zf.getEntries();
        while (en.hasMoreElements()) {
            ZipArchiveEntry zae = (ZipArchiveEntry)en.nextElement();
            String link = this.zf.getUnixSymlink(zae);
            if (zae.isUnixSymlink()) {
                String name = zae.getName();
                String expected = (String)expectedVals.get(name);
                Assert.assertEquals((Object)expected, (Object)link);
                continue;
            }
            Assert.assertNull((Object)link);
        }
    }

    @Test
    public void testDuplicateEntry() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-227.zip");
        this.zf = new ZipFile(archive);
        ZipArchiveEntry ze = this.zf.getEntry("test1.txt");
        Assert.assertNotNull((Object)ze);
        Assert.assertNotNull((Object)this.zf.getInputStream(ze));
        int numberOfEntries = 0;
        for (ZipArchiveEntry entry : this.zf.getEntries("test1.txt")) {
            ++numberOfEntries;
            Assert.assertNotNull((Object)this.zf.getInputStream(entry));
        }
        Assert.assertEquals((long)2L, (long)numberOfEntries);
    }

    @Test
    public void testExcessDataInZip64ExtraField() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-228.zip");
        this.zf = new ZipFile(archive);
        ZipArchiveEntry ze = this.zf.getEntry("src/main/java/org/apache/commons/compress/archivers/zip/ZipFile.java");
        Assert.assertEquals((long)26101L, (long)ze.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnshrinking() throws Exception {
        this.zf = new ZipFile(AbstractTestCase.getFile("SHRUNK.ZIP"));
        ZipArchiveEntry test = this.zf.getEntry("TEST1.XML");
        try (InputStream original = Files.newInputStream(AbstractTestCase.getFile("test1.xml").toPath(), new OpenOption[0]);){
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)this.zf.getInputStream(test)));
        }
        test = this.zf.getEntry("TEST2.XML");
        original = Files.newInputStream(AbstractTestCase.getFile("test2.xml").toPath(), new OpenOption[0]);
        try {
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)this.zf.getInputStream(test)));
        }
        finally {
            original.close();
        }
    }

    @Test
    public void testReadingOfFirstStoredEntry() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-264.zip");
        this.zf = new ZipFile(archive);
        ZipArchiveEntry ze = this.zf.getEntry("test.txt");
        Assert.assertEquals((long)5L, (long)ze.getSize());
        Assert.assertArrayEquals((byte[])new byte[]{100, 97, 116, 97, 10}, (byte[])IOUtils.toByteArray((InputStream)this.zf.getInputStream(ze)));
    }

    @Test
    public void testUnzipBZip2CompressedEntry() throws Exception {
        File archive = AbstractTestCase.getFile("bzip2-zip.zip");
        this.zf = new ZipFile(archive);
        ZipArchiveEntry ze = this.zf.getEntry("lots-of-as");
        Assert.assertEquals((long)42L, (long)ze.getSize());
        byte[] expected = new byte[42];
        Arrays.fill(expected, (byte)97);
        Assert.assertArrayEquals((byte[])expected, (byte[])IOUtils.toByteArray((InputStream)this.zf.getInputStream(ze)));
    }

    @Test
    public void testConcurrentReadSeekable() throws Exception {
        byte[] data = null;
        InputStream fis = Files.newInputStream(AbstractTestCase.getFile("mixed.zip").toPath(), new OpenOption[0]);
        Object object = null;
        try {
            data = IOUtils.toByteArray((InputStream)fis);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fis != null) {
                if (object != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fis.close();
                }
            }
        }
        this.zf = new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(data), "UTF8");
        HashMap<String, byte[]> content = new HashMap<String, byte[]>();
        for (ZipArchiveEntry entry : Collections.list(this.zf.getEntries())) {
            content.put(entry.getName(), IOUtils.toByteArray((InputStream)this.zf.getInputStream(entry)));
        }
        AtomicInteger passedCount = new AtomicInteger();
        Runnable run = () -> {
            for (ZipArchiveEntry entry : Collections.list(this.zf.getEntries())) {
                this.assertAllReadMethods((byte[])content.get(entry.getName()), this.zf, entry);
            }
            passedCount.incrementAndGet();
        };
        Thread t0 = new Thread(run);
        Thread t1 = new Thread(run);
        t0.start();
        t1.start();
        t0.join();
        t1.join();
        Assert.assertEquals((long)2L, (long)passedCount.get());
    }

    @Test
    public void testConcurrentReadFile() throws Exception {
        File archive = AbstractTestCase.getFile("mixed.zip");
        this.zf = new ZipFile(archive);
        HashMap<String, byte[]> content = new HashMap<String, byte[]>();
        for (ZipArchiveEntry entry : Collections.list(this.zf.getEntries())) {
            content.put(entry.getName(), IOUtils.toByteArray((InputStream)this.zf.getInputStream(entry)));
        }
        AtomicInteger passedCount = new AtomicInteger();
        Runnable run = () -> {
            for (ZipArchiveEntry entry : Collections.list(this.zf.getEntries())) {
                this.assertAllReadMethods((byte[])content.get(entry.getName()), this.zf, entry);
            }
            passedCount.incrementAndGet();
        };
        Thread t0 = new Thread(run);
        Thread t1 = new Thread(run);
        t0.start();
        t1.start();
        t0.join();
        t1.join();
        Assert.assertEquals((long)2L, (long)passedCount.get());
    }

    @Test
    public void testOffsets() throws Exception {
        File archive = AbstractTestCase.getFile("mixed.zip");
        try (ZipFile zf = new ZipFile(archive);){
            ZipArchiveEntry inflatedEntry = zf.getEntry("inflated.txt");
            Assert.assertEquals((long)0L, (long)inflatedEntry.getLocalHeaderOffset());
            Assert.assertEquals((long)70L, (long)inflatedEntry.getDataOffset());
            Assert.assertTrue((boolean)inflatedEntry.isStreamContiguous());
            ZipArchiveEntry storedEntry = zf.getEntry("stored.txt");
            Assert.assertEquals((long)22674L, (long)storedEntry.getLocalHeaderOffset());
            Assert.assertEquals((long)22742L, (long)storedEntry.getDataOffset());
            Assert.assertTrue((boolean)inflatedEntry.isStreamContiguous());
        }
    }

    @Test
    public void testDelayedOffsetsAndSizes() throws Exception {
        ZipArchiveEntry inflatedEntry;
        ByteArrayOutputStream zipContent = new ByteArrayOutputStream();
        try (ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream((OutputStream)zipContent);){
            inflatedEntry = new ZipArchiveEntry("inflated.txt");
            inflatedEntry.setMethod(8);
            zipOutput.putArchiveEntry((ArchiveEntry)inflatedEntry);
            zipOutput.write("Hello Deflated\n".getBytes());
            zipOutput.closeArchiveEntry();
            byte[] storedContent = "Hello Stored\n".getBytes();
            ZipArchiveEntry storedEntry = new ZipArchiveEntry("stored.txt");
            storedEntry.setMethod(0);
            storedEntry.setSize((long)storedContent.length);
            storedEntry.setCrc(this.calculateCrc32(storedContent));
            zipOutput.putArchiveEntry((ArchiveEntry)storedEntry);
            zipOutput.write("Hello Stored\n".getBytes());
            zipOutput.closeArchiveEntry();
        }
        var3_3 = null;
        try (ZipFile zf = new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(zipContent.toByteArray()));){
            inflatedEntry = zf.getEntry("inflated.txt");
            Assert.assertNotEquals((long)-1L, (long)inflatedEntry.getLocalHeaderOffset());
            Assert.assertNotEquals((long)-1L, (long)inflatedEntry.getDataOffset());
            Assert.assertTrue((boolean)inflatedEntry.isStreamContiguous());
            Assert.assertNotEquals((long)-1L, (long)inflatedEntry.getCompressedSize());
            Assert.assertNotEquals((long)-1L, (long)inflatedEntry.getSize());
            ZipArchiveEntry storedEntry = zf.getEntry("stored.txt");
            Assert.assertNotEquals((long)-1L, (long)storedEntry.getLocalHeaderOffset());
            Assert.assertNotEquals((long)-1L, (long)storedEntry.getDataOffset());
            Assert.assertTrue((boolean)inflatedEntry.isStreamContiguous());
            Assert.assertNotEquals((long)-1L, (long)storedEntry.getCompressedSize());
            Assert.assertNotEquals((long)-1L, (long)storedEntry.getSize());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testEntryAlignment() throws Exception {
        Object storedEntry3;
        ZipArchiveEntry inflatedEntry;
        SeekableInMemoryByteChannel zipContent = new SeekableInMemoryByteChannel();
        try (ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream((SeekableByteChannel)zipContent);){
            inflatedEntry = new ZipArchiveEntry("inflated.txt");
            inflatedEntry.setMethod(8);
            inflatedEntry.setAlignment(1024);
            zipOutput.putArchiveEntry((ArchiveEntry)inflatedEntry);
            zipOutput.write("Hello Deflated\n".getBytes(StandardCharsets.UTF_8));
            zipOutput.closeArchiveEntry();
            ZipArchiveEntry storedEntry = new ZipArchiveEntry("stored.txt");
            storedEntry.setMethod(0);
            storedEntry.setAlignment(1024);
            zipOutput.putArchiveEntry((ArchiveEntry)storedEntry);
            zipOutput.write("Hello Stored\n".getBytes(StandardCharsets.UTF_8));
            zipOutput.closeArchiveEntry();
            ZipArchiveEntry storedEntry2 = new ZipArchiveEntry("stored2.txt");
            storedEntry2.setMethod(0);
            storedEntry2.setAlignment(1024);
            storedEntry2.addExtraField((ZipExtraField)new ResourceAlignmentExtraField(1));
            zipOutput.putArchiveEntry((ArchiveEntry)storedEntry2);
            zipOutput.write("Hello overload-alignment Stored\n".getBytes(StandardCharsets.UTF_8));
            zipOutput.closeArchiveEntry();
            storedEntry3 = new ZipArchiveEntry("stored3.txt");
            storedEntry3.setMethod(0);
            storedEntry3.addExtraField((ZipExtraField)new ResourceAlignmentExtraField(1024));
            zipOutput.putArchiveEntry((ArchiveEntry)storedEntry3);
            zipOutput.write("Hello copy-alignment Stored\n".getBytes(StandardCharsets.UTF_8));
            zipOutput.closeArchiveEntry();
        }
        var3_3 = null;
        try (ZipFile zf = new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(Arrays.copyOfRange(zipContent.array(), 0, (int)zipContent.size())));){
            inflatedEntry = zf.getEntry("inflated.txt");
            ResourceAlignmentExtraField inflatedAlignmentEx = (ResourceAlignmentExtraField)inflatedEntry.getExtraField(ResourceAlignmentExtraField.ID);
            Assert.assertNotEquals((long)-1L, (long)inflatedEntry.getCompressedSize());
            Assert.assertNotEquals((long)-1L, (long)inflatedEntry.getSize());
            Assert.assertEquals((long)0L, (long)(inflatedEntry.getDataOffset() % 1024L));
            Assert.assertNotNull((Object)inflatedAlignmentEx);
            Assert.assertEquals((long)1024L, (long)inflatedAlignmentEx.getAlignment());
            Assert.assertFalse((boolean)inflatedAlignmentEx.allowMethodChange());
            InputStream stream = zf.getInputStream(inflatedEntry);
            storedEntry3 = null;
            try {
                Assert.assertEquals((Object)"Hello Deflated\n", (Object)new String(IOUtils.toByteArray((InputStream)stream), StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                storedEntry3 = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (storedEntry3 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)storedEntry3).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            ZipArchiveEntry storedEntry = zf.getEntry("stored.txt");
            ResourceAlignmentExtraField storedAlignmentEx = (ResourceAlignmentExtraField)storedEntry.getExtraField(ResourceAlignmentExtraField.ID);
            Assert.assertNotEquals((long)-1L, (long)storedEntry.getCompressedSize());
            Assert.assertNotEquals((long)-1L, (long)storedEntry.getSize());
            Assert.assertEquals((long)0L, (long)(storedEntry.getDataOffset() % 1024L));
            Assert.assertNotNull((Object)storedAlignmentEx);
            Assert.assertEquals((long)1024L, (long)storedAlignmentEx.getAlignment());
            Assert.assertFalse((boolean)storedAlignmentEx.allowMethodChange());
            try (InputStream stream2 = zf.getInputStream(storedEntry);){
                Assert.assertEquals((Object)"Hello Stored\n", (Object)new String(IOUtils.toByteArray((InputStream)stream2), StandardCharsets.UTF_8));
            }
            ZipArchiveEntry storedEntry2 = zf.getEntry("stored2.txt");
            ResourceAlignmentExtraField stored2AlignmentEx = (ResourceAlignmentExtraField)storedEntry2.getExtraField(ResourceAlignmentExtraField.ID);
            Assert.assertNotEquals((long)-1L, (long)storedEntry2.getCompressedSize());
            Assert.assertNotEquals((long)-1L, (long)storedEntry2.getSize());
            Assert.assertEquals((long)0L, (long)(storedEntry2.getDataOffset() % 1024L));
            Assert.assertNotNull((Object)stored2AlignmentEx);
            Assert.assertEquals((long)1024L, (long)stored2AlignmentEx.getAlignment());
            Assert.assertFalse((boolean)stored2AlignmentEx.allowMethodChange());
            try (InputStream stream3 = zf.getInputStream(storedEntry2);){
                Assert.assertEquals((Object)"Hello overload-alignment Stored\n", (Object)new String(IOUtils.toByteArray((InputStream)stream3), StandardCharsets.UTF_8));
            }
            ZipArchiveEntry storedEntry32 = zf.getEntry("stored3.txt");
            ResourceAlignmentExtraField stored3AlignmentEx = (ResourceAlignmentExtraField)storedEntry32.getExtraField(ResourceAlignmentExtraField.ID);
            Assert.assertNotEquals((long)-1L, (long)storedEntry32.getCompressedSize());
            Assert.assertNotEquals((long)-1L, (long)storedEntry32.getSize());
            Assert.assertEquals((long)0L, (long)(storedEntry32.getDataOffset() % 1024L));
            Assert.assertNotNull((Object)stored3AlignmentEx);
            Assert.assertEquals((long)1024L, (long)stored3AlignmentEx.getAlignment());
            Assert.assertFalse((boolean)stored3AlignmentEx.allowMethodChange());
            try (InputStream stream4 = zf.getInputStream(storedEntry32);){
                Assert.assertEquals((Object)"Hello copy-alignment Stored\n", (Object)new String(IOUtils.toByteArray((InputStream)stream4), StandardCharsets.UTF_8));
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntryAlignmentExceed() throws Exception {
        SeekableInMemoryByteChannel zipContent = new SeekableInMemoryByteChannel();
        try (ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream((SeekableByteChannel)zipContent);){
            ZipArchiveEntry inflatedEntry = new ZipArchiveEntry("inflated.txt");
            inflatedEntry.setMethod(0);
            inflatedEntry.setAlignment(131072);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidAlignment() throws Exception {
        ZipArchiveEntry entry = new ZipArchiveEntry("dummy");
        entry.setAlignment(3);
    }

    @Test
    public void nameSourceDefaultsToName() throws Exception {
        ZipFileTest.nameSource("bla.zip", "test1.xml", ZipArchiveEntry.NameSource.NAME);
    }

    @Test
    public void nameSourceIsSetToUnicodeExtraField() throws Exception {
        ZipFileTest.nameSource("utf8-winzip-test.zip", "\u20ac_for_Dollar.txt", ZipArchiveEntry.NameSource.UNICODE_EXTRA_FIELD);
    }

    @Test
    public void nameSourceIsSetToEFS() throws Exception {
        ZipFileTest.nameSource("utf8-7zip-test.zip", "\u20ac_for_Dollar.txt", ZipArchiveEntry.NameSource.NAME_WITH_EFS_FLAG);
    }

    @Test
    public void readDeflate64CompressedStream() throws Exception {
        File input = AbstractTestCase.getFile("COMPRESS-380/COMPRESS-380-input");
        File archive = AbstractTestCase.getFile("COMPRESS-380/COMPRESS-380.zip");
        try (InputStream in = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZipFile zf = new ZipFile(archive);){
            byte[] orig = IOUtils.toByteArray((InputStream)in);
            ZipArchiveEntry e = zf.getEntry("input2");
            try (InputStream s = zf.getInputStream(e);){
                byte[] fromZip = IOUtils.toByteArray((InputStream)s);
                Assert.assertArrayEquals((byte[])orig, (byte[])fromZip);
            }
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("bla.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingStore() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("COMPRESS-264.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingUnshrink() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("SHRUNK.ZIP"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingExplode() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("imploding-8Kdict-3trees.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate64() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("COMPRESS-380/COMPRESS-380.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingBzip2() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("bzip2-zip.zip"));
    }

    private void singleByteReadConsistentlyReturnsMinusOneAtEof(File file) throws Exception {
        try (ZipFile archive = new ZipFile(file);){
            ZipArchiveEntry e = (ZipArchiveEntry)archive.getEntries().nextElement();
            try (InputStream is = archive.getInputStream(e);){
                IOUtils.toByteArray((InputStream)is);
                Assert.assertEquals((long)-1L, (long)is.read());
                Assert.assertEquals((long)-1L, (long)is.read());
            }
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("bla.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingStore() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("COMPRESS-264.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingUnshrink() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("SHRUNK.ZIP"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingExplode() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("imploding-8Kdict-3trees.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate64() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("COMPRESS-380/COMPRESS-380.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingBzip2() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(AbstractTestCase.getFile("bzip2-zip.zip"));
    }

    @Test
    public void extractFileLiesAcrossSplitZipSegmentsCreatedByZip() throws Exception {
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
        this.zf = new ZipFile(channel);
        ZipArchiveEntry zipEntry = this.zf.getEntry("commons-compress/src/main/java/org/apache/commons/compress/archivers/dump/UnsupportedCompressionAlgorithmException.java");
        File fileToCompare = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/file_to_compare_1");
        this.assertFileEqualsToEntry(fileToCompare, zipEntry, this.zf);
        zipEntry = this.zf.getEntry("commons-compress/src/main/java/org/apache/commons/compress/compressors/deflate/DeflateParameters.java");
        fileToCompare = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/file_to_compare_2");
        this.assertFileEqualsToEntry(fileToCompare, zipEntry, this.zf);
    }

    @Test
    public void extractFileLiesAcrossSplitZipSegmentsCreatedByZipOfZip64() throws Exception {
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip_zip64.zip");
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
        this.zf = new ZipFile(channel);
        ZipArchiveEntry zipEntry = this.zf.getEntry("commons-compress/src/main/java/org/apache/commons/compress/archivers/dump/UnsupportedCompressionAlgorithmException.java");
        File fileToCompare = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/file_to_compare_1");
        this.assertFileEqualsToEntry(fileToCompare, zipEntry, this.zf);
        zipEntry = this.zf.getEntry("commons-compress/src/main/java/org/apache/commons/compress/compressors/deflate/DeflateParameters.java");
        fileToCompare = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/file_to_compare_2");
        this.assertFileEqualsToEntry(fileToCompare, zipEntry, this.zf);
    }

    @Test
    public void extractFileLiesAcrossSplitZipSegmentsCreatedByWinrar() throws Exception {
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_winrar/split_zip_created_by_winrar.zip");
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
        this.zf = new ZipFile(channel);
        ZipArchiveEntry zipEntry = this.zf.getEntry("commons-compress/src/main/java/org/apache/commons/compress/archivers/zip/ZipArchiveInputStream.java");
        File fileToCompare = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_winrar/file_to_compare_1");
        this.assertFileEqualsToEntry(fileToCompare, zipEntry, this.zf);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetLevelTooSmallForZipArchiveOutputStream() throws Exception {
        ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        outputStream.setLevel(-2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetLevelTooBigForZipArchiveOutputStream() throws Exception {
        ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        outputStream.setLevel(10);
    }

    @Test(expected=IllegalStateException.class)
    public void throwsExceptionWhenWritingPreamble() throws IOException {
        ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        outputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry());
        outputStream.writePreamble(ByteUtils.EMPTY_BYTE_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelfExtractingZipUsingUnzipsfx() throws IOException, InterruptedException {
        File unzipsfx = new File("/usr/bin/unzipsfx");
        if (!unzipsfx.exists()) {
            return;
        }
        File testZip = File.createTempFile("commons-compress-selfExtractZipTest", ".zip");
        testZip.deleteOnExit();
        String testEntryName = "test_self_extract_zip/foo";
        File extractedFile = new File(testZip.getParentFile(), "test_self_extract_zip/foo");
        extractedFile.deleteOnExit();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        byte[] testData = new byte[]{1, 2, 3, 4};
        byte[] buffer = new byte[512];
        try (InputStream unzipsfxInputStream = Files.newInputStream(unzipsfx.toPath(), new OpenOption[0]);){
            int bytesRead;
            outputStream = Files.newOutputStream(testZip.toPath(), new OpenOption[0]);
            ZipArchiveOutputStream zo = new ZipArchiveOutputStream(outputStream);
            while ((bytesRead = unzipsfxInputStream.read(buffer)) > 0) {
                zo.writePreamble(buffer, 0, bytesRead);
            }
            ZipArchiveEntry ze = new ZipArchiveEntry("test_self_extract_zip/foo");
            ze.setMethod(0);
            ze.setSize(4L);
            ze.setCrc(3057449933L);
            zo.putArchiveEntry((ArchiveEntry)ze);
            zo.write(testData);
            zo.closeArchiveEntry();
            zo.close();
            outputStream.close();
            outputStream = null;
            ProcessBuilder pbChmod = new ProcessBuilder("chmod", "+x", testZip.getPath());
            pbChmod.redirectErrorStream(true);
            Process processChmod = pbChmod.start();
            Assert.assertEquals((String)new String(IOUtils.toByteArray((InputStream)processChmod.getInputStream())), (long)0L, (long)processChmod.waitFor());
            ProcessBuilder pb = new ProcessBuilder(testZip.getPath());
            pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
            pb.directory(testZip.getParentFile());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            Assert.assertEquals((String)new String(IOUtils.toByteArray((InputStream)process.getInputStream())), (long)0L, (long)process.waitFor());
            if (!extractedFile.exists()) {
                Assert.fail((String)"Can not find the extracted file");
            }
            inputStream = Files.newInputStream(extractedFile.toPath(), new OpenOption[0]);
            bytesRead = IOUtils.readFully((InputStream)inputStream, (byte[])buffer);
            Assert.assertEquals((long)testData.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])testData, (byte[])Arrays.copyOfRange(buffer, 0, bytesRead));
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            testZip.delete();
            extractedFile.delete();
            extractedFile.getParentFile().delete();
        }
    }

    private void multiByteReadConsistentlyReturnsMinusOneAtEof(File file) throws Exception {
        byte[] buf = new byte[2];
        try (ZipFile archive = new ZipFile(file);){
            ZipArchiveEntry e = (ZipArchiveEntry)archive.getEntries().nextElement();
            try (InputStream is = archive.getInputStream(e);){
                IOUtils.toByteArray((InputStream)is);
                Assert.assertEquals((long)-1L, (long)is.read(buf));
                Assert.assertEquals((long)-1L, (long)is.read(buf));
            }
        }
    }

    private void assertAllReadMethods(byte[] expected, ZipFile zipFile, ZipArchiveEntry entry) {
        byte[] full2;
        Throwable throwable;
        InputStream stream;
        try {
            stream = this.zf.getInputStream(entry);
            throwable = null;
            try {
                full2 = IOUtils.toByteArray((InputStream)stream);
                Assert.assertArrayEquals((byte[])expected, (byte[])full2);
            }
            catch (Throwable full2) {
                throwable = full2;
                throw full2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable full2) {
                            throwable.addSuppressed(full2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            stream = this.zf.getInputStream(entry);
            throwable = null;
            try {
                byte[] bytes = new byte[262144];
                int read = stream.read(bytes);
                full2 = read < 0 ? ByteUtils.EMPTY_BYTE_ARRAY : this.readStreamRest(bytes, read, stream);
                Assert.assertArrayEquals((byte[])expected, (byte[])full2);
            }
            catch (Throwable full3) {
                throwable = full3;
                throw full3;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable full3) {
                            throwable.addSuppressed(full3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            stream = this.zf.getInputStream(entry);
            throwable = null;
            try {
                int single = stream.read();
                if (single < 0) {
                    full2 = ByteUtils.EMPTY_BYTE_ARRAY;
                } else {
                    byte[] big = new byte[262144];
                    big[0] = (byte)single;
                    int read = stream.read(big, 1, big.length - 1);
                    full2 = read < 0 ? new byte[]{(byte)single} : this.readStreamRest(big, read + 1, stream);
                }
                Assert.assertArrayEquals((byte[])expected, (byte[])full2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private byte[] readStreamRest(byte[] beginning, int length, InputStream stream) throws IOException {
        byte[] rest = IOUtils.toByteArray((InputStream)stream);
        byte[] full = new byte[length + rest.length];
        System.arraycopy(beginning, 0, full, 0, length);
        System.arraycopy(rest, 0, full, length, rest.length);
        return full;
    }

    private long calculateCrc32(byte[] content) {
        CRC32 crc = new CRC32();
        crc.update(content);
        return crc.getValue();
    }

    private void readOrderTest() throws Exception {
        File archive = AbstractTestCase.getFile("ordertest.zip");
        this.zf = new ZipFile(archive);
    }

    private static void assertEntryName(ArrayList<ZipArchiveEntry> entries, int index, String expectedName) {
        ZipArchiveEntry ze = entries.get(index);
        Assert.assertEquals((Object)("src/main/java/org/apache/commons/compress/archivers/zip/" + expectedName + ".java"), (Object)ze.getName());
    }

    private static void nameSource(String archive, String entry, ZipArchiveEntry.NameSource expected) throws Exception {
        try (ZipFile zf = new ZipFile(AbstractTestCase.getFile(archive));){
            ZipArchiveEntry ze = zf.getEntry(entry);
            Assert.assertEquals((Object)entry, (Object)ze.getName());
            Assert.assertEquals((Object)expected, (Object)ze.getNameSource());
        }
    }

    private void assertFileEqualsToEntry(File fileToCompare, ZipArchiveEntry entry, ZipFile zipFile) throws IOException {
        int readLen;
        byte[] buffer = new byte[10240];
        File tempFile = File.createTempFile("temp", "txt");
        OutputStream outputStream = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);
        InputStream inputStream = zipFile.getInputStream(entry);
        while ((readLen = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, readLen);
        }
        outputStream.close();
        inputStream.close();
        this.assertFileEqualIgnoreEndOfLine(fileToCompare, tempFile);
    }

    private void assertFileEqualIgnoreEndOfLine(File file1, File file2) throws IOException {
        List<String> linesOfFile1 = Files.readAllLines(Paths.get(file1.getCanonicalPath(), new String[0]), StandardCharsets.UTF_8);
        List<String> linesOfFile2 = Files.readAllLines(Paths.get(file2.getCanonicalPath(), new String[0]), StandardCharsets.UTF_8);
        if (linesOfFile1.size() != linesOfFile2.size()) {
            Assert.fail((String)("files not equal : " + file1.getName() + " , " + file2.getName()));
        }
        for (int i = 0; i < linesOfFile1.size(); ++i) {
            String tempLineInFile1 = linesOfFile1.get(i).replace("\r\n", "\n");
            String tempLineInFile2 = linesOfFile2.get(i).replace("\r\n", "\n");
            Assert.assertEquals((Object)tempLineInFile1, (Object)tempLineInFile2);
        }
    }
}

