/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateTimes {
    public static final DateTime EPOCH = DateTimes.utc(0L);
    public static final DateTime MAX = DateTimes.utc(0x3FFFFFFFFFFFFFFFL);
    public static final DateTime MIN = DateTimes.utc(-4611686018427387904L);
    public static final UtcFormatter ISO_DATE_TIME = DateTimes.wrapFormatter(ISODateTimeFormat.dateTime());
    public static final UtcFormatter ISO_DATE_OPTIONAL_TIME = DateTimes.wrapFormatter(ISODateTimeFormat.dateOptionalTimeParser());
    public static final UtcFormatter ISO_DATE_OR_TIME = DateTimes.wrapFormatter(ISODateTimeFormat.dateTimeParser());
    public static final UtcFormatter ISO_DATE_OR_TIME_WITH_OFFSET = DateTimes.wrapFormatter(ISODateTimeFormat.dateTimeParser().withOffsetParsed());

    public static UtcFormatter wrapFormatter(DateTimeFormatter formatter) {
        return new UtcFormatter(formatter);
    }

    public static DateTime utc(long instant) {
        return new DateTime(instant, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static DateTime of(String instant) {
        return new DateTime((Object)instant, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static DateTime nowUtc() {
        return DateTime.now((Chronology)ISOChronology.getInstanceUTC());
    }

    public static DateTime max(DateTime dt1, DateTime dt2) {
        return dt1.compareTo((ReadableInstant)dt2) >= 0 ? dt1 : dt2;
    }

    public static DateTime min(DateTime dt1, DateTime dt2) {
        return dt1.compareTo((ReadableInstant)dt2) < 0 ? dt1 : dt2;
    }

    private DateTimes() {
    }

    public static class UtcFormatter {
        private final DateTimeFormatter innerFormatter;

        private UtcFormatter(DateTimeFormatter innerFormatter) {
            this.innerFormatter = innerFormatter.withChronology((Chronology)ISOChronology.getInstanceUTC());
        }

        public DateTime parse(String instant) {
            return this.innerFormatter.parseDateTime(instant);
        }
    }
}

