/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.exceptions.TransactionFailedException;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;

public class TestTransactionAnnotation {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testTx() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Something s = dao.insertAndFetch(1, "Ian");
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)new Something(1, "Ian")));
    }

    @Test
    public void testTxFail() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        try {
            dao.failed(1, "Ian");
            Assert.fail((String)"should have raised exception");
        }
        catch (TransactionFailedException e) {
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.equalTo((Object)"woof"));
        }
        Assert.assertThat((Object)dao.findById(1), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testNestedTransactions() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Something s = dao.insertAndFetchWithNestedTransaction(1, "Ian");
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)new Something(1, "Ian")));
    }

    @Test
    public void testTxActuallyCommits() throws Exception {
        Handle h2 = this.dbi.open();
        Dao one = (Dao)this.handle.attach(Dao.class);
        Dao two = (Dao)h2.attach(Dao.class);
        Something inserted = one.insertAndFetch(1, "Brian");
        Something fetched = two.findById(1);
        Assert.assertThat((Object)fetched, (Matcher)CoreMatchers.equalTo((Object)inserted));
    }

    @Test
    public void testConcurrent() throws Exception {
        ExecutorService es = Executors.newFixedThreadPool(3);
        final CountDownLatch inserted = new CountDownLatch(1);
        final CountDownLatch committed = new CountDownLatch(1);
        final Other o = (Other)this.dbi.onDemand(Other.class);
        Future<Void> rf = es.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    o.insert(inserted, 1, "diwaker");
                    committed.countDown();
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }
        });
        Future<Void> tf = es.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    inserted.await();
                    committed.await();
                    Something s2 = o.find(1);
                    Assert.assertThat((Object)s2, (Matcher)CoreMatchers.equalTo((Object)new Something(1, "diwaker")));
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }
        });
        rf.get();
        tf.get();
        es.shutdown();
    }

    @RegisterMapper(value={SomethingMapper.class})
    public static abstract class Dao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public abstract void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public abstract Something findById(@Bind(value="id") int var1);

        @Transaction(value=TransactionIsolationLevel.READ_COMMITTED)
        public Something insertAndFetch(int id, String name) {
            this.insert(id, name);
            return this.findById(id);
        }

        @Transaction
        public Something insertAndFetchWithNestedTransaction(int id, String name) {
            return this.insertAndFetch(id, name);
        }

        @Transaction
        public Something failed(int id, String name) throws IOException {
            this.insert(id, name);
            throw new IOException("woof");
        }
    }

    @RegisterMapper(value={SomethingMapper.class})
    public static abstract class Other {
        @Transaction
        public void insert(CountDownLatch inserted, int id, String name) throws InterruptedException {
            this.reallyInsert(id, name);
            inserted.countDown();
        }

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public abstract void reallyInsert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public abstract Something find(@Bind(value="id") int var1);
    }
}

