/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.CreateSqlObject;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestCreateSqlObjectAnnotation {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testSimpleCreate() throws Exception {
        Foo foo = (Foo)this.handle.attach(Foo.class);
        foo.insert(1, "Stephane");
        Something s = foo.createBar().findById(1);
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)new Something(1, "Stephane")));
    }

    @Test
    public void testInsertAndFind() throws Exception {
        Foo foo = (Foo)this.handle.attach(Foo.class);
        Something s = foo.insertAndFind(1, "Stephane");
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)new Something(1, "Stephane")));
    }

    @Test
    public void testTransactionPropagates() throws Exception {
        Foo foo = (Foo)this.dbi.onDemand(Foo.class);
        try {
            foo.insertAndFail(1, "Jeff");
            Assert.fail((String)"should have raised an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Something n = foo.createBar().findById(1);
        Assert.assertThat((Object)n, (Matcher)CoreMatchers.nullValue());
    }

    public static abstract class Bar {
        @SqlQuery(value="select id, name from something where id = :it")
        public abstract Something findById(@Bind int var1);

        public Something explode() {
            throw new RuntimeException();
        }
    }

    public static abstract class Foo {
        @CreateSqlObject
        public abstract Bar createBar();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public abstract int insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @Transaction
        public Something insertAndFind(int id, String name) {
            this.insert(id, name);
            return this.createBar().findById(id);
        }

        @Transaction
        public Something insertAndFail(int id, String name) {
            this.insert(id, name);
            return this.createBar().explode();
        }
    }
}

