/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.docs;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.helpers.MapResultAsBean;

public class TestFoldToObjectGraph {
    private DBI dbi;
    private Handle handle;
    private Map<String, Team> expected;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.handle = this.dbi.open();
        this.handle.execute("create table team ( name varchar(100),                     mascot varchar(100),                    primary key (name) )", new Object[0]);
        this.handle.execute("create table person( name varchar(100),                      role varchar(100),                      team varchar(100),                     primary key (name),                     foreign key (team) references team(name) )", new Object[0]);
        this.handle.prepareBatch("insert into team (name, mascot) values (?, ?)").add(new Object[]{"A-Team", "The Van"}).add(new Object[]{"Hogan's Heroes", "The Tunnel"}).execute();
        this.handle.prepareBatch("insert into person (name, role, team) values (?, ?, ?)").add(new Object[]{"Kinchloe", "comms", "Hogan's Heroes"}).add(new Object[]{"Carter", "bombs", "Hogan's Heroes"}).add(new Object[]{"Murdoch", "driver", "A-Team"}).add(new Object[]{"Peck", "face", "A-Team"}).execute();
        Team ateam = new Team("A-Team", "The Van");
        ateam.getPeople().add(new Person("Murdoch", "driver"));
        ateam.getPeople().add(new Person("Peck", "face"));
        Team hogans = new Team("Hogan's Heroes", "The Tunnel");
        hogans.getPeople().add(new Person("Kinchloe", "comms"));
        hogans.getPeople().add(new Person("Carter", "bombs"));
        this.expected = ImmutableMap.of((Object)"Hogan's Heroes", (Object)hogans, (Object)"A-Team", (Object)ateam);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.close();
    }

    @Test
    public void testFluentApi() throws Exception {
        Map teams = (Map)this.handle.createQuery("select t.name as teamName,        t.mascot as mascot,        p.name as personName,        p.role as role from team t inner join person p on (t.name = p.team)").map(TeamPersonJoinRow.class).fold((Object)Maps.newHashMap(), (Folder3)new TeamFolder());
        Assert.assertThat((Object)teams, (Matcher)CoreMatchers.equalTo(this.expected));
    }

    @Test
    public void testSqlObjectApi() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Assert.assertThat(dao.findAllTeams(), (Matcher)CoreMatchers.equalTo(this.expected));
    }

    public static class TeamPersonJoinRow {
        private String teamName;
        private String mascot;
        private String personName;
        private String role;

        public String getTeamName() {
            return this.teamName;
        }

        public String getMascot() {
            return this.mascot;
        }

        public String getPersonName() {
            return this.personName;
        }

        public String getRole() {
            return this.role;
        }

        public void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        public void setMascot(String mascot) {
            this.mascot = mascot;
        }

        public void setPersonName(String personName) {
            this.personName = personName;
        }

        public void setRole(String role) {
            this.role = role;
        }
    }

    public static class Person {
        private final String name;
        private final String role;

        public Person(String name, String role) {
            this.name = name;
            this.role = role;
        }

        public String getName() {
            return this.name;
        }

        public String getRole() {
            return this.role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.name.equals(person.name) && this.role.equals(person.role);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.role.hashCode();
            return result;
        }
    }

    public static class Team {
        private final String name;
        private final String mascot;
        private final Set<Person> people = new LinkedHashSet<Person>();

        public Team(String name, String mascot) {
            this.name = name;
            this.mascot = mascot;
        }

        public String getName() {
            return this.name;
        }

        public String getMascot() {
            return this.mascot;
        }

        public Set<Person> getPeople() {
            return this.people;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Team team = (Team)o;
            if (this.mascot != null ? !this.mascot.equals(team.mascot) : team.mascot != null) {
                return false;
            }
            return !(this.name == null ? team.name != null : !this.name.equals(team.name)) && !(this.people == null ? team.people != null : !this.people.equals(team.people));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.mascot != null ? this.mascot.hashCode() : 0);
            result = 31 * result + (this.people != null ? this.people.hashCode() : 0);
            return result;
        }
    }

    public static abstract class Dao {
        @SqlQuery(value="select t.name as teamName,        t.mascot as mascot,        p.name as personName,        p.role as role from team t inner join person p on (t.name = p.team)")
        @MapResultAsBean
        public abstract Iterator<TeamPersonJoinRow> findAllTeamsAndPeople();

        public Map<String, Team> findAllTeams() {
            Iterator<TeamPersonJoinRow> i = this.findAllTeamsAndPeople();
            HashMap acc = Maps.newHashMap();
            while (i.hasNext()) {
                TeamPersonJoinRow row = i.next();
                if (!acc.containsKey(row.getTeamName())) {
                    acc.put(row.getTeamName(), new Team(row.getTeamName(), row.getMascot()));
                }
                ((Team)acc.get(row.getTeamName())).getPeople().add(new Person(row.getPersonName(), row.getRole()));
            }
            return acc;
        }
    }

    public static class TeamFolder
    implements Folder3<Map<String, Team>, TeamPersonJoinRow> {
        public Map<String, Team> fold(Map<String, Team> acc, TeamPersonJoinRow row, FoldController control, StatementContext ctx) throws SQLException {
            if (!acc.containsKey(row.getTeamName())) {
                acc.put(row.getTeamName(), new Team(row.getTeamName(), row.getMascot()));
            }
            acc.get(row.getTeamName()).getPeople().add(new Person(row.getPersonName(), row.getRole()));
            return acc;
        }
    }
}

