/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Script;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.StatementException;

public class TestScript
extends DBITestCase {
    @Test
    public void testScriptStuff() throws Exception {
        BasicHandle h = this.openHandle();
        Script s = h.createScript("default-data");
        s.execute();
        Assert.assertEquals((long)2L, (long)h.select("select * from something", new Object[0]).size());
    }

    @Test
    public void testScriptWithComments() throws Exception {
        BasicHandle h = this.openHandle();
        Script script = h.createScript("insert-script-with-comments");
        script.execute();
        Assert.assertEquals((long)3L, (long)h.select("select * from something", new Object[0]).size());
    }

    @Test
    public void testScriptAsSetOfSeparateStatements() throws Exception {
        try {
            BasicHandle h = this.openHandle();
            Script script = h.createScript("malformed-sql-script");
            script.executeAsSeparateStatements();
            Assert.fail((String)"Should fail because the script is malformed");
        }
        catch (StatementException e) {
            StatementContext context = e.getStatementContext();
            Assert.assertEquals((Object)context.getRawSql().trim(), (Object)"insert into something(id, name) values (2, eric)");
        }
    }
}

