/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;

public class TestPositionalParameterBinding
extends DBITestCase {
    private BasicHandle h;

    @Override
    public void doSetUp() throws Exception {
        this.h = this.openHandle();
    }

    @Test
    public void testSetPositionalString() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        Something eric = (Something)((Query)this.h.createQuery("select * from something where name = ?").bind(0, "eric")).map(Something.class).list().get(0);
        Assert.assertEquals((long)1L, (long)eric.getId());
    }

    @Test
    public void testSetPositionalInteger() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        Something eric = (Something)((Query)this.h.createQuery("select * from something where id = ?").bind(0, 1)).map(Something.class).list().get(0);
        Assert.assertEquals((long)1L, (long)eric.getId());
    }

    @Test
    public void testBehaviorOnBadBinding1() throws Exception {
        Query q = ((Query)this.h.createQuery("select * from something where id = ? and name = ?").bind(0, 1)).map(Something.class);
        try {
            q.list();
            Assert.fail((String)"should have thrown exception");
        }
        catch (UnableToExecuteStatementException e) {
            Assert.assertTrue((String)"Execution goes through here", (boolean)true);
        }
        catch (Exception e) {
            Assert.fail((String)"Threw an incorrect exception type");
        }
    }

    @Test
    public void testBehaviorOnBadBinding2() throws Exception {
        Query q = ((Query)((Query)this.h.createQuery("select * from something where id = ?").bind(1, 1)).bind(2, "Hi")).map(Something.class);
        try {
            q.list();
            Assert.fail((String)"should have thrown exception");
        }
        catch (UnableToExecuteStatementException e) {
            Assert.assertTrue((String)"Execution goes through here", (boolean)true);
        }
        catch (Exception e) {
            Assert.fail((String)"Threw an incorrect exception type");
        }
    }

    @Test
    public void testInsertParamBinding() throws Exception {
        int count = ((Update)this.h.createStatement("insert into something (id, name) values (?, 'eric')").bind(0, 1)).execute();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testPositionalConvenienceInsert() throws Exception {
        int count = this.h.insert("insert into something (id, name) values (?, ?)", new Object[]{1, "eric"});
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testWeirdPositionalSyntax() throws Exception {
    }
}

