/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.handler.resumable;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.asynchttpclient.handler.resumable.ResumableRandomAccessFileListener;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.testng.annotations.Test;

public class ResumableRandomAccessFileListenerTest {
    @Test
    public void testOnBytesReceivedBufferHasArray() throws IOException {
        RandomAccessFile file = (RandomAccessFile)PowerMockito.mock(RandomAccessFile.class);
        ResumableRandomAccessFileListener listener = new ResumableRandomAccessFileListener(file);
        byte[] array = new byte[]{1, 2, 23, 33};
        ByteBuffer buf = ByteBuffer.wrap(array);
        listener.onBytesReceived(buf);
        ((RandomAccessFile)Mockito.verify((Object)file)).write(array, 0, 4);
    }

    @Test
    public void testOnBytesReceivedBufferHasNoArray() throws IOException {
        RandomAccessFile file = (RandomAccessFile)PowerMockito.mock(RandomAccessFile.class);
        ResumableRandomAccessFileListener listener = new ResumableRandomAccessFileListener(file);
        byte[] byteArray = new byte[]{1, 2, 23, 33};
        ByteBuffer buf = ByteBuffer.allocateDirect(4);
        buf.put(byteArray);
        buf.flip();
        listener.onBytesReceived(buf);
        ((RandomAccessFile)Mockito.verify((Object)file)).write(byteArray);
    }
}

