/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.util.Date;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RedirectConnectionUsageTest
extends AbstractBasicTest {
    private String BASE_URL;
    private String servletEndpointRedirectUrl;

    @BeforeClass
    public void setUp() throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        ServletContextHandler context = new ServletContextHandler(1);
        context.addServlet(new ServletHolder((Servlet)new MockRedirectHttpServlet()), "/redirect/*");
        context.addServlet(new ServletHolder((Servlet)new MockFullResponseHttpServlet()), "/*");
        this.server.setHandler((Handler)context);
        this.server.start();
        this.port1 = connector.getLocalPort();
        this.BASE_URL = "http://localhost:" + this.port1;
        this.servletEndpointRedirectUrl = this.BASE_URL + "/redirect";
    }

    @Test(groups={"standalone"})
    public void testGetRedirectFinalUrl() throws Exception {
        DefaultAsyncHttpClientConfig config = Dsl.config().setKeepAlive(true).setMaxConnectionsPerHost(1).setMaxConnections(1).setConnectTimeout(1000).setRequestTimeout(1000).setFollowRedirect(true).build();
        try (AsyncHttpClient c = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            ListenableFuture response = c.executeRequest(Dsl.get((String)this.servletEndpointRedirectUrl));
            Response res = null;
            res = (Response)response.get();
            Assert.assertNotNull((Object)res.getResponseBody());
            Assert.assertEquals((String)res.getUri().toString(), (String)(this.BASE_URL + "/overthere"));
        }
    }

    class MockFullResponseHttpServlet
    extends HttpServlet {
        private static final String contentType = "text/xml";
        private static final String xml = "<?xml version=\"1.0\"?><hello date=\"%s\"></hello>";

        MockFullResponseHttpServlet() {
        }

        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            String xmlToReturn = String.format(xml, new Date().toString());
            res.setStatus(200);
            res.addHeader("Content-Type", contentType);
            res.addHeader("X-Method", req.getMethod());
            res.addHeader("MultiValue", "1");
            res.addHeader("MultiValue", "2");
            res.addHeader("MultiValue", "3");
            ServletOutputStream os = res.getOutputStream();
            byte[] retVal = xmlToReturn.getBytes();
            res.setContentLength(retVal.length);
            os.write(retVal);
            os.close();
        }
    }

    class MockRedirectHttpServlet
    extends HttpServlet {
        MockRedirectHttpServlet() {
        }

        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            res.sendRedirect("/overthere");
        }
    }
}

