/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NonAsciiContentLengthTest
extends AbstractBasicTest {
    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        this.server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                int MAX_BODY_SIZE = 1024;
                byte[] b = new byte[MAX_BODY_SIZE];
                int offset = 0;
                try (ServletInputStream is = request.getInputStream();){
                    int numBytesRead;
                    while ((numBytesRead = is.read(b, offset, MAX_BODY_SIZE - offset)) != -1) {
                        offset += numBytesRead;
                    }
                }
                Assert.assertEquals((int)request.getContentLength(), (int)offset);
                response.setStatus(200);
                response.setCharacterEncoding(request.getCharacterEncoding());
                response.setContentLength(request.getContentLength());
                var10_9 = null;
                try (ServletOutputStream os = response.getOutputStream();){
                    os.write(b, 0, offset);
                }
                catch (Throwable throwable) {
                    var10_9 = throwable;
                    throw throwable;
                }
            }
        });
        this.server.start();
        this.port1 = connector.getLocalPort();
    }

    @Test(groups={"standalone"})
    public void testNonAsciiContentLength() throws Exception {
        this.execute("test");
        this.execute("\u4e00");
    }

    protected void execute(String body) throws IOException, InterruptedException, ExecutionException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            BoundRequestBuilder r = (BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(body)).setCharset(StandardCharsets.UTF_8);
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get();
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)body, (String)resp.getResponseBody(StandardCharsets.UTF_8));
        }
    }
}

