/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class HttpToHttpsRedirectTest
extends AbstractBasicTest {
    private final AtomicBoolean redirectDone = new AtomicBoolean(false);

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector1 = TestUtils.addHttpConnector(this.server);
        ServerConnector connector2 = TestUtils.addHttpsConnector(this.server);
        this.server.setHandler((Handler)new Relative302Handler());
        this.server.start();
        this.port1 = connector1.getLocalPort();
        this.port2 = connector2.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Test(groups={"standalone"})
    public void runAllSequentiallyBecauseNotThreadSafe() throws Exception {
        this.httpToHttpsRedirect();
        this.httpToHttpsProperConfig();
        this.relativeLocationUrl();
    }

    public void httpToHttpsRedirect() throws Exception {
        this.redirectDone.getAndSet(false);
        DefaultAsyncHttpClientConfig cg = Dsl.config().setMaxRedirects(5).setFollowRedirect(true).setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient c = Dsl.asyncHttpClient((AsyncHttpClientConfig)cg);){
            Response response = (Response)((BoundRequestBuilder)c.prepareGet(this.getTargetUrl()).setHeader((CharSequence)"X-redirect", this.getTargetUrl2())).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-httpToHttps"), (String)"PASS");
        }
    }

    public void httpToHttpsProperConfig() throws Exception {
        this.redirectDone.getAndSet(false);
        DefaultAsyncHttpClientConfig cg = Dsl.config().setMaxRedirects(5).setFollowRedirect(true).setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient c = Dsl.asyncHttpClient((AsyncHttpClientConfig)cg);){
            Response response = (Response)((BoundRequestBuilder)c.prepareGet(this.getTargetUrl()).setHeader((CharSequence)"X-redirect", this.getTargetUrl2() + "/test2")).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-httpToHttps"), (String)"PASS");
            response = (Response)((BoundRequestBuilder)c.prepareGet(this.getTargetUrl()).setHeader((CharSequence)"X-redirect", this.getTargetUrl2() + "/foo2")).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-httpToHttps"), (String)"PASS");
        }
    }

    public void relativeLocationUrl() throws Exception {
        this.redirectDone.getAndSet(false);
        DefaultAsyncHttpClientConfig cg = Dsl.config().setMaxRedirects(5).setFollowRedirect(true).setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient c = Dsl.asyncHttpClient((AsyncHttpClientConfig)cg);){
            Response response = (Response)((BoundRequestBuilder)c.prepareGet(this.getTargetUrl()).setHeader((CharSequence)"X-redirect", "/foo/test")).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getUri().toString(), (String)this.getTargetUrl());
        }
    }

    private class Relative302Handler
    extends AbstractHandler {
        private Relative302Handler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            httpResponse.setContentType("text/html;charset=UTF-8");
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                if (!param.startsWith("X-redirect") || HttpToHttpsRedirectTest.this.redirectDone.getAndSet(true)) continue;
                httpResponse.addHeader("Location", httpRequest.getHeader(param));
                httpResponse.setStatus(302);
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
                return;
            }
            if (r.getScheme().equalsIgnoreCase("https")) {
                httpResponse.addHeader("X-httpToHttps", "PASS");
                HttpToHttpsRedirectTest.this.redirectDone.getAndSet(false);
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

