/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.EchoHandler;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BasicHttpProxyToHttpsTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicHttpProxyToHttpsTest.class);
    private int httpPort;
    private int proxyPort;
    private Server httpServer;
    private Server proxy;

    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.httpServer = new Server();
        ServerConnector connector1 = TestUtils.addHttpsConnector(this.httpServer);
        this.httpServer.setHandler((Handler)new EchoHandler());
        this.httpServer.start();
        this.httpPort = connector1.getLocalPort();
        this.proxy = new Server();
        ServerConnector connector2 = TestUtils.addHttpConnector(this.proxy);
        ConnectHandler connectHandler = new ConnectHandler(){

            protected boolean handleAuthentication(HttpServletRequest request, HttpServletResponse response, String address) {
                String authorization = request.getHeader("Proxy-Authorization");
                if (authorization == null) {
                    response.setStatus(407);
                    response.setHeader("Proxy-Authenticate", "Basic realm=\"Fake Realm\"");
                    return false;
                }
                if (authorization.equals("Basic am9obmRvZTpwYXNz")) {
                    return true;
                }
                response.setStatus(401);
                return false;
            }
        };
        this.proxy.setHandler((Handler)connectHandler);
        this.proxy.start();
        this.proxyPort = connector2.getLocalPort();
        LOGGER.info("Local HTTP Server (" + this.httpPort + "), Proxy (" + this.proxyPort + ") started successfully");
    }

    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.httpServer.stop();
        this.proxy.stop();
    }

    @Test
    public void nonPreemptyProxyAuthWithHttpsTarget() throws IOException, InterruptedException, ExecutionException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setAcceptAnyCertificate(true));){
            String targetUrl = "https://localhost:" + this.httpPort + "/foo/bar";
            Request request = ((RequestBuilder)Dsl.get((String)targetUrl).setProxyServer(Dsl.proxyServer((String)"127.0.0.1", (int)this.proxyPort).setRealm(Dsl.realm((Realm.AuthScheme)Realm.AuthScheme.BASIC, (String)"johndoe", (String)"pass")))).build();
            ListenableFuture responseFuture = client.executeRequest(request);
            Response response = (Response)responseFuture.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)"/foo/bar", (String)response.getHeader("X-pathInfo"));
        }
    }
}

