/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.util;

import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.calcite.runtime.Utilities;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableIntList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ImmutableBitSetTest {
    @Test
    public void testIterator() {
        this.assertToIterBitSet("", ImmutableBitSet.of());
        this.assertToIterBitSet("0", ImmutableBitSet.of((int[])new int[]{0}));
        this.assertToIterBitSet("0, 1", ImmutableBitSet.of((int[])new int[]{0, 1}));
        this.assertToIterBitSet("10", ImmutableBitSet.of((int[])new int[]{10}));
    }

    private void assertToIterBitSet(String expected, ImmutableBitSet bitSet) {
        StringBuilder buf = new StringBuilder();
        Iterator iterator = bitSet.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(i));
        }
        Assert.assertEquals((Object)expected, (Object)buf.toString());
    }

    @Test
    public void testToList() {
        Assert.assertThat((Object)ImmutableBitSet.of().toList(), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{5}).toList(), (Matcher)CoreMatchers.equalTo(Arrays.asList(5)));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{3, 5}).toList(), (Matcher)CoreMatchers.equalTo(Arrays.asList(3, 5)));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{63}).toList(), (Matcher)CoreMatchers.equalTo(Arrays.asList(63)));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{64}).toList(), (Matcher)CoreMatchers.equalTo(Arrays.asList(64)));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{3, 63}).toList(), (Matcher)CoreMatchers.equalTo(Arrays.asList(3, 63)));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{3, 64}).toList(), (Matcher)CoreMatchers.equalTo(Arrays.asList(3, 64)));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 4, 2}).toList(), (Matcher)CoreMatchers.equalTo(Arrays.asList(0, 2, 4)));
    }

    @Test
    public void testRange() {
        Assert.assertEquals((Object)ImmutableBitSet.range((int)0, (int)4).toList(), Arrays.asList(0, 1, 2, 3));
        Assert.assertEquals((Object)ImmutableBitSet.range((int)1, (int)4).toList(), Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)ImmutableBitSet.range((int)4).toList(), Arrays.asList(0, 1, 2, 3));
        Assert.assertEquals((Object)ImmutableBitSet.range((int)0).toList(), Collections.emptyList());
        Assert.assertEquals((Object)ImmutableBitSet.range((int)2, (int)2).toList(), Collections.emptyList());
        Assert.assertThat((Object)ImmutableBitSet.range((int)63, (int)66).toString(), (Matcher)CoreMatchers.equalTo((Object)"{63, 64, 65}"));
        Assert.assertThat((Object)ImmutableBitSet.range((int)65, (int)68).toString(), (Matcher)CoreMatchers.equalTo((Object)"{65, 66, 67}"));
        Assert.assertThat((Object)ImmutableBitSet.range((int)65, (int)65).toString(), (Matcher)CoreMatchers.equalTo((Object)"{}"));
        Assert.assertThat((Object)ImmutableBitSet.range((int)65, (int)65).length(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)ImmutableBitSet.range((int)65, (int)165).cardinality(), (Matcher)CoreMatchers.equalTo((Object)100));
        Assert.assertThat((Object)ImmutableBitSet.builder().set(63, 66).build().toString(), (Matcher)CoreMatchers.equalTo((Object)"{63, 64, 65}"));
        Assert.assertThat((Object)ImmutableBitSet.builder().set(65, 68).build().toString(), (Matcher)CoreMatchers.equalTo((Object)"{65, 66, 67}"));
        Assert.assertThat((Object)ImmutableBitSet.builder().set(65, 65).build().toString(), (Matcher)CoreMatchers.equalTo((Object)"{}"));
        Assert.assertThat((Object)ImmutableBitSet.builder().set(65, 65).build().length(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)ImmutableBitSet.builder().set(65, 165).build().cardinality(), (Matcher)CoreMatchers.equalTo((Object)100));
        ImmutableBitSet e0 = ImmutableBitSet.range((int)0, (int)0);
        ImmutableBitSet e1 = ImmutableBitSet.of();
        Assert.assertTrue((boolean)e0.equals((Object)e1));
        Assert.assertThat((Object)e0.hashCode(), (Matcher)CoreMatchers.equalTo((Object)e1.hashCode()));
        Assert.assertTrue((ImmutableBitSet.builder().build() == ImmutableBitSet.of() ? 1 : 0) != 0);
    }

    @Test
    public void testCompare() {
        List<ImmutableBitSet> sorted = this.getSortedList();
        for (int i = 0; i < sorted.size(); ++i) {
            for (int j = 0; j < sorted.size(); ++j) {
                ImmutableBitSet set1;
                ImmutableBitSet set0 = sorted.get(i);
                int c = set0.compareTo(set1 = sorted.get(j));
                if (c == 0) {
                    Assert.assertTrue((i == j || i == 3 && j == 4 || i == 4 && j == 3 ? 1 : 0) != 0);
                } else {
                    Assert.assertEquals((long)c, (long)Utilities.compare((int)i, (int)j));
                }
                Assert.assertEquals((Object)(c == 0 ? 1 : 0), (Object)set0.equals((Object)set1));
                Assert.assertEquals((Object)(c == 0 ? 1 : 0), (Object)set1.equals((Object)set0));
            }
        }
    }

    @Test
    public void testCompare2() {
        List<ImmutableBitSet> sorted = this.getSortedList();
        Collections.sort(sorted, ImmutableBitSet.COMPARATOR);
        Assert.assertThat((Object)sorted.toString(), (Matcher)CoreMatchers.equalTo((Object)"[{0, 1, 3}, {0, 1}, {1, 1000}, {1}, {1}, {2, 3}, {}]"));
    }

    private List<ImmutableBitSet> getSortedList() {
        return Arrays.asList(ImmutableBitSet.of(), ImmutableBitSet.of((int[])new int[]{0, 1}), ImmutableBitSet.of((int[])new int[]{0, 1, 3}), ImmutableBitSet.of((int[])new int[]{1}), ImmutableBitSet.of((int[])new int[]{1}), ImmutableBitSet.of((int[])new int[]{1, 1000}), ImmutableBitSet.of((int[])new int[]{2, 3}));
    }

    @Test
    public void testToArray() {
        int[][] arrays;
        for (int[] array : arrays = new int[][]{new int[0], {0}, {0, 2}, {1, 65}, {100}}) {
            Assert.assertThat((Object)ImmutableBitSet.of((int[])array).toArray(), (Matcher)CoreMatchers.equalTo((Object)array));
        }
    }

    @Test
    public void testAsList() {
        List<ImmutableBitSet> list = this.getSortedList();
        HashSet<Integer> integers = new HashSet<Integer>();
        for (ImmutableBitSet set : list) {
            for (Integer integer : set) {
                integers.add(integer);
                integers.add(integer + 1);
                integers.add(integer + 10);
            }
        }
        for (ImmutableBitSet bitSet : list) {
            List list1 = bitSet.toList();
            List listView = bitSet.asList();
            Set setView = bitSet.asSet();
            Assert.assertThat((Object)list1.size(), (Matcher)CoreMatchers.equalTo((Object)bitSet.cardinality()));
            Assert.assertThat((Object)listView.size(), (Matcher)CoreMatchers.equalTo((Object)bitSet.cardinality()));
            Assert.assertThat((Object)setView.size(), (Matcher)CoreMatchers.equalTo((Object)bitSet.cardinality()));
            Assert.assertThat((Object)list1.toString(), (Matcher)CoreMatchers.equalTo((Object)listView.toString()));
            Assert.assertThat((Object)list1.toString(), (Matcher)CoreMatchers.equalTo((Object)setView.toString()));
            Assert.assertTrue((boolean)list1.equals(listView));
            Assert.assertThat((Object)list1.hashCode(), (Matcher)CoreMatchers.equalTo((Object)listView.hashCode()));
            HashSet set = new HashSet(list1);
            Assert.assertThat((Object)setView.hashCode(), (Matcher)CoreMatchers.is((Object)set.hashCode()));
            Assert.assertThat((Object)setView, (Matcher)CoreMatchers.equalTo(set));
            for (Integer integer : integers) {
                boolean b = list1.contains(integer);
                Assert.assertThat((Object)listView.contains(integer), (Matcher)CoreMatchers.is((Object)b));
                Assert.assertThat((Object)setView.contains(integer), (Matcher)CoreMatchers.is((Object)b));
            }
        }
    }

    @Test
    public void testUnion() {
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{1}).union(ImmutableBitSet.of((int[])new int[]{3})).toString(), (Matcher)CoreMatchers.equalTo((Object)"{1, 3}"));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{1}).union(ImmutableBitSet.of((int[])new int[]{3, 100})).toString(), (Matcher)CoreMatchers.equalTo((Object)"{1, 3, 100}"));
        ImmutableBitSet x = ImmutableBitSet.of((int[])new int[]{1}).rebuild().addAll(ImmutableBitSet.of((int[])new int[]{2})).addAll(ImmutableBitSet.of()).addAll(ImmutableBitSet.of((int[])new int[]{3})).build();
        Assert.assertThat((Object)x.toString(), (Matcher)CoreMatchers.equalTo((Object)"{1, 2, 3}"));
    }

    @Test
    public void testIntersect() {
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{1, 2, 3, 100, 200}).intersect(ImmutableBitSet.of((int[])new int[]{2, 100})).toString(), (Matcher)CoreMatchers.equalTo((Object)"{2, 100}"));
        Assert.assertTrue((ImmutableBitSet.of((int[])new int[]{1, 3, 5, 101, 20001}).intersect(ImmutableBitSet.of((int[])new int[]{2, 100})) == ImmutableBitSet.of() ? 1 : 0) != 0);
    }

    @Test
    public void testBitSetsContains() {
        Assert.assertTrue((boolean)ImmutableBitSet.range((int)0, (int)5).contains(ImmutableBitSet.range((int)2, (int)4)));
        Assert.assertTrue((boolean)ImmutableBitSet.range((int)0, (int)5).contains(ImmutableBitSet.range((int)4)));
        Assert.assertFalse((boolean)ImmutableBitSet.range((int)0, (int)5).contains(ImmutableBitSet.of((int[])new int[]{14})));
        Assert.assertFalse((boolean)ImmutableBitSet.range((int)20, (int)25).contains(ImmutableBitSet.of((int[])new int[]{14})));
        ImmutableBitSet empty = ImmutableBitSet.of();
        Assert.assertTrue((boolean)ImmutableBitSet.range((int)20, (int)25).contains(empty));
        Assert.assertTrue((boolean)empty.contains(empty));
        Assert.assertFalse((boolean)empty.contains(ImmutableBitSet.of((int[])new int[]{0})));
        Assert.assertFalse((boolean)empty.contains(ImmutableBitSet.of((int[])new int[]{1})));
        Assert.assertFalse((boolean)empty.contains(ImmutableBitSet.of((int[])new int[]{63})));
        Assert.assertFalse((boolean)empty.contains(ImmutableBitSet.of((int[])new int[]{64})));
        Assert.assertFalse((boolean)empty.contains(ImmutableBitSet.of((int[])new int[]{1000})));
        Assert.assertTrue((boolean)ImmutableBitSet.of((int[])new int[]{1, 4, 7}).contains(ImmutableBitSet.of((int[])new int[]{1, 4, 7})));
    }

    @Test
    public void testBitSetOfImmutableIntList() {
        ImmutableIntList list = ImmutableIntList.of();
        Assert.assertThat((Object)ImmutableBitSet.of((ImmutableIntList)list), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of()));
        list = ImmutableIntList.of((int[])new int[]{2, 70, 5, 0});
        Assert.assertThat((Object)ImmutableBitSet.of((ImmutableIntList)list), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 5, 70})));
    }

    @Test
    public void testPreviousClearBit() {
        Assert.assertThat((Object)ImmutableBitSet.of().previousClearBit(10), (Matcher)CoreMatchers.equalTo((Object)10));
        Assert.assertThat((Object)ImmutableBitSet.of().previousClearBit(0), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)ImmutableBitSet.of().previousClearBit(-1), (Matcher)CoreMatchers.equalTo((Object)-1));
        try {
            int actual = ImmutableBitSet.of().previousClearBit(-2);
            Assert.fail((String)("expected exception, got " + actual));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4}).previousClearBit(4), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4}).previousClearBit(3), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4}).previousClearBit(2), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4}).previousClearBit(1), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{1, 3, 4}).previousClearBit(1), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testBuilder() {
        Assert.assertThat((Object)ImmutableBitSet.builder().set(9).set(100).set(1000).clear(250).set(88).clear(100).clear(1000).build().toString(), (Matcher)CoreMatchers.equalTo((Object)"{9, 88}"));
    }

    @Test
    public void testBuilderUseOriginal() {
        ImmutableBitSet fives = ImmutableBitSet.of((int[])new int[]{5, 10, 15});
        ImmutableBitSet fives1 = fives.rebuild().clear(2).set(10).build();
        Assert.assertTrue((fives1 == fives ? 1 : 0) != 0);
        ImmutableBitSet fives2 = ImmutableBitSet.builder().addAll(fives).clear(2).set(10).build(fives);
        Assert.assertTrue((fives2 == fives ? 1 : 0) != 0);
        ImmutableBitSet fives3 = ImmutableBitSet.builder().addAll(fives).clear(2).set(10).build();
        Assert.assertTrue((fives3 != fives ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fives3.equals((Object)fives));
        Assert.assertTrue((boolean)fives3.equals((Object)fives2));
    }

    @Test
    public void testIndexOf() {
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).indexOf(0), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).indexOf(2), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).indexOf(3), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).indexOf(4), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).indexOf(5), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).indexOf(-1), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).indexOf(-2), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)ImmutableBitSet.of().indexOf(-1), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)ImmutableBitSet.of().indexOf(-2), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)ImmutableBitSet.of().indexOf(0), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)ImmutableBitSet.of().indexOf(1000), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testNth() {
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).nth(0), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).nth(1), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 4}).nth(2), (Matcher)CoreMatchers.equalTo((Object)4));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 63}).nth(2), (Matcher)CoreMatchers.equalTo((Object)63));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 64}).nth(2), (Matcher)CoreMatchers.equalTo((Object)64));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{64}).nth(0), (Matcher)CoreMatchers.equalTo((Object)64));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{64, 65}).nth(0), (Matcher)CoreMatchers.equalTo((Object)64));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{64, 65}).nth(1), (Matcher)CoreMatchers.equalTo((Object)65));
        Assert.assertThat((Object)ImmutableBitSet.of((int[])new int[]{64, 128}).nth(1), (Matcher)CoreMatchers.equalTo((Object)128));
        try {
            ImmutableBitSet.of().nth(0);
            Assert.fail((String)"expected throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ImmutableBitSet.of().nth(1);
            Assert.fail((String)"expected throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ImmutableBitSet.of((int[])new int[]{64}).nth(1);
            Assert.fail((String)"expected throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ImmutableBitSet.of((int[])new int[]{64}).nth(-1);
            Assert.fail((String)"expected throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testClosure() {
        TreeMap empty = Maps.newTreeMap();
        Assert.assertThat((Object)ImmutableBitSet.closure((SortedMap)empty), (Matcher)CoreMatchers.equalTo((Object)empty));
        TreeMap map = Maps.newTreeMap();
        map.put(0, ImmutableBitSet.of((int[])new int[]{3}));
        map.put(1, ImmutableBitSet.of());
        map.put(2, ImmutableBitSet.of((int[])new int[]{7}));
        map.put(3, ImmutableBitSet.of((int[])new int[]{4, 12}));
        map.put(4, ImmutableBitSet.of());
        map.put(5, ImmutableBitSet.of());
        map.put(6, ImmutableBitSet.of());
        map.put(7, ImmutableBitSet.of());
        map.put(8, ImmutableBitSet.of());
        map.put(9, ImmutableBitSet.of());
        map.put(10, ImmutableBitSet.of());
        map.put(11, ImmutableBitSet.of());
        map.put(12, ImmutableBitSet.of());
        String original = ((Object)map).toString();
        String expected = "{0={3, 4, 12}, 1={}, 2={7}, 3={3, 4, 12}, 4={4, 12}, 5={}, 6={}, 7={7}, 8={}, 9={}, 10={}, 11={}, 12={4, 12}}";
        Assert.assertThat((Object)ImmutableBitSet.closure((SortedMap)map).toString(), (Matcher)CoreMatchers.equalTo((Object)"{0={3, 4, 12}, 1={}, 2={7}, 3={3, 4, 12}, 4={4, 12}, 5={}, 6={}, 7={7}, 8={}, 9={}, 10={}, 11={}, 12={4, 12}}"));
        Assert.assertThat((String)"argument modified", (Object)((Object)map).toString(), (Matcher)CoreMatchers.equalTo((Object)original));
        TreeMap map2 = Maps.newTreeMap();
        map2.put(0, ImmutableBitSet.of((int[])new int[]{3}));
        map2.put(2, ImmutableBitSet.of((int[])new int[]{7}));
        map2.put(3, ImmutableBitSet.of((int[])new int[]{4, 12}));
        map2.put(9, ImmutableBitSet.of());
        String original2 = ((Object)map2).toString();
        Assert.assertThat((Object)ImmutableBitSet.closure((SortedMap)map2).toString(), (Matcher)CoreMatchers.equalTo((Object)"{0={3, 4, 12}, 1={}, 2={7}, 3={3, 4, 12}, 4={4, 12}, 5={}, 6={}, 7={7}, 8={}, 9={}, 10={}, 11={}, 12={4, 12}}"));
        Assert.assertThat((String)"argument modified", (Object)((Object)map2).toString(), (Matcher)CoreMatchers.equalTo((Object)original2));
    }

    @Test
    public void testPowerSet() {
        ImmutableBitSet empty = ImmutableBitSet.of();
        Assert.assertThat((Object)Iterables.size((Iterable)empty.powerSet()), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)empty.powerSet().toString(), (Matcher)CoreMatchers.equalTo((Object)"[{}]"));
        ImmutableBitSet single = ImmutableBitSet.of((int[])new int[]{2});
        Assert.assertThat((Object)Iterables.size((Iterable)single.powerSet()), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)single.powerSet().toString(), (Matcher)CoreMatchers.equalTo((Object)"[{}, {2}]"));
        ImmutableBitSet two = ImmutableBitSet.of((int[])new int[]{2, 10});
        Assert.assertThat((Object)Iterables.size((Iterable)two.powerSet()), (Matcher)CoreMatchers.equalTo((Object)4));
        Assert.assertThat((Object)two.powerSet().toString(), (Matcher)CoreMatchers.equalTo((Object)"[{}, {10}, {2}, {2, 10}]"));
        ImmutableBitSet seventeen = ImmutableBitSet.range((int)3, (int)20);
        Assert.assertThat((Object)Iterables.size((Iterable)seventeen.powerSet()), (Matcher)CoreMatchers.equalTo((Object)131072));
    }

    @Test
    public void testCreateLongs() {
        Assert.assertThat((Object)ImmutableBitSet.valueOf((long[])new long[]{0L}), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)ImmutableBitSet.valueOf((long[])new long[]{10L}), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of((int[])new int[]{1, 3})));
        Assert.assertThat((Object)ImmutableBitSet.valueOf((long[])new long[]{10L, 0L, 0L}), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of((int[])new int[]{1, 3})));
        Assert.assertThat((Object)ImmutableBitSet.valueOf((long[])new long[]{0L, 0L, 10L, 0L}), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of((int[])new int[]{129, 131})));
    }

    @Test
    public void testCreateLongBuffer() {
        Assert.assertThat((Object)ImmutableBitSet.valueOf((LongBuffer)LongBuffer.wrap(new long[0])), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)ImmutableBitSet.valueOf((LongBuffer)LongBuffer.wrap(new long[]{10L})), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of((int[])new int[]{1, 3})));
        Assert.assertThat((Object)ImmutableBitSet.valueOf((LongBuffer)LongBuffer.wrap(new long[]{0L, 0L, 10L, 0L})), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of((int[])new int[]{129, 131})));
    }

    @Test
    public void testToLongArray() {
        ImmutableBitSet bitSet = ImmutableBitSet.of((int[])new int[]{29, 4, 1969});
        Assert.assertThat((Object)ImmutableBitSet.valueOf((long[])bitSet.toLongArray()), (Matcher)CoreMatchers.equalTo((Object)bitSet));
        Assert.assertThat((Object)ImmutableBitSet.valueOf((LongBuffer)LongBuffer.wrap(bitSet.toLongArray())), (Matcher)CoreMatchers.equalTo((Object)bitSet));
    }

    @Test
    public void testSet() {
        ImmutableBitSet bitSet = ImmutableBitSet.of((int[])new int[]{29, 4, 1969});
        ImmutableBitSet bitSet2 = ImmutableBitSet.of((int[])new int[]{29, 4, 1969, 30});
        Assert.assertThat((Object)bitSet.set(30), (Matcher)CoreMatchers.equalTo((Object)bitSet2));
        Assert.assertThat((Object)bitSet.set(30).set(30), (Matcher)CoreMatchers.equalTo((Object)bitSet2));
        Assert.assertThat((Object)bitSet.set(29), (Matcher)CoreMatchers.equalTo((Object)bitSet));
        Assert.assertThat((Object)bitSet.setIf(30, false), (Matcher)CoreMatchers.equalTo((Object)bitSet));
        Assert.assertThat((Object)bitSet.setIf(30, true), (Matcher)CoreMatchers.equalTo((Object)bitSet2));
    }

    @Test
    public void testClear() {
        ImmutableBitSet bitSet = ImmutableBitSet.of((int[])new int[]{29, 4, 1969});
        ImmutableBitSet bitSet2 = ImmutableBitSet.of((int[])new int[]{4, 1969});
        Assert.assertThat((Object)bitSet.clear(29), (Matcher)CoreMatchers.equalTo((Object)bitSet2));
        Assert.assertThat((Object)bitSet.clear(29).clear(29), (Matcher)CoreMatchers.equalTo((Object)bitSet2));
        Assert.assertThat((Object)bitSet.clear(29).clear(4).clear(29).clear(1969), (Matcher)CoreMatchers.equalTo((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)bitSet.clearIf(29, false), (Matcher)CoreMatchers.equalTo((Object)bitSet));
        Assert.assertThat((Object)bitSet.clearIf(29, true), (Matcher)CoreMatchers.equalTo((Object)bitSet2));
    }

    @Test
    public void testSet2() {
        ImmutableBitSet bitSet = ImmutableBitSet.of((int[])new int[]{29, 4, 1969});
        ImmutableBitSet bitSet2 = ImmutableBitSet.of((int[])new int[]{29, 4, 1969, 30});
        Assert.assertThat((Object)bitSet.set(30, false), (Matcher)CoreMatchers.sameInstance((Object)bitSet));
        Assert.assertThat((Object)bitSet.set(30, true), (Matcher)CoreMatchers.equalTo((Object)bitSet2));
        Assert.assertThat((Object)bitSet.set(29, true), (Matcher)CoreMatchers.sameInstance((Object)bitSet));
    }

    @Test
    public void testShift() {
        ImmutableBitSet bitSet = ImmutableBitSet.of((int[])new int[]{29, 4, 1969});
        Assert.assertThat((Object)bitSet.shift(0), (Matcher)CoreMatchers.is((Object)bitSet));
        Assert.assertThat((Object)bitSet.shift(1), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{30, 5, 1970})));
        Assert.assertThat((Object)bitSet.shift(-4), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{25, 0, 1965})));
        try {
            ImmutableBitSet x = bitSet.shift(-5);
            Assert.fail((String)("Expected error, got " + x));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"-1"));
        }
        ImmutableBitSet empty = ImmutableBitSet.of();
        Assert.assertThat((Object)empty.shift(-100), (Matcher)CoreMatchers.is((Object)empty));
    }

    @Test
    public void testGet2() {
        ImmutableBitSet bitSet = ImmutableBitSet.of((int[])new int[]{29, 4, 1969});
        Assert.assertThat((Object)bitSet.get(0, 8), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{4})));
        Assert.assertThat((Object)bitSet.get(0, 5), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{4})));
        Assert.assertThat((Object)bitSet.get(0, 4), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)bitSet.get(4, 4), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)bitSet.get(5, 5), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)bitSet.get(4, 5), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{4})));
        Assert.assertThat((Object)bitSet.get(4, 1000), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{4, 29})));
        Assert.assertThat((Object)bitSet.get(4, 32), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{4, 29})));
        Assert.assertThat((Object)bitSet.get(2000, 10000), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)bitSet.get(1000, 10000), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{1969})));
        Assert.assertThat((Object)bitSet.get(5, 10000), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{29, 1969})));
        Assert.assertThat((Object)bitSet.get(65, 10000), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of((int[])new int[]{1969})));
        ImmutableBitSet emptyBitSet = ImmutableBitSet.of();
        Assert.assertThat((Object)emptyBitSet.get(0, 4), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)emptyBitSet.get(0, 0), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)emptyBitSet.get(0, 10000), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)emptyBitSet.get(7, 10000), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of()));
        Assert.assertThat((Object)emptyBitSet.get(73, 10000), (Matcher)CoreMatchers.is((Object)ImmutableBitSet.of()));
    }
}

