/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.LinkedHashMultimap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.DataContext;
import org.apache.hive.druid.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.hive.druid.org.apache.calcite.avatica.util.ByteString;
import org.apache.hive.druid.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.linq4j.QueryProvider;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.Strong;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexDynamicParam;
import org.apache.hive.druid.org.apache.calcite.rex.RexExecutor;
import org.apache.hive.druid.org.apache.calcite.rex.RexExecutorImpl;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexLocalRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexProgram;
import org.apache.hive.druid.org.apache.calcite.rex.RexProgramBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexSimplify;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeAssignmentRules;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.util.DateString;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.NlsString;
import org.apache.hive.druid.org.apache.calcite.util.TestUtil;
import org.apache.hive.druid.org.apache.calcite.util.TimeString;
import org.apache.hive.druid.org.apache.calcite.util.TimestampString;
import org.apache.hive.druid.org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RexProgramTest {
    private JavaTypeFactory typeFactory;
    private RexBuilder rexBuilder;
    private RexLiteral trueLiteral;
    private RexLiteral falseLiteral;
    private RexNode nullLiteral;
    private RexNode unknownLiteral;
    private RexSimplify simplify;

    @Before
    public void setUp() {
        this.typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);
        RexExecutorImpl executor = new RexExecutorImpl((DataContext)new DummyTestDataContext());
        this.simplify = new RexSimplify(this.rexBuilder, RelOptPredicateList.EMPTY, false, (RexExecutor)executor);
        this.trueLiteral = this.rexBuilder.makeLiteral(true);
        this.falseLiteral = this.rexBuilder.makeLiteral(false);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        this.nullLiteral = this.rexBuilder.makeNullLiteral(intType);
        this.unknownLiteral = this.rexBuilder.makeNullLiteral(this.trueLiteral.getType());
    }

    private void checkCnf(RexNode node, String expected) {
        Assert.assertThat((Object)RexUtil.toCnf((RexBuilder)this.rexBuilder, (RexNode)node).toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkThresholdCnf(RexNode node, int threshold, String expected) {
        Assert.assertThat((Object)RexUtil.toCnf((RexBuilder)this.rexBuilder, (int)threshold, (RexNode)node).toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkPullFactorsUnchanged(RexNode node) {
        this.checkPullFactors(node, node.toString());
    }

    private void checkPullFactors(RexNode node, String expected) {
        Assert.assertThat((Object)RexUtil.pullFactors((RexBuilder)this.rexBuilder, (RexNode)node).toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkSimplify(RexNode node, String expected) {
        this.checkSimplify2(node, expected, expected);
    }

    private void checkSimplifyUnchanged(RexNode node) {
        this.checkSimplify(node, node.toString());
    }

    private void checkSimplify2(RexNode node, String expected, String expectedFalse) {
        Assert.assertThat((Object)this.simplify.simplify(node).toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
        if (node.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
            Assert.assertThat((Object)this.simplify.withUnknownAsFalse(true).simplify(node).toString(), (Matcher)CoreMatchers.equalTo((Object)expectedFalse));
        }
    }

    private void checkSimplifyFilter(RexNode node, String expected) {
        Assert.assertThat((Object)this.simplify.withUnknownAsFalse(true).simplify(node).toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkSimplifyFilter(RexNode node, RelOptPredicateList predicates, String expected) {
        Assert.assertThat((Object)this.simplify.withUnknownAsFalse(true).withPredicates(predicates).simplify(node).toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private static int nodeCount(RexNode node) {
        int n = 1;
        if (node instanceof RexCall) {
            for (RexNode operand : ((RexCall)node).getOperands()) {
                n += RexProgramTest.nodeCount(operand);
            }
        }
        return n;
    }

    private RexNode isNull(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{node});
    }

    private RexNode isNotNull(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{node});
    }

    private RexNode nullIf(RexNode node1, RexNode node2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NULLIF, new RexNode[]{node1, node2});
    }

    private RexNode not(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{node});
    }

    private RexNode and(RexNode ... nodes) {
        return this.and((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    private RexNode and(Iterable<? extends RexNode> nodes) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, (List)ImmutableList.copyOf(nodes));
    }

    private RexNode or(RexNode ... nodes) {
        return this.or((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    private RexNode or(Iterable<? extends RexNode> nodes) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, (List)ImmutableList.copyOf(nodes));
    }

    private RexNode case_(RexNode ... nodes) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, nodes);
    }

    private RexNode cast(RexNode e, RelDataType type) {
        return this.rexBuilder.makeCast(type, e);
    }

    private RexNode eq(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{n1, n2});
    }

    private RexNode ne(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{n1, n2});
    }

    private RexNode le(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{n1, n2});
    }

    private RexNode lt(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{n1, n2});
    }

    private RexNode ge(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{n1, n2});
    }

    private RexNode gt(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{n1, n2});
    }

    @Test
    public void testBuildProgram() {
        RexProgramBuilder builder = this.createProg(0);
        RexProgram program = builder.getProgram(false);
        String programString = program.toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, $0)], expr#6=[+($t4, $t2)], a=[$t6], b=[$t5])", programString);
        RexProgram normalizedProgram = program.normalize(this.rexBuilder, null);
        String normalizedProgramString = normalizedProgram.toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t0)], a=[$t5], b=[$t6])", normalizedProgramString);
    }

    @Test
    public void testNormalize() {
        RexProgramBuilder builder = this.createProg(0);
        String program = builder.getProgram(true).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t0)], a=[$t5], b=[$t6])", program);
    }

    @Test
    public void testElimDups() {
        RexProgramBuilder builder = this.createProg(1);
        String unnormalizedProgram = builder.getProgram(false).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, 1)], expr#6=[+($0, $t5)], expr#7=[+($t4, $t2)], a=[$t7], b=[$t6])", unnormalizedProgram);
        RexProgramBuilder builder2 = this.createProg(1);
        String program2 = builder2.getProgram(true).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t4)], a=[$t5], b=[$t6])", program2);
    }

    @Test
    public void testSimplifyCondition() {
        RexProgram program = this.createProg(3).getProgram(false);
        Assert.assertThat((Object)program.toString(), (Matcher)CoreMatchers.is((Object)"(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, 1)], expr#6=[+($0, $t5)], expr#7=[+($t4, $t2)], expr#8=[5], expr#9=[>($t2, $t8)], expr#10=[true], expr#11=[IS NOT NULL($t5)], expr#12=[false], expr#13=[null], expr#14=[CASE($t9, $t10, $t11, $t12, $t13)], expr#15=[NOT($t14)], a=[$t7], b=[$t6], $condition=[$t15])"));
        Assert.assertThat((Object)program.normalize(this.rexBuilder, this.simplify).toString(), (Matcher)CoreMatchers.is((Object)"(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t4)], expr#7=[5], expr#8=[>($t4, $t7)], expr#9=[CAST($t8):BOOLEAN], expr#10=[IS FALSE($t9)], a=[$t5], b=[$t6], $condition=[$t10])"));
    }

    @Test
    public void testSimplifyCondition2() {
        RexProgram program = this.createProg(4).getProgram(false);
        Assert.assertThat((Object)program.toString(), (Matcher)CoreMatchers.is((Object)"(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, 1)], expr#6=[+($0, $t5)], expr#7=[+($t4, $t2)], expr#8=[5], expr#9=[>($t2, $t8)], expr#10=[true], expr#11=[IS NOT NULL($t5)], expr#12=[false], expr#13=[null], expr#14=[CASE($t9, $t10, $t11, $t12, $t13)], expr#15=[NOT($t14)], expr#16=[IS TRUE($t15)], a=[$t7], b=[$t6], $condition=[$t16])"));
        Assert.assertThat((Object)program.normalize(this.rexBuilder, this.simplify).toString(), (Matcher)CoreMatchers.is((Object)"(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t4)], expr#7=[5], expr#8=[>($t4, $t7)], expr#9=[CAST($t8):BOOLEAN], expr#10=[IS FALSE($t9)], a=[$t5], b=[$t6], $condition=[$t10])"));
    }

    @Test
    public void testDuplicateAnd() {
        RexProgramBuilder builder = this.createProg(2);
        String program = builder.getProgram(true).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t0)], expr#7=[>($t2, $t0)], a=[$t5], b=[$t6], $condition=[$t7])", program);
    }

    private RexProgramBuilder createProg(int variant) {
        RexLocalRef t1;
        RexLocalRef t5;
        assert (variant >= 0 && variant <= 4);
        List<RelDataType> types = Arrays.asList(this.typeFactory.createSqlType(SqlTypeName.INTEGER), this.typeFactory.createSqlType(SqlTypeName.INTEGER));
        List<String> names = Arrays.asList("x", "y");
        RelDataType inputRowType = this.typeFactory.createStructType(types, names);
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        RexInputRef i0 = this.rexBuilder.makeInputRef(types.get(0), 0);
        RexLiteral c1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral c5 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(5L));
        RexLocalRef t2 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, c1}));
        RexLiteral c77 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(77L));
        RexLocalRef t3 = builder.addExpr((RexNode)c77);
        Util.discard((Object)t3);
        RexInputRef i1 = this.rexBuilder.makeInputRef(types.get(1), 1);
        RexLocalRef t4 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, i1}));
        switch (variant) {
            case 0: 
            case 2: {
                t5 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, i0}));
                t1 = null;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                t1 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, c1}));
                t5 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, t1}));
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected variant " + variant));
            }
        }
        RexLocalRef t6 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{t4, t2}));
        builder.addProject(t6.getIndex(), "a");
        builder.addProject(t5.getIndex(), "b");
        switch (variant) {
            case 2: {
                RexLocalRef t7 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t4, i0}));
                RexLocalRef t8 = builder.addExpr(this.and(new RexNode[]{t7, t7}));
                builder.addCondition((RexNode)t8);
                builder.addCondition((RexNode)t7);
                break;
            }
            case 3: 
            case 4: {
                RexLocalRef t7 = builder.addExpr((RexNode)c5);
                RexLocalRef t8 = builder.addExpr(this.gt((RexNode)t2, (RexNode)t7));
                RexLocalRef t9 = builder.addExpr((RexNode)this.trueLiteral);
                assert (t1 != null);
                RexLocalRef t10 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{t1}));
                RexLocalRef t11 = builder.addExpr((RexNode)this.falseLiteral);
                RexLocalRef t12 = builder.addExpr(this.unknownLiteral);
                RexLocalRef t13 = builder.addExpr(this.case_(new RexNode[]{t8, t9, t10, t11, t12}));
                RexLocalRef t14 = builder.addExpr(this.not((RexNode)t13));
                if (variant == 3) {
                    builder.addCondition((RexNode)t14);
                    break;
                }
                RexLocalRef t15 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, new RexNode[]{t14}));
                builder.addCondition((RexNode)t15);
            }
        }
        return builder;
    }

    @Test
    public void testStrong() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        ImmutableBitSet c = ImmutableBitSet.of();
        ImmutableBitSet c0 = ImmutableBitSet.of((int[])new int[]{0});
        ImmutableBitSet c1 = ImmutableBitSet.of((int[])new int[]{1});
        ImmutableBitSet c01 = ImmutableBitSet.of((int[])new int[]{0, 1});
        ImmutableBitSet c13 = ImmutableBitSet.of((int[])new int[]{1, 3});
        RexInputRef i0 = this.rexBuilder.makeInputRef(intType, 0);
        RexInputRef i1 = this.rexBuilder.makeInputRef(intType, 1);
        Assert.assertThat((Object)Strong.isNull((RexNode)i0, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)i0, (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)i0, (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)i0, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.trueLiteral, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.trueLiteral, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.falseLiteral, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullLiteral, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullLiteral, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.unknownLiteral, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)true));
        RexNode andUnknownTrue = this.and(new RexNode[]{this.unknownLiteral, this.trueLiteral});
        RexNode andTrueUnknown = this.and(new RexNode[]{this.trueLiteral, this.unknownLiteral});
        RexNode andFalseTrue = this.and(new RexNode[]{this.falseLiteral, this.trueLiteral});
        Assert.assertThat((Object)Strong.isNull((RexNode)andUnknownTrue, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)andTrueUnknown, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)andFalseTrue, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, this.isNull((RexNode)i1)}), (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, this.isNull((RexNode)i1)}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, i1}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, i1}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, this.isNull((RexNode)i1)}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.or(new RexNode[]{i0, i1}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.or(new RexNode[]{i0, i1}), (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.or(new RexNode[]{i0, i1}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        RexNode i0NotNull = this.isNotNull((RexNode)i0);
        Assert.assertThat((Object)Strong.isNull((RexNode)i0NotNull, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNotTrue((RexNode)i0NotNull, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)true));
        RexNode notI0NotNull = this.not(this.isNotNull((RexNode)i0));
        Assert.assertThat((Object)Strong.isNull((RexNode)notI0NotNull, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNotTrue((RexNode)notI0NotNull, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf(this.nullLiteral, this.nullLiteral), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf(this.nullLiteral, (RexNode)this.trueLiteral), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf((RexNode)this.trueLiteral, (RexNode)this.trueLiteral), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf((RexNode)this.trueLiteral, (RexNode)this.falseLiteral), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf((RexNode)this.trueLiteral, this.nullLiteral), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.isNull(this.nullLiteral), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.isNull((RexNode)this.trueLiteral), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(this.eq((RexNode)i0, (RexNode)i1), this.nullLiteral, this.ge((RexNode)i0, (RexNode)i1), this.nullLiteral, this.nullLiteral), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), i0, this.ge((RexNode)i0, (RexNode)i1), this.nullLiteral, this.nullLiteral}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), i0, this.ge((RexNode)i0, (RexNode)i1), this.nullLiteral, this.nullLiteral}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), this.nullLiteral, this.ge((RexNode)i0, (RexNode)i1), i0, this.nullLiteral}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), this.nullLiteral, this.ge((RexNode)i0, (RexNode)i1), i0, this.nullLiteral}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), this.nullLiteral, this.ge((RexNode)i0, (RexNode)i1), this.nullLiteral, i0}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), this.nullLiteral, this.ge((RexNode)i0, (RexNode)i1), this.nullLiteral, i0}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.isNotNull((RexNode)i0), i0, i1}), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.isNotNull((RexNode)i0), i0, i1}), (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.isNotNull((RexNode)i0), i0, i1}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.isNotNull((RexNode)i0), i0, i1}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testLosslessCast() {
        RelDataType tinyIntType = this.typeFactory.createSqlType(SqlTypeName.TINYINT);
        RelDataType smallIntType = this.typeFactory.createSqlType(SqlTypeName.SMALLINT);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType bigIntType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        RelDataType floatType = this.typeFactory.createSqlType(SqlTypeName.FLOAT);
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType charType5 = this.typeFactory.createSqlType(SqlTypeName.CHAR, 5);
        RelDataType charType6 = this.typeFactory.createSqlType(SqlTypeName.CHAR, 6);
        RelDataType varCharType10 = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 10);
        RelDataType varCharType11 = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 11);
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeInputRef(intType, 0)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(tinyIntType, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(smallIntType, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(bigIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(bigIntType, (RexNode)this.rexBuilder.makeInputRef(floatType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(booleanType, (RexNode)this.rexBuilder.makeInputRef(bigIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(charType5, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(varCharType10, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType10, (RexNode)this.rexBuilder.makeInputRef(varCharType11, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(charType5, (RexNode)this.rexBuilder.makeInputRef(bigIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(charType5, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType10, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(smallIntType, (RexNode)this.rexBuilder.makeInputRef(tinyIntType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(bigIntType, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(charType6, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType10, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType11, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType11, (RexNode)this.rexBuilder.makeInputRef(charType6, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType11, (RexNode)this.rexBuilder.makeInputRef(varCharType10, 0))), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCnf() {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", booleanType).add("b", booleanType).add("c", booleanType).add("d", booleanType).add("e", booleanType).add("f", booleanType).add("g", booleanType).add("h", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode eRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexNode fRef = this.rexBuilder.makeFieldAccess((RexNode)range, 5);
        RexNode gRef = this.rexBuilder.makeFieldAccess((RexNode)range, 6);
        RexNode hRef = this.rexBuilder.makeFieldAccess((RexNode)range, 7);
        RexLiteral sevenLiteral = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(7L));
        RexNode hEqSeven = this.eq(hRef, (RexNode)sevenLiteral);
        this.checkCnf(aRef, "?0.a");
        this.checkCnf((RexNode)this.trueLiteral, "true");
        this.checkCnf((RexNode)this.falseLiteral, "false");
        this.checkCnf(this.unknownLiteral, "null");
        this.checkCnf(this.and(aRef, bRef), "AND(?0.a, ?0.b)");
        this.checkCnf(this.and(aRef, bRef, cRef), "AND(?0.a, ?0.b, ?0.c)");
        this.checkCnf(this.and(this.or(aRef, bRef), this.or(cRef, dRef)), "AND(OR(?0.a, ?0.b), OR(?0.c, ?0.d))");
        this.checkCnf(this.or(this.and(aRef, bRef), this.and(cRef, dRef)), "AND(OR(?0.a, ?0.c), OR(?0.a, ?0.d), OR(?0.b, ?0.c), OR(?0.b, ?0.d))");
        this.checkCnf(this.or(this.and(aRef, bRef), this.or(cRef, dRef)), "AND(OR(?0.a, ?0.c, ?0.d), OR(?0.b, ?0.c, ?0.d))");
        this.checkCnf(this.or(aRef, this.not(this.and(bRef, this.not(hEqSeven)))), "OR(?0.a, NOT(?0.b), =(?0.h, 7))");
        this.checkCnf(this.not(this.or(aRef, this.not(bRef))), "AND(NOT(?0.a), ?0.b)");
        this.checkCnf(this.not(this.or(new RexNode[]{this.and(new RexNode[]{aRef, this.trueLiteral}), this.not(bRef), this.falseLiteral})), "AND(NOT(?0.a), ?0.b)");
        this.checkCnf(this.and(aRef, this.or(bRef, this.and(cRef, dRef))), "AND(?0.a, OR(?0.b, ?0.c), OR(?0.b, ?0.d))");
        this.checkCnf(this.and(aRef, this.or(bRef, this.and(cRef, this.or(dRef, this.and(eRef, this.or(fRef, gRef)))))), "AND(?0.a, OR(?0.b, ?0.c), OR(?0.b, ?0.d, ?0.e), OR(?0.b, ?0.d, ?0.f, ?0.g))");
        this.checkCnf(this.and(aRef, this.or(bRef, this.and(cRef, this.or(dRef, this.and(eRef, this.or(fRef, this.and(gRef, this.or(new RexNode[]{this.trueLiteral, this.falseLiteral})))))))), "AND(?0.a, OR(?0.b, ?0.c), OR(?0.b, ?0.d, ?0.e), OR(?0.b, ?0.d, ?0.f, ?0.g))");
    }

    @Test
    public void testCnf2() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("x", intType).add("y", intType).add("z", intType).add("a", intType).add("b", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode xRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode yRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode zRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L));
        RexLiteral literal2 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L));
        RexLiteral literal3 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L));
        this.checkCnf(this.or(this.and(this.eq(xRef, (RexNode)literal1), this.eq(yRef, (RexNode)literal1), this.eq(zRef, (RexNode)literal1)), this.and(this.eq(xRef, (RexNode)literal2), this.eq(yRef, (RexNode)literal2), this.eq(aRef, (RexNode)literal2)), this.and(this.eq(xRef, (RexNode)literal3), this.eq(aRef, (RexNode)literal3), this.eq(bRef, (RexNode)literal3))), "AND(OR(=(?0.x, 1), =(?0.x, 2), =(?0.x, 3)), OR(=(?0.x, 1), =(?0.x, 2), =(?0.a, 3)), OR(=(?0.x, 1), =(?0.x, 2), =(?0.b, 3)), OR(=(?0.x, 1), =(?0.y, 2), =(?0.x, 3)), OR(=(?0.x, 1), =(?0.y, 2), =(?0.a, 3)), OR(=(?0.x, 1), =(?0.y, 2), =(?0.b, 3)), OR(=(?0.x, 1), =(?0.a, 2), =(?0.x, 3)), OR(=(?0.x, 1), =(?0.a, 2), =(?0.a, 3)), OR(=(?0.x, 1), =(?0.a, 2), =(?0.b, 3)), OR(=(?0.y, 1), =(?0.x, 2), =(?0.x, 3)), OR(=(?0.y, 1), =(?0.x, 2), =(?0.a, 3)), OR(=(?0.y, 1), =(?0.x, 2), =(?0.b, 3)), OR(=(?0.y, 1), =(?0.y, 2), =(?0.x, 3)), OR(=(?0.y, 1), =(?0.y, 2), =(?0.a, 3)), OR(=(?0.y, 1), =(?0.y, 2), =(?0.b, 3)), OR(=(?0.y, 1), =(?0.a, 2), =(?0.x, 3)), OR(=(?0.y, 1), =(?0.a, 2), =(?0.a, 3)), OR(=(?0.y, 1), =(?0.a, 2), =(?0.b, 3)), OR(=(?0.z, 1), =(?0.x, 2), =(?0.x, 3)), OR(=(?0.z, 1), =(?0.x, 2), =(?0.a, 3)), OR(=(?0.z, 1), =(?0.x, 2), =(?0.b, 3)), OR(=(?0.z, 1), =(?0.y, 2), =(?0.x, 3)), OR(=(?0.z, 1), =(?0.y, 2), =(?0.a, 3)), OR(=(?0.z, 1), =(?0.y, 2), =(?0.b, 3)), OR(=(?0.z, 1), =(?0.a, 2), =(?0.x, 3)), OR(=(?0.z, 1), =(?0.a, 2), =(?0.a, 3)), OR(=(?0.z, 1), =(?0.a, 2), =(?0.b, 3)))");
    }

    @Test
    public void testThresholdCnf() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("x", intType).add("y", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode xRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode yRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L));
        RexLiteral literal2 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L));
        RexLiteral literal3 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L));
        RexLiteral literal4 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L));
        this.checkThresholdCnf(this.or(this.eq(xRef, (RexNode)literal1), this.and(this.eq(xRef, (RexNode)literal2), this.eq(yRef, (RexNode)literal3))), 8, "AND(OR(=(?0.x, 1), =(?0.x, 2)), OR(=(?0.x, 1), =(?0.y, 3)))");
        this.checkThresholdCnf(this.or(this.eq(xRef, (RexNode)literal1), this.eq(xRef, (RexNode)literal2), this.and(this.eq(xRef, (RexNode)literal3), this.eq(yRef, (RexNode)literal4))), 8, "OR(=(?0.x, 1), =(?0.x, 2), AND(=(?0.x, 3), =(?0.y, 4)))");
    }

    @Test
    public void testCnfExponential() {
        int limit = CalciteAssert.ENABLE_SLOW ? 16 : 6;
        for (int i = 2; i < limit; ++i) {
            this.checkExponentialCnf(i);
        }
    }

    private void checkExponentialCnf(int n) {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataTypeFactory.FieldInfoBuilder builder = this.typeFactory.builder();
        for (int i = 0; i < n; ++i) {
            builder.add("x" + i, booleanType).add("y" + i, booleanType);
        }
        RelDataType rowType3 = builder.build();
        RexDynamicParam range3 = this.rexBuilder.makeDynamicParam(rowType3, 0);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            list.add(this.and(this.rexBuilder.makeFieldAccess((RexNode)range3, i * 2), this.rexBuilder.makeFieldAccess((RexNode)range3, i * 2 + 1)));
        }
        RexNode cnf = RexUtil.toCnf((RexBuilder)this.rexBuilder, (RexNode)this.or(list));
        int nodeCount = RexProgramTest.nodeCount(cnf);
        Assert.assertThat((Object)((n + 1) * (int)Math.pow(2.0, n) + 1), (Matcher)CoreMatchers.equalTo((Object)nodeCount));
        if (n == 3) {
            Assert.assertThat((Object)cnf.toString(), (Matcher)CoreMatchers.equalTo((Object)"AND(OR(?0.x0, ?0.x1, ?0.x2), OR(?0.x0, ?0.x1, ?0.y2), OR(?0.x0, ?0.y1, ?0.x2), OR(?0.x0, ?0.y1, ?0.y2), OR(?0.y0, ?0.x1, ?0.x2), OR(?0.y0, ?0.x1, ?0.y2), OR(?0.y0, ?0.y1, ?0.x2), OR(?0.y0, ?0.y1, ?0.y2))"));
        }
    }

    @Test
    public void testPullFactors() {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", booleanType).add("b", booleanType).add("c", booleanType).add("d", booleanType).add("e", booleanType).add("f", booleanType).add("g", booleanType).add("h", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode eRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexNode fRef = this.rexBuilder.makeFieldAccess((RexNode)range, 5);
        RexNode gRef = this.rexBuilder.makeFieldAccess((RexNode)range, 6);
        RexNode hRef = this.rexBuilder.makeFieldAccess((RexNode)range, 7);
        RexLiteral sevenLiteral = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(7L));
        RexNode hEqSeven = this.eq(hRef, (RexNode)sevenLiteral);
        this.checkPullFactors(this.or(this.and(aRef, bRef), this.and(cRef, aRef, dRef, aRef)), "AND(?0.a, OR(?0.b, AND(?0.c, ?0.d)))");
        this.checkPullFactors(aRef, "?0.a");
        this.checkPullFactors((RexNode)this.trueLiteral, "true");
        this.checkPullFactors((RexNode)this.falseLiteral, "false");
        this.checkPullFactors(this.unknownLiteral, "null");
        this.checkPullFactors(this.and(aRef, bRef), "AND(?0.a, ?0.b)");
        this.checkPullFactors(this.and(aRef, bRef, cRef), "AND(?0.a, ?0.b, ?0.c)");
        this.checkPullFactorsUnchanged(this.and(this.or(aRef, bRef), this.or(cRef, dRef)));
        this.checkPullFactorsUnchanged(this.or(this.and(aRef, bRef), this.and(cRef, dRef)));
        this.checkPullFactors(this.or(this.and(aRef, bRef), this.or(cRef, dRef)), "OR(AND(?0.a, ?0.b), ?0.c, ?0.d)");
        this.checkPullFactorsUnchanged(this.or(aRef, this.not(this.and(bRef, this.not(hEqSeven)))));
        this.checkPullFactorsUnchanged(this.not(this.or(aRef, this.not(bRef))));
        this.checkPullFactorsUnchanged(this.not(this.or(new RexNode[]{this.and(new RexNode[]{aRef, this.trueLiteral}), this.not(bRef), this.falseLiteral})));
        this.checkPullFactorsUnchanged(this.and(aRef, this.or(bRef, this.and(cRef, dRef))));
        this.checkPullFactorsUnchanged(this.and(aRef, this.or(bRef, this.and(cRef, this.or(dRef, this.and(eRef, this.or(fRef, gRef)))))));
        this.checkPullFactorsUnchanged(this.and(aRef, this.or(bRef, this.and(cRef, this.or(dRef, this.and(eRef, this.or(fRef, this.and(gRef, this.or(new RexNode[]{this.trueLiteral, this.falseLiteral})))))))));
    }

    @Test
    public void testSimplify() {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType intNullableType = this.typeFactory.createTypeWithNullability(intType, true);
        RelDataType rowType = this.typeFactory.builder().add("a", booleanType).add("b", booleanType).add("c", booleanType).add("d", booleanType).add("e", booleanType).add("f", booleanType).add("g", booleanType).add("h", intType).add("i", intNullableType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode eRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexNode hRef = this.rexBuilder.makeFieldAccess((RexNode)range, 7);
        RexNode iRef = this.rexBuilder.makeFieldAccess((RexNode)range, 8);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        this.checkSimplify(this.and(aRef, bRef, aRef), "AND(?0.a, ?0.b)");
        this.checkSimplify(this.and(new RexNode[]{aRef, bRef, this.trueLiteral}), "AND(?0.a, ?0.b)");
        this.checkSimplify(this.and(new RexNode[]{aRef, bRef, this.falseLiteral}), "false");
        this.checkSimplify(this.and(this.not(aRef), bRef, this.not(cRef), this.not(aRef)), "AND(?0.b, NOT(?0.a), NOT(?0.c))");
        this.checkSimplify(this.and(this.not(aRef), bRef, this.not((RexNode)this.trueLiteral)), "false");
        this.checkSimplify(this.and(aRef, this.and(this.and(bRef, this.not(cRef), dRef, this.not(eRef)), this.not(eRef))), "AND(?0.a, ?0.b, ?0.d, NOT(?0.c), NOT(?0.e))");
        this.checkSimplify(this.and(aRef, bRef, this.not(this.or(cRef, this.or(dRef, eRef)))), "AND(?0.a, ?0.b, NOT(?0.c), NOT(?0.d), NOT(?0.e))");
        this.checkSimplify(this.and(aRef, bRef, this.not(this.or(this.not(cRef), dRef, this.not(eRef)))), "AND(?0.a, ?0.b, ?0.c, ?0.e, NOT(?0.d))");
        this.checkSimplify(this.or(aRef, bRef, aRef), "OR(?0.a, ?0.b)");
        this.checkSimplify(this.or(new RexNode[]{aRef, bRef, this.falseLiteral}), "OR(?0.a, ?0.b)");
        this.checkSimplify(this.or(new RexNode[]{aRef, bRef, this.trueLiteral}), "true");
        this.checkSimplify(this.case_(new RexNode[]{this.eq(bRef, cRef), dRef, this.falseLiteral, aRef, eRef}), "CASE(=(?0.b, ?0.c), ?0.d, ?0.e)");
        this.checkSimplify(this.case_(new RexNode[]{this.eq(bRef, cRef), dRef, this.trueLiteral, aRef, this.eq(cRef, dRef), eRef, cRef}), "CASE(=(?0.b, ?0.c), ?0.d, ?0.a)");
        this.checkSimplify(this.case_(new RexNode[]{this.trueLiteral, aRef, this.eq(cRef, dRef), eRef, cRef}), "?0.a");
        this.checkSimplify(this.case_(new RexNode[]{aRef, literal1, bRef, literal1, cRef, literal1, dRef, literal1, literal1}), "1");
        this.checkSimplify2(this.case_(new RexNode[]{aRef, this.trueLiteral, bRef, this.trueLiteral, cRef, this.falseLiteral, this.unknownLiteral}), "CASE(?0.a, true, ?0.b, true, ?0.c, false, null)", "CAST(OR(?0.a, ?0.b)):BOOLEAN");
        this.checkSimplify(this.case_(new RexNode[]{aRef, this.trueLiteral, bRef, this.falseLiteral, cRef, this.falseLiteral, dRef, this.trueLiteral, this.falseLiteral}), "OR(?0.a, AND(?0.d, NOT(?0.b), NOT(?0.c)))");
        this.checkSimplify(this.case_(new RexNode[]{aRef, this.trueLiteral, bRef, this.falseLiteral, cRef, this.falseLiteral, dRef, this.trueLiteral, eRef, this.falseLiteral, this.trueLiteral}), "OR(?0.a, AND(?0.d, NOT(?0.b), NOT(?0.c)), AND(NOT(?0.b), NOT(?0.c), NOT(?0.e)))");
        this.checkSimplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{aRef}), "false");
        this.checkSimplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{aRef}), "true");
        this.checkSimplify2(this.and(this.le(aRef, (RexNode)literal1), this.gt(aRef, (RexNode)literal1)), "AND(<=(?0.a, 1), >(?0.a, 1))", "false");
        this.checkSimplify(this.and(this.le(aRef, (RexNode)literal1), this.ge(aRef, (RexNode)literal1)), "AND(<=(?0.a, 1), >=(?0.a, 1))");
        this.checkSimplify2(this.and(this.lt(aRef, (RexNode)literal1), this.eq(aRef, (RexNode)literal1), this.ge(aRef, (RexNode)literal1)), "AND(<(?0.a, 1), =(?0.a, 1), >=(?0.a, 1))", "false");
        this.checkSimplify(this.and(this.lt(aRef, (RexNode)literal1), this.or(new RexNode[]{this.falseLiteral, this.falseLiteral})), "false");
        this.checkSimplify(this.and(this.lt(aRef, (RexNode)literal1), this.or(new RexNode[]{this.falseLiteral, this.gt(bRef, cRef)})), "AND(<(?0.a, 1), >(?0.b, ?0.c))");
        this.checkSimplify(this.or(this.lt(aRef, (RexNode)literal1), this.and(new RexNode[]{this.trueLiteral, this.trueLiteral})), "true");
        this.checkSimplify(this.or(this.lt(aRef, (RexNode)literal1), this.and(new RexNode[]{this.trueLiteral, this.or(new RexNode[]{this.trueLiteral, this.falseLiteral})})), "true");
        this.checkSimplify(this.or(this.lt(aRef, (RexNode)literal1), this.and(new RexNode[]{this.trueLiteral, this.and(new RexNode[]{this.trueLiteral, this.falseLiteral})})), "<(?0.a, 1)");
        this.checkSimplify(this.or(this.lt(aRef, (RexNode)literal1), this.and(new RexNode[]{this.trueLiteral, this.or(new RexNode[]{this.falseLiteral, this.falseLiteral})})), "<(?0.a, 1)");
        this.checkSimplify(this.eq((RexNode)literal1, (RexNode)literal1), "true");
        this.checkSimplify(this.eq(hRef, hRef), "true");
        this.checkSimplify2(this.eq(iRef, iRef), "=(?0.i, ?0.i)", "IS NOT NULL(?0.i)");
        this.checkSimplify(this.eq(iRef, hRef), "=(?0.i, ?0.h)");
        this.checkSimplify(this.le((RexNode)literal1, (RexNode)literal1), "true");
        this.checkSimplify(this.le(hRef, hRef), "true");
        this.checkSimplify2(this.le(iRef, iRef), "<=(?0.i, ?0.i)", "IS NOT NULL(?0.i)");
        this.checkSimplify(this.le(iRef, hRef), "<=(?0.i, ?0.h)");
        this.checkSimplify(this.ge((RexNode)literal1, (RexNode)literal1), "true");
        this.checkSimplify(this.ge(hRef, hRef), "true");
        this.checkSimplify2(this.ge(iRef, iRef), ">=(?0.i, ?0.i)", "IS NOT NULL(?0.i)");
        this.checkSimplify(this.ge(iRef, hRef), ">=(?0.i, ?0.h)");
        this.checkSimplify(this.ne((RexNode)literal1, (RexNode)literal1), "false");
        this.checkSimplify(this.ne(hRef, hRef), "false");
        this.checkSimplify2(this.ne(iRef, iRef), "<>(?0.i, ?0.i)", "false");
        this.checkSimplify(this.ne(iRef, hRef), "<>(?0.i, ?0.h)");
        this.checkSimplify(this.lt((RexNode)literal1, (RexNode)literal1), "false");
        this.checkSimplify(this.lt(hRef, hRef), "false");
        this.checkSimplify2(this.lt(iRef, iRef), "<(?0.i, ?0.i)", "false");
        this.checkSimplify(this.lt(iRef, hRef), "<(?0.i, ?0.h)");
        this.checkSimplify(this.gt((RexNode)literal1, (RexNode)literal1), "false");
        this.checkSimplify(this.gt(hRef, hRef), "false");
        this.checkSimplify2(this.gt(iRef, iRef), ">(?0.i, ?0.i)", "false");
        this.checkSimplify(this.gt(iRef, hRef), ">(?0.i, ?0.h)");
    }

    @Test
    public void testSimplifyFilter() {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", booleanType).add("b", booleanType).add("c", booleanType).add("d", booleanType).add("e", booleanType).add("f", booleanType).add("g", booleanType).add("h", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral literal5 = this.rexBuilder.makeExactLiteral(new BigDecimal(5));
        RexLiteral literal10 = this.rexBuilder.makeExactLiteral(BigDecimal.TEN);
        this.checkSimplifyFilter(this.and(this.le(aRef, (RexNode)literal1), this.gt(aRef, (RexNode)literal1)), "false");
        this.checkSimplifyFilter(this.and(this.le(aRef, (RexNode)literal1), this.ge(aRef, (RexNode)literal1)), "AND(<=(?0.a, 1), >=(?0.a, 1))");
        this.checkSimplifyFilter(this.and(this.lt(aRef, (RexNode)literal1), this.eq(aRef, (RexNode)literal1), this.ge(aRef, (RexNode)literal1)), "false");
        this.checkSimplifyFilter(this.and(this.eq(this.eq(aRef, (RexNode)literal1), (RexNode)this.trueLiteral), this.eq(bRef, (RexNode)literal1)), "AND(=(?0.a, 1), =(?0.b, 1))");
        this.checkSimplifyFilter(this.and(this.eq(aRef, (RexNode)literal1), this.eq(bRef, (RexNode)literal1), this.eq(aRef, bRef)), "AND(=(?0.a, 1), =(?0.b, 1))");
        this.checkSimplifyFilter(this.and(this.eq(aRef, (RexNode)literal1), this.eq(bRef, (RexNode)literal10), this.eq(aRef, bRef)), "false");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal10), this.ge(bRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10)), "false");
        this.checkSimplifyFilter(this.or(this.gt(aRef, (RexNode)literal10), this.gt(bRef, (RexNode)literal1), this.gt(aRef, (RexNode)literal10)), "OR(>(?0.a, 10), >(?0.b, 1))");
        this.checkSimplifyFilter(this.case_(new RexNode[]{aRef, this.trueLiteral, bRef, this.trueLiteral, cRef, this.falseLiteral, dRef, this.falseLiteral, this.unknownLiteral}), "CAST(OR(?0.a, ?0.b)):BOOLEAN");
        this.checkSimplifyFilter(this.and(this.gt(aRef, this.unknownLiteral), this.ge(bRef, (RexNode)literal1)), "false");
        this.checkSimplifyFilter(this.and(this.lt((RexNode)literal1, aRef), this.lt((RexNode)literal5, aRef)), RelOptPredicateList.EMPTY, "<(5, ?0.a)");
        this.checkSimplifyFilter(this.and(this.lt((RexNode)literal1, aRef), this.lt(aRef, (RexNode)literal5)), RelOptPredicateList.EMPTY, "AND(<(1, ?0.a), <(?0.a, 5))");
        this.checkSimplifyFilter(this.and(this.gt((RexNode)literal1, aRef), this.gt((RexNode)literal5, aRef)), RelOptPredicateList.EMPTY, ">(1, ?0.a)");
        this.checkSimplifyFilter(this.and(this.gt((RexNode)literal1, aRef), this.gt(aRef, (RexNode)literal5)), RelOptPredicateList.EMPTY, "false");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10), this.lt(aRef, (RexNode)literal5)), RelOptPredicateList.EMPTY, "AND(>(?0.a, 1), <(?0.a, 5))");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10), this.lt(aRef, (RexNode)literal5)), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.gt(aRef, (RexNode)literal5))), "false");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10), this.le(aRef, (RexNode)literal5)), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.ge(aRef, (RexNode)literal5))), "=(?0.a, 5)");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10), this.lt(aRef, (RexNode)literal5)), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.lt(bRef, (RexNode)literal10), (Object)this.ge(aRef, (RexNode)literal1))), "AND(>(?0.a, 1), <(?0.a, 5))");
        this.checkSimplifyFilter(this.gt(aRef, (RexNode)literal1), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.lt(bRef, (RexNode)literal10), (Object)this.gt(aRef, (RexNode)literal5))), "true");
        this.checkSimplifyFilter(this.lt(aRef, (RexNode)literal1), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.lt(bRef, (RexNode)literal10), (Object)this.gt(aRef, (RexNode)literal5))), "false");
        this.checkSimplifyFilter(this.gt(aRef, (RexNode)literal5), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.lt(bRef, (RexNode)literal10), (Object)this.ge(aRef, (RexNode)literal5))), ">(?0.a, 5)");
        this.checkSimplifyFilter(this.gt(aRef, (RexNode)literal5), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.le(aRef, (RexNode)literal5))), "false");
        this.checkSimplifyFilter(this.gt(aRef, (RexNode)literal5), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.le(aRef, (RexNode)literal5), (Object)this.le(bRef, (RexNode)literal5))), "false");
        this.checkSimplifyFilter(this.or(this.gt(aRef, (RexNode)literal5), this.gt(bRef, (RexNode)literal5)), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.le(aRef, (RexNode)literal5), (Object)this.le(bRef, (RexNode)literal5))), "false");
    }

    @Test
    public void testSimplifyCaseNotNullableBoolean() {
        RexNode condition = this.eq((RexNode)this.rexBuilder.makeInputRef(this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), true), 0), (RexNode)this.rexBuilder.makeLiteral("S"));
        RexCall caseNode = (RexCall)this.case_(new RexNode[]{condition, this.trueLiteral, this.falseLiteral});
        RexCall result = (RexCall)this.simplify.simplify((RexNode)caseNode);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)CoreMatchers.is((Object)SqlTypeName.BOOLEAN));
        Assert.assertThat((Object)result.getOperator(), (Matcher)CoreMatchers.is((Object)SqlStdOperatorTable.CASE));
        Assert.assertThat((Object)result.getOperands().size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(result.getOperands().get(0), (Matcher)CoreMatchers.is((Object)condition));
        Assert.assertThat(result.getOperands().get(1), (Matcher)CoreMatchers.is((Object)this.trueLiteral));
        Assert.assertThat(result.getOperands().get(2), (Matcher)CoreMatchers.is((Object)this.falseLiteral));
    }

    @Test
    public void testSimplifyCaseNullableBoolean() {
        RexNode condition = this.eq((RexNode)this.rexBuilder.makeInputRef(this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), false), 0), (RexNode)this.rexBuilder.makeLiteral("S"));
        RexCall caseNode = (RexCall)this.case_(new RexNode[]{condition, this.trueLiteral, this.falseLiteral});
        RexCall result = (RexCall)this.simplify.simplify((RexNode)caseNode);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)CoreMatchers.is((Object)SqlTypeName.BOOLEAN));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)condition));
    }

    @Test
    public void testSimplifyCaseNullableVarChar() {
        RexNode condition = this.eq((RexNode)this.rexBuilder.makeInputRef(this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), false), 0), (RexNode)this.rexBuilder.makeLiteral("S"));
        RexLiteral aLiteral = this.rexBuilder.makeLiteral("A");
        RexLiteral bLiteral = this.rexBuilder.makeLiteral("B");
        RexCall caseNode = (RexCall)this.case_(new RexNode[]{condition, aLiteral, bLiteral});
        RexCall result = (RexCall)this.simplify.simplify((RexNode)caseNode);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)CoreMatchers.is((Object)SqlTypeName.CHAR));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)caseNode));
    }

    @Test
    public void testSimplifyAnd() {
        RelDataType booleanNotNullableType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
        RelDataType booleanNullableType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), true);
        RexNode andCondition = this.and(new RexNode[]{this.rexBuilder.makeInputRef(booleanNotNullableType, 0), this.rexBuilder.makeInputRef(booleanNullableType, 1), this.rexBuilder.makeInputRef(booleanNotNullableType, 2)});
        RexNode result = this.simplify.simplify(andCondition);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)CoreMatchers.is((Object)SqlTypeName.BOOLEAN));
    }

    @Test
    public void testSimplifyIsNotNull() {
        RelDataType intType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.INTEGER), false);
        RelDataType intNullableType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.INTEGER), true);
        RexInputRef i0 = this.rexBuilder.makeInputRef(intNullableType, 0);
        RexInputRef i1 = this.rexBuilder.makeInputRef(intNullableType, 1);
        RexInputRef i2 = this.rexBuilder.makeInputRef(intType, 2);
        RexInputRef i3 = this.rexBuilder.makeInputRef(intType, 3);
        RexLiteral one = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral null_ = this.rexBuilder.makeNullLiteral(intType);
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i0, (RexNode)i1)), "AND(IS NOT NULL($0), IS NOT NULL($1))");
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i0, (RexNode)i2)), "IS NOT NULL($0)");
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i2, (RexNode)i3)), "true");
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i0, (RexNode)one)), "IS NOT NULL($0)");
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i0, (RexNode)null_)), "false");
    }

    @Test
    public void testSimplifyCastLiteral() {
        ArrayList<RexLiteral> literals = new ArrayList<RexLiteral>();
        literals.add(this.rexBuilder.makeExactLiteral(BigDecimal.ONE, this.typeFactory.createSqlType(SqlTypeName.INTEGER)));
        literals.add(this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L), this.typeFactory.createSqlType(SqlTypeName.BIGINT)));
        literals.add(this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L), this.typeFactory.createSqlType(SqlTypeName.SMALLINT)));
        literals.add(this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L), this.typeFactory.createSqlType(SqlTypeName.TINYINT)));
        literals.add(this.rexBuilder.makeExactLiteral(new BigDecimal("1234"), this.typeFactory.createSqlType(SqlTypeName.DECIMAL, 4, 0)));
        literals.add(this.rexBuilder.makeExactLiteral(new BigDecimal("123.45"), this.typeFactory.createSqlType(SqlTypeName.DECIMAL, 5, 2)));
        literals.add(this.rexBuilder.makeApproxLiteral(new BigDecimal("3.1415"), this.typeFactory.createSqlType(SqlTypeName.REAL)));
        literals.add(this.rexBuilder.makeApproxLiteral(BigDecimal.valueOf(Math.E), this.typeFactory.createSqlType(SqlTypeName.FLOAT)));
        literals.add(this.rexBuilder.makeApproxLiteral(BigDecimal.valueOf(Math.PI), this.typeFactory.createSqlType(SqlTypeName.DOUBLE)));
        literals.add(this.rexBuilder.makeLiteral(true));
        literals.add(this.rexBuilder.makeLiteral(false));
        literals.add(this.rexBuilder.makeLiteral("hello world"));
        literals.add(this.rexBuilder.makeLiteral("1969-07-20 12:34:56"));
        literals.add(this.rexBuilder.makeLiteral("1969-07-20"));
        literals.add(this.rexBuilder.makeLiteral("12:34:45"));
        literals.add((RexLiteral)this.rexBuilder.makeLiteral((Object)new ByteString(new byte[]{1, 2, -34, 0, -128}), this.typeFactory.createSqlType(SqlTypeName.BINARY, 5), false));
        literals.add(this.rexBuilder.makeDateLiteral(new DateString(1974, 8, 9)));
        literals.add(this.rexBuilder.makeTimeLiteral(new TimeString(1, 23, 45), 0));
        literals.add(this.rexBuilder.makeTimestampLiteral(new TimestampString(1974, 8, 9, 1, 23, 45), 0));
        LinkedHashMultimap map = LinkedHashMultimap.create();
        for (RexLiteral literal : literals) {
            map.put((Object)literal.getTypeName(), (Object)literal);
        }
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        types.add(this.typeFactory.createSqlType(SqlTypeName.INTEGER));
        types.add(this.typeFactory.createSqlType(SqlTypeName.BIGINT));
        types.add(this.typeFactory.createSqlType(SqlTypeName.SMALLINT));
        types.add(this.typeFactory.createSqlType(SqlTypeName.TINYINT));
        types.add(this.typeFactory.createSqlType(SqlTypeName.REAL));
        types.add(this.typeFactory.createSqlType(SqlTypeName.FLOAT));
        types.add(this.typeFactory.createSqlType(SqlTypeName.DOUBLE));
        types.add(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN));
        types.add(this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 10));
        types.add(this.typeFactory.createSqlType(SqlTypeName.CHAR, 5));
        types.add(this.typeFactory.createSqlType(SqlTypeName.VARBINARY, 60));
        types.add(this.typeFactory.createSqlType(SqlTypeName.BINARY, 3));
        types.add(this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP));
        types.add(this.typeFactory.createSqlType(SqlTypeName.TIME));
        types.add(this.typeFactory.createSqlType(SqlTypeName.DATE));
        for (RelDataType fromType : types) {
            for (RelDataType toType : types) {
                if (!SqlTypeAssignmentRules.instance((boolean)false).canCastFrom(toType.getSqlTypeName(), fromType.getSqlTypeName())) continue;
                for (RexLiteral literal : map.get((Object)fromType.getSqlTypeName())) {
                    RexNode cast = this.rexBuilder.makeCast(toType, (RexNode)literal);
                    if (cast instanceof RexLiteral) {
                        Assert.assertThat((Object)cast.getType(), (Matcher)CoreMatchers.is((Object)toType));
                        continue;
                    }
                    RexNode simplified = this.simplify.simplify(cast);
                    boolean expectedSimplify = literal.getTypeName() != toType.getSqlTypeName() || literal.getTypeName() == SqlTypeName.CHAR && ((NlsString)literal.getValue()).getValue().length() > toType.getPrecision() || literal.getTypeName() == SqlTypeName.BINARY && ((ByteString)literal.getValue()).length() > toType.getPrecision();
                    boolean couldSimplify = !cast.equals(simplified);
                    String reason = (expectedSimplify ? "expected to simplify, but could not: " : "simplified, but did not expect to: ") + cast + " --> " + simplified;
                    Assert.assertThat((String)reason, (Object)couldSimplify, (Matcher)CoreMatchers.is((Object)expectedSimplify));
                }
            }
        }
    }

    @Test
    public void testSimplifyCastLiteral2() {
        RexLiteral literalAbc = this.rexBuilder.makeLiteral("abc");
        RexLiteral literalOne = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType varcharType = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 10);
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType dateType = this.typeFactory.createSqlType(SqlTypeName.DATE);
        RelDataType timestampType = this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        this.checkSimplifyUnchanged(this.cast((RexNode)literalAbc, intType));
        this.checkSimplify(this.cast((RexNode)literalOne, intType), "1");
        this.checkSimplify(this.cast((RexNode)literalAbc, varcharType), "'abc'");
        this.checkSimplify(this.cast((RexNode)literalOne, varcharType), "'1'");
        this.checkSimplifyUnchanged(this.cast((RexNode)literalAbc, booleanType));
        this.checkSimplify(this.cast((RexNode)literalOne, booleanType), "false");
        this.checkSimplifyUnchanged(this.cast((RexNode)literalAbc, dateType));
        this.checkSimplify(this.cast((RexNode)literalOne, dateType), "1970-01-02");
        this.checkSimplifyUnchanged(this.cast((RexNode)literalAbc, timestampType));
        this.checkSimplify(this.cast((RexNode)literalOne, timestampType), "1970-01-01 00:00:00");
    }

    @Test
    public void testSimplifyCastLiteral3() {
        RexLiteral literalDate = this.rexBuilder.makeDateLiteral(new DateString("2011-07-20"));
        RexLiteral literalTime = this.rexBuilder.makeTimeLiteral(new TimeString("12:34:56"), 0);
        RexLiteral literalTimestamp = this.rexBuilder.makeTimestampLiteral(new TimestampString("2011-07-20 12:34:56"), 0);
        RexLiteral literalTimeLTZ = this.rexBuilder.makeTimeWithLocalTimeZoneLiteral(new TimeString(1, 23, 45), 0);
        RexLiteral timeLTZChar1 = this.rexBuilder.makeLiteral("12:34:45 America/Los_Angeles");
        RexLiteral timeLTZChar2 = this.rexBuilder.makeLiteral("12:34:45 UTC");
        RexLiteral timeLTZChar3 = this.rexBuilder.makeLiteral("12:34:45 GMT+01");
        RexLiteral timestampLTZChar1 = this.rexBuilder.makeLiteral("2011-07-20 12:34:56 Asia/Tokyo");
        RexLiteral timestampLTZChar2 = this.rexBuilder.makeLiteral("2011-07-20 12:34:56 GMT+01");
        RexLiteral timestampLTZChar3 = this.rexBuilder.makeLiteral("2011-07-20 12:34:56 UTC");
        RexLiteral literalTimestampLTZ = this.rexBuilder.makeTimestampWithLocalTimeZoneLiteral(new TimestampString(2011, 7, 20, 8, 23, 45), 0);
        RelDataType dateType = this.typeFactory.createSqlType(SqlTypeName.DATE);
        RelDataType timeType = this.typeFactory.createSqlType(SqlTypeName.TIME);
        RelDataType timestampType = this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        RelDataType timeLTZType = this.typeFactory.createSqlType(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE);
        RelDataType timestampLTZType = this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        RelDataType varCharType = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 40);
        this.checkSimplify(this.cast((RexNode)timeLTZChar1, timeLTZType), "20:34:45");
        this.checkSimplify(this.cast((RexNode)timeLTZChar2, timeLTZType), "12:34:45");
        this.checkSimplify(this.cast((RexNode)timeLTZChar3, timeLTZType), "11:34:45");
        this.checkSimplify(this.cast((RexNode)literalTimeLTZ, timeLTZType), "01:23:45");
        this.checkSimplify(this.cast((RexNode)timestampLTZChar1, timestampLTZType), "2011-07-20 03:34:56");
        this.checkSimplify(this.cast((RexNode)timestampLTZChar2, timestampLTZType), "2011-07-20 11:34:56");
        this.checkSimplify(this.cast((RexNode)timestampLTZChar3, timestampLTZType), "2011-07-20 12:34:56");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, timestampLTZType), "2011-07-20 08:23:45");
        this.checkSimplify(this.cast((RexNode)literalDate, timestampLTZType), "2011-07-20 07:00:00");
        this.checkSimplify(this.cast((RexNode)literalTime, timestampLTZType), "2011-07-20 19:34:56");
        this.checkSimplify(this.cast((RexNode)literalTimestamp, timestampLTZType), "2011-07-20 19:34:56");
        this.checkSimplify(this.cast((RexNode)literalTimestamp, dateType), "2011-07-20");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, dateType), "2011-07-20");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, timeType), "01:23:45");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, timestampType), "2011-07-20 01:23:45");
        this.checkSimplify(this.cast((RexNode)literalTimeLTZ, timeType), "17:23:45");
        this.checkSimplify(this.cast((RexNode)literalTime, timeLTZType), "20:34:56");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, timeLTZType), "08:23:45");
        this.checkSimplify(this.cast((RexNode)literalTimeLTZ, varCharType), "'17:23:45 America/Los_Angeles'");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, varCharType), "'2011-07-20 01:23:45 America/Los_Angeles'");
        this.checkSimplify(this.cast((RexNode)literalTimeLTZ, timestampType), "2011-07-19 18:23:45");
        this.checkSimplify(this.cast((RexNode)literalTimeLTZ, timestampLTZType), "2011-07-20 01:23:45");
    }

    @Test
    public void testCompareTimestampWithTimeZone() {
        TimestampWithTimeZoneString timestampLTZChar1 = new TimestampWithTimeZoneString("2011-07-20 10:34:56 America/Los_Angeles");
        TimestampWithTimeZoneString timestampLTZChar2 = new TimestampWithTimeZoneString("2011-07-20 19:34:56 Europe/Rome");
        TimestampWithTimeZoneString timestampLTZChar3 = new TimestampWithTimeZoneString("2011-07-20 01:34:56 Asia/Tokyo");
        TimestampWithTimeZoneString timestampLTZChar4 = new TimestampWithTimeZoneString("2011-07-20 10:34:56 America/Los_Angeles");
        Assert.assertThat((Object)timestampLTZChar1.equals((Object)timestampLTZChar2), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)timestampLTZChar1.equals((Object)timestampLTZChar3), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)timestampLTZChar1.equals((Object)timestampLTZChar4), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSimplifyLiterals() {
        RexLiteral literalAbc = this.rexBuilder.makeLiteral("abc");
        RexLiteral literalDef = this.rexBuilder.makeLiteral("def");
        RexLiteral literalZero = this.rexBuilder.makeExactLiteral(BigDecimal.ZERO);
        RexLiteral literalOne = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral literalOneDotZero = this.rexBuilder.makeExactLiteral(new BigDecimal(1.0));
        this.checkSimplify(this.eq((RexNode)literalAbc, (RexNode)literalAbc), "true");
        this.checkSimplify(this.eq((RexNode)literalAbc, (RexNode)literalDef), "false");
        this.checkSimplify(this.ne((RexNode)literalAbc, (RexNode)literalAbc), "false");
        this.checkSimplify(this.ne((RexNode)literalAbc, (RexNode)literalDef), "true");
        this.checkSimplify(this.gt((RexNode)literalAbc, (RexNode)literalDef), "false");
        this.checkSimplify(this.gt((RexNode)literalDef, (RexNode)literalAbc), "true");
        this.checkSimplify(this.gt((RexNode)literalDef, (RexNode)literalDef), "false");
        this.checkSimplify(this.ge((RexNode)literalAbc, (RexNode)literalDef), "false");
        this.checkSimplify(this.ge((RexNode)literalDef, (RexNode)literalAbc), "true");
        this.checkSimplify(this.ge((RexNode)literalDef, (RexNode)literalDef), "true");
        this.checkSimplify(this.lt((RexNode)literalAbc, (RexNode)literalDef), "true");
        this.checkSimplify(this.lt((RexNode)literalAbc, (RexNode)literalDef), "true");
        this.checkSimplify(this.lt((RexNode)literalDef, (RexNode)literalDef), "false");
        this.checkSimplify(this.le((RexNode)literalAbc, (RexNode)literalDef), "true");
        this.checkSimplify(this.le((RexNode)literalDef, (RexNode)literalAbc), "false");
        this.checkSimplify(this.le((RexNode)literalDef, (RexNode)literalDef), "true");
        this.checkSimplify(this.eq((RexNode)literalZero, (RexNode)literalOne), "false");
        this.checkSimplify(this.eq((RexNode)literalOne, (RexNode)literalZero), "false");
        this.checkSimplify(this.ne((RexNode)literalZero, (RexNode)literalOne), "true");
        this.checkSimplify(this.ne((RexNode)literalOne, (RexNode)literalZero), "true");
        this.checkSimplify(this.gt((RexNode)literalZero, (RexNode)literalOne), "false");
        this.checkSimplify(this.gt((RexNode)literalOne, (RexNode)literalZero), "true");
        this.checkSimplify(this.gt((RexNode)literalOne, (RexNode)literalOne), "false");
        this.checkSimplify(this.ge((RexNode)literalZero, (RexNode)literalOne), "false");
        this.checkSimplify(this.ge((RexNode)literalOne, (RexNode)literalZero), "true");
        this.checkSimplify(this.ge((RexNode)literalOne, (RexNode)literalOne), "true");
        this.checkSimplify(this.lt((RexNode)literalZero, (RexNode)literalOne), "true");
        this.checkSimplify(this.lt((RexNode)literalOne, (RexNode)literalZero), "false");
        this.checkSimplify(this.lt((RexNode)literalOne, (RexNode)literalOne), "false");
        this.checkSimplify(this.le((RexNode)literalZero, (RexNode)literalOne), "true");
        this.checkSimplify(this.le((RexNode)literalOne, (RexNode)literalZero), "false");
        this.checkSimplify(this.le((RexNode)literalOne, (RexNode)literalOne), "true");
        this.checkSimplify(this.eq((RexNode)literalOne, (RexNode)literalOneDotZero), "true");
        this.checkSimplify(this.eq((RexNode)literalOneDotZero, (RexNode)literalOne), "true");
        this.checkSimplify(this.ne((RexNode)literalOne, (RexNode)literalOneDotZero), "false");
        this.checkSimplify(this.ne((RexNode)literalOneDotZero, (RexNode)literalOne), "false");
        this.checkSimplifyUnchanged(this.eq((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.eq((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.ne((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.ne((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.gt((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.gt((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.ge((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.ge((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.lt((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.lt((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.le((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.le((RexNode)literalAbc, (RexNode)literalZero));
    }

    @Test
    public void testIsDeterministic() {
        SqlSpecialOperator ndc = new SqlSpecialOperator("NDC", SqlKind.OTHER_FUNCTION, 0, false, ReturnTypes.BOOLEAN, null, null){

            public boolean isDeterministic() {
                return false;
            }
        };
        RexNode n = this.rexBuilder.makeCall((SqlOperator)ndc, new RexNode[0]);
        Assert.assertFalse((boolean)RexUtil.isDeterministic((RexNode)n));
        Assert.assertEquals((long)0L, (long)RexUtil.retainDeterministic((List)RelOptUtil.conjunctions((RexNode)n)).size());
    }

    @Test
    public void testConstantMap() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", intType).add("b", intType).add("c", intType).add("d", intType).add("e", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode eRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral literal2 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L));
        ImmutableMap map = RexUtil.predicateConstants(RexNode.class, (RexBuilder)this.rexBuilder, (List)ImmutableList.of((Object)this.eq(aRef, bRef), (Object)this.eq(cRef, (RexNode)literal1), (Object)this.eq(cRef, aRef), (Object)this.eq(dRef, eRef)));
        Assert.assertThat((Object)RexProgramTest.getString((ImmutableMap<RexNode, RexNode>)map), (Matcher)CoreMatchers.is((Object)"{1=?0.c, ?0.a=?0.b, ?0.b=?0.a, ?0.c=1, ?0.d=?0.e, ?0.e=?0.d}"));
        RexInputRef ref0 = this.rexBuilder.makeInputRef(rowType, 0);
        ImmutableMap map2 = RexUtil.predicateConstants(RexNode.class, (RexBuilder)this.rexBuilder, (List)ImmutableList.of((Object)this.eq((RexNode)ref0, (RexNode)literal1), (Object)this.eq((RexNode)ref0, (RexNode)literal2)));
        Assert.assertThat((Object)RexProgramTest.getString((ImmutableMap<RexNode, RexNode>)map2), (Matcher)CoreMatchers.is((Object)"{}"));
        ImmutableMap map3 = RexUtil.predicateConstants(RexNode.class, (RexBuilder)this.rexBuilder, (List)ImmutableList.of((Object)this.eq(aRef, (RexNode)literal1), (Object)this.eq(aRef, (RexNode)literal2)));
        Assert.assertThat((Object)RexProgramTest.getString((ImmutableMap<RexNode, RexNode>)map3), (Matcher)CoreMatchers.is((Object)"{1=?0.a, 2=?0.a}"));
    }

    private static String getString(ImmutableMap<RexNode, RexNode> map) {
        TreeMap map2 = new TreeMap();
        for (Map.Entry entry : map.entrySet()) {
            map2.put(((RexNode)entry.getKey()).toString(), entry.getValue());
        }
        return map2.toString();
    }

    @Test
    public void testSimplifyNot() {
        RelDataType booleanNullableType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), true);
        RexInputRef booleanInput = this.rexBuilder.makeInputRef(booleanNullableType, 0);
        RexNode isFalse = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_FALSE, new RexNode[]{booleanInput});
        RexCall result = (RexCall)this.simplify(isFalse);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getOperator(), (Matcher)CoreMatchers.is((Object)SqlStdOperatorTable.IS_FALSE));
        Assert.assertThat((Object)result.getOperands().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result.getOperands().get(0), (Matcher)CoreMatchers.is((Object)booleanInput));
        RexNode isFalseIsFalse = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_FALSE, new RexNode[]{isFalse});
        RexCall result2 = (RexCall)this.simplify(isFalseIsFalse);
        Assert.assertThat((Object)result2.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result2.getOperator(), (Matcher)CoreMatchers.is((Object)SqlStdOperatorTable.IS_NOT_FALSE));
        Assert.assertThat((Object)result2.getOperands().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result2.getOperands().get(0), (Matcher)CoreMatchers.is((Object)booleanInput));
    }

    private RexNode simplify(RexNode e) {
        return new RexSimplify(this.rexBuilder, RelOptPredicateList.EMPTY, false, RexUtil.EXECUTOR).simplify(e);
    }

    private static class DummyTestDataContext
    implements DataContext {
        private final ImmutableMap<String, Object> map;

        DummyTestDataContext() {
            this.map = ImmutableMap.of((Object)DataContext.Variable.TIME_ZONE.camelName, (Object)TimeZone.getTimeZone("America/Los_Angeles"), (Object)DataContext.Variable.CURRENT_TIMESTAMP.camelName, (Object)1311120000000L);
        }

        public SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            return this.map.get((Object)name);
        }
    }
}

