/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.stomp;

import org.apache.hive.druid.io.netty.handler.codec.stomp.DefaultStompFrame;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompCommand;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompFrame;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompHeaders;
import org.apache.hive.druid.io.netty.util.AsciiString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultStompFrameTest {
    @Test
    public void testStompFrameCopy() {
        DefaultStompFrame sourceFrame = new DefaultStompFrame(StompCommand.CONNECT);
        Assertions.assertTrue((boolean)sourceFrame.headers().isEmpty());
        sourceFrame.headers().set((Object)StompHeaders.HOST, (Object)"localhost");
        StompFrame copyFrame = sourceFrame.copy();
        Assertions.assertEquals((Object)sourceFrame.headers(), (Object)copyFrame.headers());
        Assertions.assertEquals((Object)sourceFrame.content(), (Object)copyFrame.content());
        AsciiString copyHeaderName = new AsciiString((CharSequence)"foo");
        AsciiString copyHeaderValue = new AsciiString((CharSequence)"bar");
        copyFrame.headers().set((Object)copyHeaderName, (Object)copyHeaderValue);
        Assertions.assertFalse((boolean)sourceFrame.headers().contains((Object)copyHeaderName, (Object)copyHeaderValue));
        Assertions.assertTrue((boolean)copyFrame.headers().contains((Object)copyHeaderName, (Object)copyHeaderValue));
        Assertions.assertEquals((int)1, (int)sourceFrame.headers().size());
        Assertions.assertEquals((int)2, (int)copyFrame.headers().size());
        Assertions.assertNotEquals((Object)sourceFrame.headers(), (Object)copyFrame.headers());
        Assertions.assertTrue((boolean)sourceFrame.release());
        Assertions.assertTrue((boolean)copyFrame.release());
    }
}

