/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.socks;

import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksAuthResponse;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksAuthResponseDecoder;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksAuthStatus;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksCommonTestUtils;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksMessage;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLogger;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLoggerFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SocksAuthResponseDecoderTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SocksAuthResponseDecoderTest.class);

    private static void testSocksAuthResponseDecoderWithDifferentParams(SocksAuthStatus authStatus) {
        logger.debug("Testing SocksAuthResponseDecoder with authStatus: " + authStatus);
        SocksAuthResponse msg = new SocksAuthResponse(authStatus);
        SocksAuthResponseDecoder decoder = new SocksAuthResponseDecoder();
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{decoder});
        SocksCommonTestUtils.writeMessageIntoEmbedder(embedder, (SocksMessage)msg);
        msg = (SocksAuthResponse)embedder.readInbound();
        Assertions.assertSame((Object)msg.authStatus(), (Object)authStatus);
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testSocksCmdResponseDecoder() {
        for (SocksAuthStatus authStatus : SocksAuthStatus.values()) {
            SocksAuthResponseDecoderTest.testSocksAuthResponseDecoderWithDifferentParams(authStatus);
        }
    }
}

