/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelId;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.DefaultChannelId;
import org.apache.hive.druid.io.netty.channel.ServerChannel;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpVersion;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionHandler;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Error;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameAdapter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameCodec;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameInboundWriter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameListener;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2MultiplexHandler;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Settings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class Http2ServerUpgradeCodecTest {
    @Test
    public void testUpgradeToHttp2ConnectionHandler() {
        Http2ServerUpgradeCodecTest.testUpgrade(new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new Http2FrameAdapter()).build(), null);
    }

    @Test
    public void testUpgradeToHttp2FrameCodec() {
        Http2ServerUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)new Http2FrameCodecBuilder(true).build(), null);
    }

    @Test
    public void testUpgradeToHttp2MultiplexCodec() {
        Http2ServerUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)new Http2MultiplexCodecBuilder(true, (ChannelHandler)new HttpInboundHandler()).build(), null);
    }

    @Test
    public void testUpgradeToHttp2FrameCodecWithMultiplexer() {
        Http2ServerUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)new Http2FrameCodecBuilder(true).build(), (ChannelHandler)new Http2MultiplexHandler((ChannelHandler)new HttpInboundHandler()));
    }

    private static void testUpgrade(Http2ConnectionHandler handler, ChannelHandler multiplexer) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.OPTIONS, "*");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"netty.io");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Upgrade, HTTP2-Settings");
        request.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)"h2c");
        request.headers().set("HTTP2-Settings", (Object)"AAMAAABkAAQAAP__");
        ServerChannel parent = (ServerChannel)Mockito.mock(ServerChannel.class);
        EmbeddedChannel channel = new EmbeddedChannel((Channel)parent, (ChannelId)DefaultChannelId.newInstance(), true, false, new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
        ChannelHandlerContext ctx = channel.pipeline().firstContext();
        Http2ServerUpgradeCodec codec = multiplexer == null ? new Http2ServerUpgradeCodec(handler) : new Http2ServerUpgradeCodec((Http2FrameCodec)handler, new ChannelHandler[]{multiplexer});
        Assertions.assertTrue((boolean)codec.prepareUpgradeResponse(ctx, (FullHttpRequest)request, (HttpHeaders)new DefaultHttpHeaders()));
        codec.upgradeTo(ctx, (FullHttpRequest)request);
        channel.flush();
        channel.writeInbound(new Object[]{Http2CodecUtil.connectionPrefaceBuf()});
        Http2FrameInboundWriter writer = new Http2FrameInboundWriter(channel);
        writer.writeInboundSettings(new Http2Settings());
        writer.writeInboundRstStream(1, Http2Error.CANCEL.code());
        Assertions.assertSame((Object)handler, (Object)channel.pipeline().remove(handler.getClass()));
        Assertions.assertNull((Object)channel.pipeline().get(handler.getClass()));
        Assertions.assertTrue((boolean)channel.finish());
        ByteBuf settingsBuffer = (ByteBuf)channel.readOutbound();
        Assertions.assertNotNull((Object)settingsBuffer);
        settingsBuffer.release();
        ByteBuf buf = (ByteBuf)channel.readOutbound();
        Assertions.assertNotNull((Object)buf);
        buf.release();
        Assertions.assertNull((Object)channel.readOutbound());
    }

    @ChannelHandler.Sharable
    private static final class HttpInboundHandler
    extends ChannelInboundHandlerAdapter {
        private HttpInboundHandler() {
        }
    }
}

