/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.dns;

import java.util.Random;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.dns.DefaultDnsQuery;
import org.apache.hive.druid.io.netty.handler.codec.dns.DefaultDnsQuestion;
import org.apache.hive.druid.io.netty.handler.codec.dns.DefaultDnsRawRecord;
import org.apache.hive.druid.io.netty.handler.codec.dns.DefaultDnsResponse;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsOpCode;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsQuery;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsQuestion;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsRawRecord;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsRecord;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsRecordType;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsResponse;
import org.apache.hive.druid.io.netty.handler.codec.dns.DnsSection;
import org.apache.hive.druid.io.netty.handler.codec.dns.TcpDnsQueryDecoder;
import org.apache.hive.druid.io.netty.handler.codec.dns.TcpDnsResponseEncoder;
import org.apache.hive.druid.io.netty.util.ReferenceCountUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TcpDnsTest {
    private static final String QUERY_DOMAIN = "www.example.com";
    private static final long TTL = 600L;
    private static final byte[] QUERY_RESULT = new byte[]{-64, -88, 1, 1};

    @Test
    public void testQueryDecode() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new TcpDnsQueryDecoder()});
        int randomID = new Random().nextInt(59000) + 1000;
        DnsQuery query = new DefaultDnsQuery(randomID, DnsOpCode.QUERY).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion(QUERY_DOMAIN, DnsRecordType.A));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{query}));
        DnsQuery readQuery = (DnsQuery)channel.readInbound();
        MatcherAssert.assertThat((Object)readQuery, (Matcher)Matchers.is((Object)query));
        MatcherAssert.assertThat((Object)readQuery.recordAt(DnsSection.QUESTION).name(), (Matcher)Matchers.is((Object)query.recordAt(DnsSection.QUESTION).name()));
        readQuery.release();
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testResponseEncode() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new TcpDnsResponseEncoder()});
        int randomID = new Random().nextInt(59000) + 1000;
        DnsQuery query = new DefaultDnsQuery(randomID, DnsOpCode.QUERY).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion(QUERY_DOMAIN, DnsRecordType.A));
        DnsQuestion question = (DnsQuestion)query.recordAt(DnsSection.QUESTION);
        channel.writeInbound(new Object[]{TcpDnsTest.newResponse(query, question, new byte[][]{QUERY_RESULT})});
        DnsResponse readResponse = (DnsResponse)channel.readInbound();
        MatcherAssert.assertThat((Object)readResponse.recordAt(DnsSection.QUESTION), (Matcher)Matchers.is((Object)question));
        DefaultDnsRawRecord record = new DefaultDnsRawRecord(question.name(), DnsRecordType.A, 600L, Unpooled.wrappedBuffer((byte[])QUERY_RESULT));
        MatcherAssert.assertThat((Object)readResponse.recordAt(DnsSection.ANSWER), (Matcher)Matchers.is((Object)record));
        MatcherAssert.assertThat((Object)((DnsRawRecord)readResponse.recordAt(DnsSection.ANSWER)).content(), (Matcher)Matchers.is((Object)record.content()));
        ReferenceCountUtil.release((Object)readResponse);
        ReferenceCountUtil.release((Object)record);
        query.release();
        Assertions.assertFalse((boolean)channel.finish());
    }

    private static DefaultDnsResponse newResponse(DnsQuery query, DnsQuestion question, byte[] ... addresses) {
        DefaultDnsResponse response = new DefaultDnsResponse(query.id());
        response.addRecord(DnsSection.QUESTION, (DnsRecord)question);
        for (byte[] address : addresses) {
            DefaultDnsRawRecord queryAnswer = new DefaultDnsRawRecord(question.name(), DnsRecordType.A, 600L, Unpooled.wrappedBuffer((byte[])address));
            response.addRecord(DnsSection.ANSWER, (DnsRecord)queryAnswer);
        }
        return response;
    }
}

