/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.log;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.io.CharStreams;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.log.FileRequestLogger;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileRequestLoggerTest {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final String HOST = "localhost";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testLog() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        DateTime dateTime = DateTimes.nowUtc();
        File logDir = this.temporaryFolder.newFolder();
        String actualLogString = dateTime.toString() + "\t" + HOST;
        FileRequestLogger fileRequestLogger = new FileRequestLogger(objectMapper, this.scheduler, logDir);
        fileRequestLogger.start();
        RequestLogLine requestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)requestLogLine.getLine((ObjectMapper)EasyMock.anyObject())).andReturn((Object)actualLogString).anyTimes();
        EasyMock.replay((Object[])new Object[]{requestLogLine});
        fileRequestLogger.log(requestLogLine);
        File logFile = new File(logDir, dateTime.toString("yyyy-MM-dd'.log'"));
        String logString = CharStreams.toString((Readable)Files.newBufferedReader(logFile.toPath(), StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)logString.contains(actualLogString));
        fileRequestLogger.stop();
    }
}

