/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.hive.druid.io.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorSegmentKiller;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DruidCoordinatorSegmentKillerTest {
    @Test
    public void testFindIntervalForKillTask() {
        this.testFindIntervalForKillTask(null, null);
        this.testFindIntervalForKillTask((List<Interval>)ImmutableList.of(), null);
        this.testFindIntervalForKillTask((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014/2015")), Intervals.of((String)"2014/2015"));
        this.testFindIntervalForKillTask((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014/2015"), (Object)Intervals.of((String)"2016/2017")), Intervals.of((String)"2014/2017"));
        this.testFindIntervalForKillTask((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014/2015"), (Object)Intervals.of((String)"2015/2016")), Intervals.of((String)"2014/2016"));
        this.testFindIntervalForKillTask((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2016"), (Object)Intervals.of((String)"2014/2015")), Intervals.of((String)"2014/2016"));
        this.testFindIntervalForKillTask((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2017"), (Object)Intervals.of((String)"2014/2016")), Intervals.of((String)"2014/2017"));
        this.testFindIntervalForKillTask((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2019"), (Object)Intervals.of((String)"2014/2016"), (Object)Intervals.of((String)"2018/2020")), Intervals.of((String)"2014/2020"));
        this.testFindIntervalForKillTask((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2019"), (Object)Intervals.of((String)"2014/2016"), (Object)Intervals.of((String)"2018/2020"), (Object)Intervals.of((String)"2021/2022")), Intervals.of((String)"2014/2022"));
    }

    private void testFindIntervalForKillTask(List<Interval> segmentManagerResult, Interval expected) {
        MetadataSegmentManager segmentManager = (MetadataSegmentManager)EasyMock.createMock(MetadataSegmentManager.class);
        EasyMock.expect((Object)segmentManager.getUnusedSegmentIntervals(EasyMock.anyString(), (Interval)EasyMock.anyObject(Interval.class), EasyMock.anyInt())).andReturn(segmentManagerResult);
        EasyMock.replay((Object[])new Object[]{segmentManager});
        IndexingServiceClient indexingServiceClient = (IndexingServiceClient)EasyMock.createMock(IndexingServiceClient.class);
        DruidCoordinatorSegmentKiller coordinatorSegmentKiller = new DruidCoordinatorSegmentKiller(segmentManager, indexingServiceClient, (DruidCoordinatorConfig)new TestDruidCoordinatorConfig(null, null, Duration.parse((String)"PT76400S"), new Duration(1L), Duration.parse((String)"PT86400S"), Duration.parse((String)"PT86400S"), 1000, null, false, false, Duration.ZERO));
        Assert.assertEquals((Object)expected, (Object)coordinatorSegmentKiller.findIntervalForKillTask("test", 10000));
    }
}

